/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.schedule;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.RecordsManagementSearchBehaviour;
import org.alfresco.module.org_alfresco_module_rm.model.rma.aspect.FrozenAspect;
import org.alfresco.module.org_alfresco_module_rm.query.RecordsManagementQueryDAO;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class UpdateRecordScheduleGet
extends AbstractWebScript
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(UpdateRecordScheduleGet.class);
    private static final String PARAM_MAX_RECORD_FOLDERS = "maxRecordFolders";
    private static final String PARAM_RECORD_FOLDER = "recordFolder";
    private static final String SUCCESS_STATUS = "success";
    private static final String MODEL_STATUS = "responsestatus";
    private static final String MODEL_MESSAGE = "message";
    private static final String MESSAGE_ALL_TEMPLATE = "Updated {0} records from {1} folders with updated disposition instructions.";
    private static final String MESSAGE_FOLDER_TEMPLATE = "Updated records in folder {0} with updated disposition instructions.";
    private NodeService nodeService;
    private DispositionService dispositionService;
    private RecordService recordService;
    private TransactionService transactionService;
    private RecordsManagementQueryDAO recordsManagementQueryDAO;
    private BehaviourFilter behaviourFilter;
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private FrozenAspect frozenAspect;
    private RecordsManagementSearchBehaviour recordsManagementSearchBehaviour;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRecordsManagementQueryDAO(RecordsManagementQueryDAO recordsManagementQueryDAO) {
        this.recordsManagementQueryDAO = recordsManagementQueryDAO;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setFrozenAspect(FrozenAspect frozenAspect) {
        this.frozenAspect = frozenAspect;
    }

    public void setRecordsManagementSearchBehaviour(RecordsManagementSearchBehaviour recordsManagementSearchBehaviour) {
        this.recordsManagementSearchBehaviour = recordsManagementSearchBehaviour;
    }

    protected Map<String, Object> buildModel(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String message;
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                UpdateRecordScheduleGet.this.qnameDAO.getOrCreateQName(RecordsManagementModel.ASPECT_DISPOSITION_PROCESSED);
                return null;
            }
        }, false, true);
        int maxRecordFolders = this.getMaxRecordFolders(req);
        NodeRef recordFolder = this.getRecordFolder(req);
        int processedRecords = 0;
        if (recordFolder != null) {
            this.updateRecordFolder(recordFolder);
            message = MessageFormat.format(MESSAGE_FOLDER_TEMPLATE, recordFolder);
        } else {
            int processedRecordFolders = 0;
            int queryBatchSize = 10000;
            Long maxNodeId = this.nodeDAO.getMaxNodeId();
            Long i = 0L;
            while (i < maxNodeId) {
                List<NodeRef> folders = this.recordsManagementQueryDAO.getRecordFoldersWithSchedules(i, i + (long)queryBatchSize);
                for (NodeRef folder : folders) {
                    processedRecords += this.updateRecordFolder(folder);
                    if (++processedRecordFolders < maxRecordFolders) continue;
                    break;
                }
                if (processedRecordFolders >= maxRecordFolders) break;
                i = i + (long)queryBatchSize;
            }
            message = MessageFormat.format(MESSAGE_ALL_TEMPLATE, processedRecords, processedRecordFolders);
        }
        model.put(MODEL_STATUS, SUCCESS_STATUS);
        model.put(MODEL_MESSAGE, message);
        logger.info((Object)message);
        return model;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String format = req.getFormat();
        try {
            String location;
            String mimetype = this.getContainer().getFormatRegistry().getMimeType(req.getAgent(), format);
            if (mimetype == null) {
                throw new WebScriptException("Web Script format '" + format + "' is not registered");
            }
            Status status = new Status();
            Cache cache = new Cache(this.getDescription().getRequiredCache());
            Map<String, Object> model = this.buildModel(req, res);
            if (model == null) {
                return;
            }
            model.put("status", status);
            model.put("cache", cache);
            Map templateModel = this.createTemplateParameters(req, res, model);
            int statusCode = status.getCode();
            if (statusCode != 200 && !req.forceSuccessStatus()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Force success status header in response: " + req.forceSuccessStatus()));
                    logger.debug((Object)("Setting status " + statusCode));
                }
                res.setStatus(statusCode);
            }
            if ((location = status.getLocation()) != null && location.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting location to " + location));
                }
                res.setHeader("Location", location);
            }
            res.setCache(cache);
            String callback = null;
            if (this.getContainer().allowCallbacks()) {
                callback = req.getJSONCallback();
            }
            if (format.equals("json") && callback != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rendering JSON callback response: content type=" + Format.JAVASCRIPT.mimetype() + ", status=" + statusCode + ", callback=" + callback));
                }
                res.setContentType(Format.JAVASCRIPT.mimetype() + ";charset=UTF-8");
                res.getWriter().write(callback + "(");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rendering response: content type=" + mimetype + ", status=" + statusCode));
                }
                res.setContentType(mimetype + ";charset=UTF-8");
            }
            this.renderFormatTemplate(format, templateModel, res.getWriter());
            if (format.equals("json") && callback != null) {
                res.getWriter().write(")");
            }
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                StringWriter stack = new StringWriter();
                e.printStackTrace(new PrintWriter(stack));
                logger.debug((Object)("Caught exception; decorating with appropriate status template : " + stack.toString()));
            }
            throw this.createStatusException(e, req, res);
        }
    }

    protected void renderFormatTemplate(String format, Map<String, Object> model, Writer writer) {
        format = format == null ? "" : format;
        String templatePath = this.getDescription().getId() + "." + format;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendering template '" + templatePath + "'"));
        }
        this.renderTemplate(templatePath, model, writer);
    }

    protected int getMaxRecordFolders(WebScriptRequest req) {
        String valueStr = req.getParameter(PARAM_MAX_RECORD_FOLDERS);
        int value = Integer.MAX_VALUE;
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    protected NodeRef getRecordFolder(WebScriptRequest req) {
        String valueStr = req.getParameter(PARAM_RECORD_FOLDER);
        NodeRef value = null;
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            value = new NodeRef(valueStr);
        }
        return value;
    }

    private int updateRecordFolder(final NodeRef recordFolder) {
        return (Integer)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            public Integer execute() throws Throwable {
                int recordCount = 0;
                UpdateRecordScheduleGet.this.frozenAspect.disableOnPropUpdateFrozenAspect();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.info((Object)("Checking folder: " + recordFolder));
                    }
                    recordCount = (Integer)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

                        public Integer doWork() throws Exception {
                            DispositionSchedule schedule = UpdateRecordScheduleGet.this.dispositionService.getDispositionSchedule(recordFolder);
                            int innerRecordCount = 0;
                            if (schedule != null && schedule.isRecordLevelDisposition()) {
                                List<NodeRef> records = UpdateRecordScheduleGet.this.recordService.getRecords(recordFolder);
                                for (NodeRef record : records) {
                                    if (UpdateRecordScheduleGet.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE) || !recordFolder.equals((Object)UpdateRecordScheduleGet.this.nodeService.getPrimaryParent(record).getParentRef())) continue;
                                    if (logger.isDebugEnabled()) {
                                        logger.info((Object)("updating record: " + record));
                                    }
                                    UpdateRecordScheduleGet.this.dispositionService.updateNextDispositionAction(record, schedule);
                                    UpdateRecordScheduleGet.this.recordsManagementSearchBehaviour.onAddDispositionLifecycleAspect(record, null);
                                    ++innerRecordCount;
                                }
                            }
                            return innerRecordCount;
                        }
                    });
                    UpdateRecordScheduleGet.this.nodeService.addAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_PROCESSED, null);
                }
                finally {
                    UpdateRecordScheduleGet.this.frozenAspect.enableOnPropUpdateFrozenAspect();
                }
                return recordCount;
            }
        }, false, true);
    }
}

