/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.Set;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.BeforeDeleteChildAssociationRuleTrigger;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtendedBeforeDeleteChildAssociationRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.BeforeDeleteChildAssociationPolicy {
    private static Log logger = LogFactory.getLog(BeforeDeleteChildAssociationRuleTrigger.class);
    private static final String POLICY = "beforeDeleteChildAssociation";
    private boolean isClassBehaviour = false;

    public void setIsClassBehaviour(boolean isClassBehaviour) {
        this.isClassBehaviour = isClassBehaviour;
    }

    public void registerRuleTrigger() {
        if (this.isClassBehaviour) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY), (Object)this, (Behaviour)new JavaBehaviour((Object)this, POLICY, Behaviour.NotificationFrequency.FIRST_EVENT));
        } else {
            this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)POLICY), (Object)this, (Behaviour)new JavaBehaviour((Object)this, POLICY, Behaviour.NotificationFrequency.FIRST_EVENT));
        }
    }

    public void beforeDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        if (!this.areRulesEnabled()) {
            return;
        }
        NodeRef childNodeRef = childAssocRef.getChildRef();
        Set renamedNodeRefSet = TransactionalResourceHelper.getSet((Object)"RuleTrigger.RenamedNodes");
        if (renamedNodeRefSet.contains(childNodeRef)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Single child assoc trigger (policy = beforeDeleteChildAssociation) fired for parent node " + childAssocRef.getParentRef() + " and child node " + childAssocRef.getChildRef()));
        }
        this.triggerRules(childAssocRef.getParentRef(), childNodeRef);
    }
}

