/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.security;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.audit.event.AuditEvent;
import org.alfresco.module.org_alfresco_module_rm.capability.RMPermissionModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.security.FilePlanPermissionService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@BehaviourBean
public class FilePlanPermissionServiceImpl
extends ServiceBaseImpl
implements FilePlanPermissionService,
RMPermissionModel,
NodeServicePolicies.OnMoveNodePolicy {
    private static final String AUDIT_SET_PERMISSION = "set-permission";
    private static final String AUDIT_NAMESPACE = "audit://permissions/";
    private PermissionService permissionService;
    private OwnableService ownableService;
    private PolicyComponent policyComponent;
    private AuthorityService authorityService;
    private FilePlanRoleService filePlanRoleService;
    private FilePlanService filePlanService;
    private RecordsManagementAuditService recordsManagementAuditService;
    private static final Log LOGGER = LogFactory.getLog(FilePlanPermissionServiceImpl.class);

    public void init() {
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, ASPECT_RECORD, (Behaviour)new JavaBehaviour((Object)this, "onAddRecord", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, ASPECT_RECORD, (Behaviour)new JavaBehaviour((Object)this, "onMoveRecord", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, TYPE_RECORD_CATEGORY, (Behaviour)new JavaBehaviour((Object)this, "onMoveNode", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                FilePlanPermissionServiceImpl.this.recordsManagementAuditService.registerAuditEvent(new AuditEvent(FilePlanPermissionServiceImpl.AUDIT_SET_PERMISSION, "rm.audit.set-permission"));
                return null;
            }
        });
    }

    protected PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    protected OwnableService getOwnableService() {
        return this.ownableService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public FilePlanRoleService getFilePlanRoleService() {
        return this.filePlanRoleService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public FilePlanService getFilePlanService() {
        return this.filePlanService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setRecordsManagementAuditService(RecordsManagementAuditService recordsManagementAuditService) {
        this.recordsManagementAuditService = recordsManagementAuditService;
    }

    @Override
    public void setupRecordCategoryPermissions(NodeRef recordCategory) {
        ParameterCheck.mandatory((String)"recordCategory", (Object)recordCategory);
        if (!this.instanceOf(recordCategory, TYPE_RECORD_CATEGORY)) {
            throw new AlfrescoRuntimeException("Unable to setup record category permissions, because node is not a record category.");
        }
        NodeRef parentNodeRef = this.nodeService.getPrimaryParent(recordCategory).getParentRef();
        this.setupPermissions(parentNodeRef, recordCategory);
    }

    @org.alfresco.repo.policy.annotation.Behaviour(type="rma:unfiledRecordFolder", kind=BehaviourKind.CLASS, policy="alf:onCreateNode", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateUnfiledRecordFolder(ChildAssociationRef childAssocRef) {
        ParameterCheck.mandatory((String)"childAssocRef", (Object)childAssocRef);
        this.setupPermissions(childAssocRef.getParentRef(), childAssocRef.getChildRef());
    }

    @org.alfresco.repo.policy.annotation.Behaviour(type="rma:recordFolder", kind=BehaviourKind.CLASS, policy="alf:onCreateNode", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateRecordFolder(ChildAssociationRef childAssocRef) {
        ParameterCheck.mandatory((String)"childAssocRef", (Object)childAssocRef);
        this.setupPermissions(childAssocRef.getParentRef(), childAssocRef.getChildRef());
    }

    @org.alfresco.repo.policy.annotation.Behaviour(type="rma:hold", kind=BehaviourKind.CLASS, policy="alf:onCreateNode", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateHold(ChildAssociationRef childAssocRef) {
        this.createContainerElement(childAssocRef);
    }

    @org.alfresco.repo.policy.annotation.Behaviour(type="rma:transfer", kind=BehaviourKind.CLASS, policy="alf:onCreateNode", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onCreateTransfer(ChildAssociationRef childAssocRef) {
        this.createContainerElement(childAssocRef);
    }

    private void createContainerElement(ChildAssociationRef childAssocRef) {
        ParameterCheck.mandatory((String)"childAssocRef", (Object)childAssocRef);
        NodeRef childRef = childAssocRef.getChildRef();
        this.setupPermissions(childAssocRef.getParentRef(), childRef);
        this.grantFilingPermissionToCreator(childRef);
    }

    private void grantFilingPermissionToCreator(final NodeRef nodeRef) {
        final String user = AuthenticationUtil.getFullyAuthenticatedUser();
        boolean hasUserPermission = this.authenticationUtil.runAs(new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() {
                return FilePlanPermissionServiceImpl.this.getPermissionService().hasPermission(nodeRef, "Filing") == AccessStatus.ALLOWED;
            }
        }, user);
        if (!hasUserPermission) {
            this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    FilePlanPermissionServiceImpl.this.getPermissionService().setPermission(nodeRef, user, "Filing", true);
                    return null;
                }
            });
        }
    }

    @Override
    public void setupPermissions(final NodeRef parent, final NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"parent", (Object)parent);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        if (this.nodeService.exists(nodeRef) && this.nodeService.exists(parent)) {
            this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    boolean isParentNodeFilePlan = FilePlanPermissionServiceImpl.this.isRecordCategory(nodeRef) && FilePlanPermissionServiceImpl.this.isFilePlan(parent);
                    boolean inheritanceAllowed = FilePlanPermissionServiceImpl.this.isInheritanceAllowed(nodeRef, isParentNodeFilePlan);
                    FilePlanPermissionServiceImpl.this.getPermissionService().setInheritParentPermissions(nodeRef, inheritanceAllowed);
                    HashSet<AccessPermission> keepPerms = new HashSet<AccessPermission>(5);
                    Set origionalPerms = FilePlanPermissionServiceImpl.this.getPermissionService().getAllSetPermissions(nodeRef);
                    for (AccessPermission perm : origionalPerms) {
                        if (!perm.getAuthority().startsWith("GROUP_IPR")) continue;
                        keepPerms.add(perm);
                    }
                    FilePlanPermissionServiceImpl.this.getPermissionService().clearPermission(nodeRef, null);
                    for (AccessPermission keeper : keepPerms) {
                        FilePlanPermissionServiceImpl.this.setPermission(nodeRef, keeper.getAuthority(), keeper.getPermission());
                    }
                    if (!inheritanceAllowed) {
                        String adminRole = FilePlanPermissionServiceImpl.this.getAdminRole(nodeRef);
                        FilePlanPermissionServiceImpl.this.getPermissionService().setPermission(nodeRef, adminRole, "Filing", true);
                    }
                    FilePlanPermissionServiceImpl.this.getOwnableService().setOwner(nodeRef, "");
                    if (isParentNodeFilePlan) {
                        Set perms = FilePlanPermissionServiceImpl.this.permissionService.getAllSetPermissions(parent);
                        for (AccessPermission perm : perms) {
                            if (!"Filing".equals(perm.getPermission())) continue;
                            AccessStatus accessStatus = perm.getAccessStatus();
                            boolean allow = false;
                            if (AccessStatus.ALLOWED.equals((Object)accessStatus)) {
                                allow = true;
                            }
                            FilePlanPermissionServiceImpl.this.permissionService.setPermission(nodeRef, perm.getAuthority(), perm.getPermission(), allow);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private String getAdminRole(NodeRef nodeRef) {
        NodeRef filePlan = this.getFilePlan(nodeRef);
        if (filePlan == null) {
            throw new AlfrescoRuntimeException("The file plan could not be found for the give node: '" + nodeRef + "'.");
        }
        return this.authorityService.getName(AuthorityType.GROUP, "Administrator" + filePlan.getId());
    }

    private boolean isInheritanceAllowed(NodeRef nodeRef, Boolean isParentNodeFilePlan) {
        return !this.isFilePlan(nodeRef) && !this.isTransfer(nodeRef) && !this.isHold(nodeRef) && !this.isUnfiledRecordsContainer(nodeRef) && (!this.isRecordCategory(nodeRef) || !BooleanUtils.isTrue((Boolean)isParentNodeFilePlan));
    }

    public void onAddRecord(final NodeRef record, final QName aspectTypeQName) {
        ParameterCheck.mandatory((String)"childAssocRef", (Object)record);
        ParameterCheck.mandatory((String)"childAssocRef", (Object)aspectTypeQName);
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                if (FilePlanPermissionServiceImpl.this.nodeService.exists(record) && FilePlanPermissionServiceImpl.this.nodeService.hasAspect(record, aspectTypeQName)) {
                    NodeRef recordFolder = FilePlanPermissionServiceImpl.this.nodeService.getPrimaryParent(record).getParentRef();
                    FilePlanPermissionServiceImpl.this.setupPermissions(recordFolder, record);
                }
                return null;
            }
        });
    }

    public void onMoveRecord(final ChildAssociationRef sourceAssocRef, final ChildAssociationRef destinationAssocRef) {
        ParameterCheck.mandatory((String)"sourceAssocRef", (Object)sourceAssocRef);
        ParameterCheck.mandatory((String)"destinationAssocRef", (Object)destinationAssocRef);
        this.authenticationUtil.runAs(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                NodeRef record = sourceAssocRef.getChildRef();
                if (FilePlanPermissionServiceImpl.this.nodeService.exists(record) && FilePlanPermissionServiceImpl.this.nodeService.hasAspect(record, RecordsManagementModel.ASPECT_RECORD)) {
                    boolean inheritParentPermissions = FilePlanPermissionServiceImpl.this.permissionService.getInheritParentPermissions(record);
                    HashSet<AccessPermission> keepPerms = new HashSet<AccessPermission>(5);
                    Set origionalRecordPerms = FilePlanPermissionServiceImpl.this.permissionService.getAllSetPermissions(record);
                    for (AccessPermission recordPermission : origionalRecordPerms) {
                        String permission = recordPermission.getPermission();
                        if (!"Filing".equals(permission) && !"ReadRecords".equals(permission) || !recordPermission.isSetDirectly()) continue;
                        keepPerms.add(recordPermission);
                    }
                    FilePlanPermissionServiceImpl.this.setupPermissions(destinationAssocRef.getParentRef(), record);
                    for (AccessPermission keeper : keepPerms) {
                        FilePlanPermissionServiceImpl.this.setPermission(record, keeper.getAuthority(), keeper.getPermission());
                    }
                    FilePlanPermissionServiceImpl.this.permissionService.setInheritParentPermissions(record, inheritParentPermissions);
                }
                return null;
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    @Override
    public void setPermission(final NodeRef nodeRef, final String authority, final String permission) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"authority", (Object)authority);
        ParameterCheck.mandatory((String)"permission", (Object)permission);
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Object>(){

            public Void doWork() {
                if (FilePlanPermissionServiceImpl.this.canPerformPermissionAction(nodeRef)) {
                    QName auditProperty = FilePlanPermissionServiceImpl.this.constructAuditEventName(authority, permission);
                    Map<QName, Serializable> oldPermission = FilePlanPermissionServiceImpl.this.getCurrentPermissionForAuthority(nodeRef, authority, permission, auditProperty);
                    FilePlanPermissionServiceImpl.this.getPermissionService().setPermission(nodeRef, authority, permission, true);
                    FilePlanPermissionServiceImpl.this.recordsManagementAuditService.auditOrUpdateEvent(nodeRef, FilePlanPermissionServiceImpl.AUDIT_SET_PERMISSION, oldPermission, new HashMap<QName, Serializable>(Collections.singletonMap(auditProperty, true)), true);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Setting permissions for this node is not supported.  (nodeRef=" + nodeRef + ", authority=" + authority + ", permission=" + permission + ")"));
                }
                return null;
            }
        });
    }

    private Map<QName, Serializable> getCurrentPermissionForAuthority(NodeRef nodeRef, String authority, String permission, QName auditProperty) {
        Set allSetPermissions = this.getPermissionService().getAllSetPermissions(nodeRef);
        for (AccessPermission setPermission : allSetPermissions) {
            if (!setPermission.getAuthority().equals(authority) || !setPermission.getPermission().equals(permission)) continue;
            return new HashMap<QName, Serializable>(Collections.singletonMap(auditProperty, true));
        }
        return new HashMap<QName, Serializable>(Collections.singletonMap(auditProperty, false));
    }

    @Override
    public void deletePermission(final NodeRef nodeRef, final String authority, final String permission) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"authority", (Object)authority);
        ParameterCheck.mandatory((String)"permission", (Object)permission);
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Object>(){

            public Void doWork() {
                if (FilePlanPermissionServiceImpl.this.canPerformPermissionAction(nodeRef)) {
                    QName auditProperty = FilePlanPermissionServiceImpl.this.constructAuditEventName(authority, permission);
                    Map<QName, Serializable> oldPermission = FilePlanPermissionServiceImpl.this.getCurrentPermissionForAuthority(nodeRef, authority, permission, auditProperty);
                    FilePlanPermissionServiceImpl.this.getPermissionService().deletePermission(nodeRef, authority, permission);
                    FilePlanPermissionServiceImpl.this.recordsManagementAuditService.auditOrUpdateEvent(nodeRef, FilePlanPermissionServiceImpl.AUDIT_SET_PERMISSION, oldPermission, new HashMap<QName, Serializable>(Collections.singletonMap(auditProperty, false)), true);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Deleting permissions for this node is not supported.  (nodeRef=" + nodeRef + ", authority=" + authority + ", permission=" + permission + ")"));
                }
                return null;
            }
        });
    }

    private QName constructAuditEventName(String authority, String permission) {
        return QName.createQName((String)AUDIT_NAMESPACE, (String)(permission + " " + authority));
    }

    private boolean canPerformPermissionAction(NodeRef nodeRef) {
        return this.isFilePlanContainer(nodeRef) || this.isRecordFolder(nodeRef) || this.isRecord(nodeRef) || this.isTransfer(nodeRef) || this.isHold(nodeRef);
    }

    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (this.isFilePlan(newChildAssocRef.getParentRef())) {
            this.permissionService.setInheritParentPermissions(oldChildAssocRef.getChildRef(), false);
        }
    }
}

