/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.admin;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RoleDeclarativeWebScript
extends DeclarativeWebScript {
    protected FilePlanService filePlanService;
    protected FilePlanRoleService filePlanRoleService;
    protected AuthorityService authorityService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    protected NodeRef getFilePlan(WebScriptRequest req) {
        NodeRef filePlan = null;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String siteId = (String)templateVars.get("siteid");
        if (siteId != null) {
            filePlan = this.filePlanService.getFilePlanBySiteId(siteId);
        }
        if (filePlan == null) {
            StoreRef storeRef;
            NodeRef nodeRef;
            String storeType = (String)templateVars.get("store_type");
            String storeId = (String)templateVars.get("store_id");
            String id = (String)templateVars.get("id");
            if (!StringUtils.isEmpty((CharSequence)storeType) && !StringUtils.isEmpty((CharSequence)storeId) && !StringUtils.isEmpty((CharSequence)id) && this.filePlanService.isFilePlan(nodeRef = new NodeRef(storeRef = new StoreRef(storeType, storeId), id))) {
                filePlan = nodeRef;
            }
        }
        if (filePlan == null) {
            filePlan = this.filePlanService.getFilePlanBySiteId("rm");
        }
        return filePlan;
    }

    protected Set<RoleItem> createRoleItems(NodeRef filePlan, Set<Role> roles) {
        return this.createRoleItems(filePlan, roles, false);
    }

    protected Set<RoleItem> createRoleItems(NodeRef filePlan, Set<Role> roles, boolean showAuths) {
        HashSet<RoleItem> items = new HashSet<RoleItem>(roles.size());
        for (Role role : roles) {
            RoleItem item = null;
            item = showAuths ? new RoleItem(role, this.createAuthorityItems(this.filePlanRoleService.getUsersAssignedToRole(filePlan, role.getName())), this.createAuthorityItems(this.filePlanRoleService.getGroupsAssignedToRole(filePlan, role.getName()))) : new RoleItem(role);
            items.add(item);
        }
        return items;
    }

    private Set<AuthorityItem> createAuthorityItems(Set<String> authorities) {
        HashSet<AuthorityItem> result = new HashSet<AuthorityItem>(authorities.size());
        Iterator<String> iterator = authorities.iterator();
        while (iterator.hasNext()) {
            String authority;
            String displayLabel = authority = iterator.next();
            if (!AuthorityType.getAuthorityType((String)authority).equals((Object)AuthorityType.USER)) {
                displayLabel = this.authorityService.getAuthorityDisplayName(authority);
            }
            result.add(new AuthorityItem(authority, displayLabel));
        }
        return result;
    }

    public class AuthorityItem {
        private String name;
        private String displayLabel;

        public AuthorityItem(String name, String displayLabel) {
            this.name = name;
            this.displayLabel = displayLabel;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayLabel() {
            return this.displayLabel;
        }
    }

    public class RoleItem {
        private String name;
        private String groupShortName;
        private String displayLabel;
        private Set<Capability> capabilities;
        private boolean showAuths = false;
        private Set<AuthorityItem> assignedUsers;
        private Set<AuthorityItem> assignedGroups;

        public RoleItem(Role role) {
            this.name = role.getName();
            this.displayLabel = role.getDisplayLabel();
            this.capabilities = role.getCapabilities();
        }

        public RoleItem(Role role, Set<AuthorityItem> assignedUsers, Set<AuthorityItem> assignedGroups) {
            this.name = role.getName();
            this.groupShortName = role.getGroupShortName();
            this.displayLabel = role.getDisplayLabel();
            this.capabilities = role.getCapabilities();
            this.showAuths = true;
            this.assignedUsers = assignedUsers;
            this.assignedGroups = assignedGroups;
        }

        public String getName() {
            return this.name;
        }

        public String getGroupShortName() {
            return this.groupShortName;
        }

        public String getDisplayLabel() {
            return this.displayLabel;
        }

        public Set<Capability> getCapabilities() {
            return this.capabilities;
        }

        public boolean getShowAuths() {
            return this.showAuths;
        }

        public Set<AuthorityItem> getAssignedGroups() {
            return this.assignedGroups;
        }

        public Set<AuthorityItem> getAssignedUsers() {
            return this.assignedUsers;
        }
    }
}

