/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.script.BaseTransferWebScript;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

@Deprecated
public class TransferReportPost
extends BaseTransferWebScript {
    private static Log logger = LogFactory.getLog(TransferReportPost.class);
    protected static final String REPORT_FILE_PREFIX = "report_";
    protected static final String REPORT_FILE_SUFFIX = ".html";
    protected static final String PARAM_DESTINATION = "destination";
    protected static final String RESPONSE_SUCCESS = "success";
    protected static final String RESPONSE_RECORD = "record";
    protected static final String RESPONSE_RECORD_NAME = "recordName";
    protected DictionaryService ddService;
    protected RecordsManagementActionService rmActionService;
    protected DispositionService dispositionService;
    protected ContentService contentService;

    public void setDictionaryService(DictionaryService ddService) {
        this.ddService = ddService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordsManagementActionService(RecordsManagementActionService rmActionService) {
        this.rmActionService = rmActionService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    protected File executeTransfer(NodeRef transferNode, WebScriptRequest req, WebScriptResponse res, Status status, Cache cache) throws IOException {
        File report = null;
        String format = req.getFormat();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("status", status);
        model.put("cache", cache);
        try {
            JSONObject json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            if (!json.has(PARAM_DESTINATION)) {
                status.setCode(400, "Mandatory 'destination' parameter has not been supplied");
                Map templateModel = this.createTemplateParameters(req, res, model);
                this.sendStatus(req, res, status, cache, format, templateModel);
                return null;
            }
            String destinationParam = json.getString(PARAM_DESTINATION);
            NodeRef destination = new NodeRef(destinationParam);
            if (!this.nodeService.exists(destination)) {
                status.setCode(404, "Node " + destination.toString() + " does not exist");
                Map templateModel = this.createTemplateParameters(req, res, model);
                this.sendStatus(req, res, status, cache, format, templateModel);
                return null;
            }
            if (!RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)this.nodeService.getType(destination))) {
                status.setCode(400, "Node " + destination.toString() + " is not a record folder");
                Map templateModel = this.createTemplateParameters(req, res, model);
                this.sendStatus(req, res, status, cache, format, templateModel);
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Filing transfer report as record in record folder: " + destination));
            }
            report = this.generateHTMLTransferReport(transferNode);
            NodeRef record = this.fileTransferReport(report, destination);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Filed transfer report as new record: " + record));
            }
            JSONObject responseJSON = new JSONObject();
            responseJSON.put(RESPONSE_SUCCESS, record != null);
            if (record != null) {
                responseJSON.put(RESPONSE_RECORD, (Object)record.toString());
                responseJSON.put(RESPONSE_RECORD_NAME, (Object)((String)((Object)this.nodeService.getProperty(record, ContentModel.PROP_NAME))));
            }
            String jsonString = responseJSON.toString();
            res.setContentType("application/json");
            res.setContentEncoding("UTF-8");
            res.setHeader("Content-Length", Long.toString(jsonString.length()));
            res.getWriter().write(jsonString);
        }
        catch (JSONException je) {
            throw this.createStatusException(je, req, res);
        }
        return report;
    }

    File generateHTMLTransferReport(NodeRef transferNode) throws IOException {
        File report = TempFileProvider.createTempFile((String)REPORT_FILE_PREFIX, (String)REPORT_FILE_SUFFIX);
        try (FileOutputStream fileOutputStream = new FileOutputStream(report);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));){
            DispositionSchedule ds;
            NodeRef[] itemsToTransfer = this.getTransferNodes(transferNode);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Generating HTML transfer report for " + itemsToTransfer.length + " items into file: " + report.getAbsolutePath()));
            }
            String dispositionAuthority = null;
            if (itemsToTransfer.length > 0 && (ds = this.dispositionService.getDispositionSchedule(itemsToTransfer[0])) != null) {
                dispositionAuthority = ds.getDispositionAuthority();
            }
            writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
            writer.write("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n");
            Boolean isAccession = (Boolean)this.nodeService.getProperty(transferNode, PROP_TRANSFER_ACCESSION_INDICATOR);
            if (isAccession.booleanValue()) {
                writer.write("<title>Accession Report</title></head>\n");
            } else {
                writer.write("<title>Transfer Report</title></head>\n");
            }
            writer.write("<style>\n");
            writer.write("body { font-family: arial,verdana; font-size: 81%; color: #333; }\n");
            writer.write(".records { margin-left: 20px; margin-top: 10px; }\n");
            writer.write(".record { padding: 5px; }\n");
            writer.write(".label { color: #111; }\n");
            writer.write(".nodeName { font-weight: bold; }\n");
            writer.write(".transferred-item { background-color: #eee; padding: 10px; margin-bottom: 15px; }\n");
            writer.write("</style>\n");
            if (isAccession.booleanValue()) {
                writer.write("<body>\n<h1>Accession Report</h1>\n");
            } else {
                writer.write("<body>\n<h1>Transfer Report</h1>\n");
            }
            writer.write("<table cellpadding=\"3\" cellspacing=\"3\">");
            writer.write("<tr><td class=\"label\">Transfer Date:</td><td>");
            Date transferDate = (Date)this.nodeService.getProperty(transferNode, ContentModel.PROP_CREATED);
            writer.write(StringEscapeUtils.escapeHtml4((String)transferDate.toString()));
            writer.write("</td></tr>");
            writer.write("<tr><td class=\"label\">Transfer Location:</td><td>");
            if (isAccession.booleanValue()) {
                writer.write("NARA");
            } else {
                writer.write(StringEscapeUtils.escapeHtml4((String)((String)((Object)this.nodeService.getProperty(transferNode, RecordsManagementModel.PROP_TRANSFER_LOCATION)))));
            }
            writer.write("</td></tr>");
            writer.write("<tr><td class=\"label\">Performed By:</td><td>");
            writer.write(StringEscapeUtils.escapeHtml4((String)((String)((Object)this.nodeService.getProperty(transferNode, ContentModel.PROP_CREATOR)))));
            writer.write("</td></tr>");
            writer.write("<tr><td class=\"label\">Disposition Authority:</td><td>");
            writer.write(dispositionAuthority != null ? StringEscapeUtils.escapeHtml4((String)dispositionAuthority) : "");
            writer.write("</td></tr></table>\n");
            writer.write("<h2>Transferred Items</h2>\n");
            this.generateTransferItemsHTML(writer, itemsToTransfer);
            writer.write("</body></html>");
        }
        return report;
    }

    protected void generateTransferItemsHTML(Writer writer, NodeRef[] itemsToTransfer) throws IOException {
        for (NodeRef item : itemsToTransfer) {
            writer.write("<div class=\"transferred-item\">\n");
            if (this.ddService.isSubClass(this.nodeService.getType(item), ContentModel.TYPE_FOLDER)) {
                this.generateTransferFolderHTML(writer, item);
            } else {
                this.generateTransferRecordHTML(writer, item);
            }
            writer.write("</div>\n");
        }
    }

    protected void generateTransferFolderHTML(Writer writer, NodeRef folderNode) throws IOException {
        writer.write("<span class=\"nodeName\">");
        writer.write(StringEscapeUtils.escapeHtml4((String)((String)((Object)this.nodeService.getProperty(folderNode, ContentModel.PROP_NAME)))));
        writer.write("</span>&nbsp;(Unique Folder Identifier:&nbsp;");
        writer.write(StringEscapeUtils.escapeHtml4((String)((String)((Object)this.nodeService.getProperty(folderNode, RecordsManagementModel.PROP_IDENTIFIER)))));
        writer.write(")\n");
        writer.write("<div class=\"records\">\n");
        List assocs = this.nodeService.getChildAssocs(folderNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef child : assocs) {
            NodeRef childRef = child.getChildRef();
            if (!this.nodeService.hasAspect(childRef, RecordsManagementModel.ASPECT_RECORD)) continue;
            this.generateTransferRecordHTML(writer, childRef);
        }
        writer.write("\n</div>\n");
    }

    protected void generateTransferRecordHTML(Writer writer, NodeRef recordNode) throws IOException {
        writer.write("<div class=\"record\">\n");
        writer.write("  <span class=\"nodeName\">");
        writer.write(StringEscapeUtils.escapeHtml4((String)((String)((Object)this.nodeService.getProperty(recordNode, ContentModel.PROP_NAME)))));
        writer.write("</span>&nbsp;(Unique Record Identifier:&nbsp;");
        writer.write(StringEscapeUtils.escapeHtml4((String)((String)((Object)this.nodeService.getProperty(recordNode, RecordsManagementModel.PROP_IDENTIFIER)))));
        writer.write(")");
        if (this.nodeService.hasAspect(recordNode, RecordsManagementModel.ASPECT_DECLARED_RECORD)) {
            Date declaredOn = (Date)this.nodeService.getProperty(recordNode, RecordsManagementModel.PROP_DECLARED_AT);
            writer.write(" declared by ");
            writer.write(StringEscapeUtils.escapeHtml4((String)((String)((Object)this.nodeService.getProperty(recordNode, RecordsManagementModel.PROP_DECLARED_BY)))));
            writer.write(" on ");
            writer.write(StringEscapeUtils.escapeHtml4((String)declaredOn.toString()));
        }
        writer.write("\n</div>\n");
    }

    protected NodeRef fileTransferReport(File report, NodeRef destination) {
        ParameterCheck.mandatory((String)"report", (Object)report);
        ParameterCheck.mandatory((String)PARAM_DESTINATION, (Object)destination);
        NodeRef record = null;
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, report.getName());
        record = this.nodeService.createNode(destination, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)report.getName())), ContentModel.TYPE_CONTENT, properties).getChildRef();
        ContentWriter writer = this.contentService.getWriter(record, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/html");
        writer.setEncoding("UTF-8");
        writer.putContent(report);
        return record;
    }
}

