/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinition;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDisplayName;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipType;
import org.alfresco.module.org_alfresco_module_rm.script.AbstractRmWebScript;
import org.alfresco.util.ParameterCheck;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RelationshipLabelsGet
extends AbstractRmWebScript {
    private static final String RELATIONSHIP_LABELS = "relationshipLabels";
    private RelationshipService relationshipService;

    protected RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put(RELATIONSHIP_LABELS, this.getRelationshipsLabels());
        return model;
    }

    private List<RelationshipLabel> getRelationshipsLabels() {
        ArrayList<RelationshipLabel> relationshipLabels = new ArrayList<RelationshipLabel>();
        Set<RelationshipDefinition> relationshipDefinitions = this.getRelationshipService().getRelationshipDefinitions();
        for (RelationshipDefinition relationshipDefinition : relationshipDefinitions) {
            RelationshipType type = relationshipDefinition.getType();
            String uniqueName = relationshipDefinition.getUniqueName();
            RelationshipDisplayName displayName = relationshipDefinition.getDisplayName();
            String sourceText = displayName.getSourceText();
            String targetText = displayName.getTargetText();
            if (RelationshipType.PARENTCHILD.equals((Object)type)) {
                relationshipLabels.add(new RelationshipLabel(sourceText, uniqueName + "__invert"));
                relationshipLabels.add(new RelationshipLabel(targetText, uniqueName));
                continue;
            }
            if (RelationshipType.BIDIRECTIONAL.equals((Object)type)) {
                if (!sourceText.equals(targetText)) {
                    throw new WebScriptException(400, "The source '" + sourceText + "' and target text '" + targetText + "' must be the same for a bidirectional relationship.");
                }
                relationshipLabels.add(new RelationshipLabel(sourceText, uniqueName));
                continue;
            }
            throw new WebScriptException(400, "Unknown relationship type '" + type + "'.");
        }
        return this.sortRelationshipLabelsByName(relationshipLabels);
    }

    private List<RelationshipLabel> sortRelationshipLabelsByName(List<RelationshipLabel> relationshipLabels) {
        Collections.sort(relationshipLabels, new Comparator<RelationshipLabel>(){

            @Override
            public int compare(RelationshipLabel r1, RelationshipLabel r2) {
                return r1.getLabel().toLowerCase().compareTo(r2.getLabel().toLowerCase());
            }
        });
        return relationshipLabels;
    }

    public class RelationshipLabel {
        private String label;
        private String uniqueName;

        public RelationshipLabel(String label, String uniqueName) {
            ParameterCheck.mandatoryString((String)"label", (String)label);
            ParameterCheck.mandatoryString((String)"uniqueName", (String)uniqueName);
            this.setLabel(label);
            this.setUniqueName(uniqueName);
        }

        public String getLabel() {
            return this.label;
        }

        private void setLabel(String label) {
            this.label = label;
        }

        public String getUniqueName() {
            return this.uniqueName;
        }

        private void setUniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
        }
    }
}

