/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.FormData;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.util.FileCopyUtils;

public class ImportPost
extends DeclarativeWebScript {
    private static Log logger = LogFactory.getLog(ImportPost.class);
    protected static final String MULTIPART_FORMDATA = "multipart/form-data";
    protected static final String PARAM_DESTINATION = "destination";
    protected static final String PARAM_ARCHIVE = "archive";
    protected static final String PARAM_FILEDATA = "filedata";
    protected static final String TEMP_FILE_PREFIX = "import_";
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected ImporterService importerService;
    protected FilePlanRoleService filePlanRoleService;
    protected FilePlanService filePlanService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setFilePlanRoleService(FilePlanRoleService filePlanRoleService) {
        this.filePlanRoleService = filePlanRoleService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        WebScriptServletRequest webScriptServletRequest = null;
        Object current = req;
        do {
            if (current instanceof WebScriptServletRequest) {
                webScriptServletRequest = (WebScriptServletRequest)current;
                current = null;
                continue;
            }
            current = current instanceof WrappingWebScriptRequest ? ((WrappingWebScriptRequest)req).getNext() : null;
        } while (current != null);
        String contentType = req.getContentType();
        if (MULTIPART_FORMDATA.equals(contentType) && webScriptServletRequest != null) {
            boolean isAdmin;
            String nodeRef = req.getParameter(PARAM_DESTINATION);
            if (nodeRef == null || nodeRef.length() == 0) {
                throw new WebScriptException(400, "Mandatory 'destination' parameter was not provided in form data");
            }
            final NodeRef destination = new NodeRef(nodeRef);
            if (this.nodeService.exists(destination)) {
                if (!this.nodeService.hasAspect(destination, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT) || !this.dictionaryService.isSubClass(this.nodeService.getType(destination), ContentModel.TYPE_FOLDER)) {
                    throw new WebScriptException(400, "NodeRef '" + destination + "' does not represent an Records Management container node.");
                }
            } else {
                status.setCode(404, "NodeRef '" + destination + "' does not exist.");
            }
            if (!(isAdmin = this.filePlanRoleService.hasRMAdminRole(this.filePlanService.getFilePlan(destination), AuthenticationUtil.getRunAsUser()))) {
                throw new WebScriptException(403, "Access Denied");
            }
            File acpFile = null;
            try {
                FormData.FormField acpContent = webScriptServletRequest.getFileField(PARAM_ARCHIVE);
                if (acpContent == null && (acpContent = webScriptServletRequest.getFileField(PARAM_FILEDATA)) == null) {
                    throw new WebScriptException(400, "Mandatory 'archive' file content was not provided in form data");
                }
                acpFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)".acp");
                FileOutputStream fos = new FileOutputStream(acpFile);
                FileCopyUtils.copy((InputStream)acpContent.getInputStream(), (OutputStream)fos);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Importing uploaded ACP (" + acpFile.getAbsolutePath() + ") into " + nodeRef));
                }
                final ACPImportPackageHandler importHandler = new ACPImportPackageHandler(acpFile, "UTF-8");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() {
                        ImportPost.this.importerService.importView((ImportPackageHandler)importHandler, new Location(destination), null, null);
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                HashMap<String, Object> model = new HashMap<String, Object>(1);
                model.put("success", true);
                HashMap<String, Object> hashMap = model;
                return hashMap;
            }
            catch (FileNotFoundException fnfe) {
                throw new WebScriptException(500, "Failed to import ACP file", (Throwable)fnfe);
            }
            catch (IOException ioe) {
                throw new WebScriptException(500, "Failed to import ACP file", (Throwable)ioe);
            }
            finally {
                if (acpFile != null) {
                    acpFile.delete();
                }
            }
        }
        throw new WebScriptException(400, "Request is not multipart/form-data encoded");
    }
}

