/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.dataset.DataSetService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DataSetPost
extends DeclarativeWebScript
implements RecordsManagementModel {
    private static final String ARG_SITE_NAME = "site";
    private static final String ARG_DATA_SET_ID = "dataSetId";
    private static Log logger = LogFactory.getLog(DataSetPost.class);
    private SiteService siteService;
    private DataSetService dataSetService;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setDataSetService(DataSetService dataSetService) {
        this.dataSetService = dataSetService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        try {
            String dataSetId = (String)req.getServiceMatch().getTemplateVars().get(ARG_DATA_SET_ID);
            if (StringUtils.isBlank((CharSequence)dataSetId)) {
                throw new WebScriptException(400, "A data set id was not provided.");
            }
            if (!this.dataSetService.existsDataSet(dataSetId)) {
                throw new WebScriptException(404, "A data set with the id '" + dataSetId + "' does not exist.");
            }
            String siteName = req.getParameter(ARG_SITE_NAME);
            if (StringUtils.isBlank((CharSequence)siteName)) {
                siteName = "rm";
            }
            if (this.siteService.getSite(siteName) == null) {
                throw new WebScriptException(400, "A Records Management site with the name '" + siteName + "' does not exist.");
            }
            NodeRef filePlan = this.siteService.getContainer(siteName, "documentLibrary");
            if (filePlan == null) {
                filePlan = this.siteService.createContainer(siteName, "documentLibrary", TYPE_FILE_PLAN, null);
            }
            this.dataSetService.loadDataSet(filePlan, dataSetId);
            model.put("success", true);
            model.put("message", "Successfully imported data set.");
        }
        catch (Exception ex) {
            model.put("success", false);
            model.put("message", ex.getMessage());
            logger.error((Object)("Error while importing data set: " + ex));
        }
        return model;
    }
}

