/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.script.BaseCustomPropertyWebScript;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomPropertyDefinitionsGet
extends BaseCustomPropertyWebScript {
    private static Log logger = LogFactory.getLog(CustomPropertyDefinitionsGet.class);
    private static final String ELEMENT = "element";
    private static final String PROP_ID = "propId";
    private RecordsManagementAdminService rmAdminService;

    public void setRecordsManagementAdminService(RecordsManagementAdminService rmAdminService) {
        this.rmAdminService = rmAdminService;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String propId = (String)templateVars.get(PROP_ID);
        String elementName = req.getParameter(ELEMENT);
        if (logger.isDebugEnabled() && elementName != null) {
            logger.debug((Object)("Getting custom property definitions for elementName " + elementName));
        } else if (logger.isDebugEnabled() && propId != null) {
            logger.debug((Object)("Getting custom property definition for propId " + propId));
        }
        ArrayList<PropertyDefinition> propData = new ArrayList<PropertyDefinition>();
        if (propId != null) {
            QName propQName = this.rmAdminService.getQNameForClientId(propId);
            PropertyDefinition propDefn = this.rmAdminService.getCustomPropertyDefinitions().get(propQName);
            if (propQName == null || propDefn == null) {
                throw new WebScriptException(404, "Property definition for " + propId + " not found.");
            }
            propData.add(propDefn);
        } else if (elementName != null) {
            QName customisableType = this.mapToTypeQName(elementName);
            Map<QName, PropertyDefinition> currentCustomProps = this.rmAdminService.getCustomPropertyDefinitions(customisableType);
            if (currentCustomProps != null) {
                for (Map.Entry<QName, PropertyDefinition> entry : currentCustomProps.entrySet()) {
                    propData.add(entry.getValue());
                }
            }
        } else {
            throw new WebScriptException(400, "Either elementName or propId must be specified.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved custom property definitions: " + propData));
        }
        model.put("customProps", propData);
        return model;
    }
}

