/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.admin.CustomMetadataException;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.script.BaseCustomPropertyWebScript;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomPropertyDefinitionPost
extends BaseCustomPropertyWebScript {
    protected RecordsManagementAdminService rmAdminService;
    private static final String PARAM_DATATYPE = "dataType";
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_DEFAULT_VALUE = "defaultValue";
    private static final String PARAM_MULTI_VALUED = "multiValued";
    private static final String PARAM_MANDATORY = "mandatory";
    private static final String PARAM_PROTECTED = "protected";
    private static final String PARAM_CONSTRAINT_REF = "constraintRef";
    private static final String PARAM_ELEMENT = "element";
    private static final String PARAM_LABEL = "label";
    private static final String PROP_ID = "propId";
    private static final String MESSAGE = "errorMessage";
    private static final String URL = "url";

    public void setRecordsManagementAdminService(RecordsManagementAdminService rmAdminService) {
        this.rmAdminService = rmAdminService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        JSONObject json = null;
        Map<String, Object> ftlModel = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            try {
                ftlModel = this.createPropertyDefinition(req, json);
            }
            catch (CustomMetadataException e) {
                status.setCode(400);
                ftlModel = new HashMap<String, Object>();
                ftlModel.put(MESSAGE, e.getMessage());
            }
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return ftlModel;
    }

    protected Map<String, Object> createPropertyDefinition(WebScriptRequest req, JSONObject json) throws JSONException, CustomMetadataException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Serializable> params = this.getParamsFromUrlAndJson(req, json);
        QName propertyQName = this.createNewPropertyDefinition(params);
        String localName = propertyQName.getLocalName();
        result.put(PROP_ID, localName);
        String urlResult = req.getServicePath() + "/" + propertyQName.getLocalName();
        result.put(URL, urlResult);
        return result;
    }

    protected Map<String, Serializable> getParamsFromUrlAndJson(WebScriptRequest req, JSONObject json) throws JSONException {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(PARAM_ELEMENT, (Serializable)((Object)req.getParameter(PARAM_ELEMENT)));
        Iterator iter = json.keys();
        while (iter.hasNext()) {
            String nextKeyString = (String)iter.next();
            Serializable nextValue = (Serializable)json.get(nextKeyString);
            params.put(nextKeyString, nextValue);
        }
        return params;
    }

    protected QName createNewPropertyDefinition(Map<String, Serializable> params) throws CustomMetadataException {
        String customisableElement = (String)((Object)params.get(PARAM_ELEMENT));
        QName customisableType = this.mapToTypeQName(customisableElement);
        String label = URLDecoder.decode((String)((String)((Object)params.get(PARAM_LABEL))));
        Serializable serializableParam = params.get(PARAM_DATATYPE);
        QName type = null;
        if (serializableParam != null) {
            if (serializableParam instanceof String) {
                type = QName.createQName((String)((String)((Object)serializableParam)), (NamespacePrefixResolver)this.getNamespaceService());
            } else if (serializableParam instanceof QName) {
                type = (QName)serializableParam;
            } else {
                throw new AlfrescoRuntimeException("Unexpected type of dataType param: " + serializableParam + " (expected String or QName)");
            }
        }
        String title = (String)((Object)params.get(PARAM_TITLE));
        String description = (String)((Object)params.get(PARAM_DESCRIPTION));
        String defaultValue = (String)((Object)params.get(PARAM_DEFAULT_VALUE));
        boolean mandatory = false;
        serializableParam = params.get(PARAM_MANDATORY);
        if (serializableParam != null) {
            mandatory = Boolean.valueOf(serializableParam.toString());
        }
        boolean isProtected = false;
        serializableParam = params.get(PARAM_PROTECTED);
        if (serializableParam != null) {
            isProtected = Boolean.valueOf(serializableParam.toString());
        }
        boolean multiValued = false;
        serializableParam = params.get(PARAM_MULTI_VALUED);
        if (serializableParam != null) {
            multiValued = Boolean.valueOf(serializableParam.toString());
        }
        serializableParam = params.get(PARAM_CONSTRAINT_REF);
        QName constraintRef = null;
        if (serializableParam != null) {
            if (serializableParam instanceof String) {
                constraintRef = QName.createQName((String)((String)((Object)serializableParam)), (NamespacePrefixResolver)this.getNamespaceService());
            } else if (serializableParam instanceof QName) {
                constraintRef = (QName)serializableParam;
            } else {
                throw new AlfrescoRuntimeException("Unexpected type of constraintRef param: " + serializableParam + " (expected String or QName)");
            }
        }
        QName proposedQName = null;
        String propId = (String)((Object)params.get(PROP_ID));
        if (propId != null) {
            proposedQName = QName.createQName((String)"rmc", (String)propId, (NamespacePrefixResolver)this.getNamespaceService());
        }
        return this.rmAdminService.addCustomPropertyDefinition(proposedQName, customisableType, label, type, title, description, defaultValue, multiValued, mandatory, isProtected, constraintRef);
    }
}

