/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementService;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.behaviour.RecordsManagementSearchBehaviour;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.security.RecordsManagementSecurityService;
import org.alfresco.module.org_alfresco_module_rm.security.Role;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

@Deprecated
public class BootstrapTestDataGet
extends DeclarativeWebScript
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(BootstrapTestDataGet.class);
    private static final String ARG_SITE_NAME = "site";
    private static final String ARG_IMPORT = "import";
    private static final String XML_IMPORT = "alfresco/module/org_alfresco_module_rm/dod5015/DODExampleFilePlan.xml";
    private static final String CHARSET_NAME = "UTF-8";
    private static final StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    private NodeService nodeService;
    private SearchService searchService;
    private RecordsManagementService recordsManagementService;
    private RecordsManagementActionService recordsManagementActionService;
    private ImporterService importerService;
    private SiteService siteService;
    private PermissionService permissionService;
    private RecordsManagementSecurityService recordsManagementSecurityService;
    private AuthorityService authorityService;
    private RecordsManagementSearchBehaviour recordsManagementSearchBehaviour;
    private DispositionService dispositionService;
    private RecordFolderService recordFolderService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordsManagementService(RecordsManagementService recordsManagementService) {
        this.recordsManagementService = recordsManagementService;
    }

    public void setRecordsManagementActionService(RecordsManagementActionService recordsManagementActionService) {
        this.recordsManagementActionService = recordsManagementActionService;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setRecordsManagementSecurityService(RecordsManagementSecurityService recordsManagementSecurityService) {
        this.recordsManagementSecurityService = recordsManagementSecurityService;
    }

    public void setRecordsManagementSearchBehaviour(RecordsManagementSearchBehaviour searchBehaviour) {
        this.recordsManagementSearchBehaviour = searchBehaviour;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        boolean importData = false;
        if (req.getParameter(ARG_IMPORT) != null) {
            importData = Boolean.parseBoolean(req.getParameter(ARG_IMPORT));
        }
        String siteName = "rm";
        if (req.getParameter(ARG_SITE_NAME) != null) {
            siteName = req.getParameter(ARG_SITE_NAME);
        }
        if (importData) {
            InputStream is;
            SiteInfo site = this.siteService.getSite(siteName);
            if (site == null) {
                throw new AlfrescoRuntimeException("Records Management site does not exist: " + siteName);
            }
            NodeRef filePlan = this.siteService.getContainer(siteName, "documentLibrary");
            if (filePlan == null) {
                filePlan = this.siteService.createContainer(siteName, "documentLibrary", TYPE_FILE_PLAN, null);
            }
            if ((is = BootstrapTestDataGet.class.getClassLoader().getResourceAsStream(XML_IMPORT)) == null) {
                throw new AlfrescoRuntimeException("The DODExampleFilePlan.xml import file could not be found");
            }
            InputStreamReader viewReader = null;
            try {
                viewReader = new InputStreamReader(is, CHARSET_NAME);
            }
            catch (UnsupportedEncodingException error) {
                throw new AlfrescoRuntimeException("The Character Encoding 'UTF-8' is not supported.", (Throwable)error);
            }
            Location location = new Location(filePlan);
            this.importerService.importView((Reader)viewReader, location, null, null);
        }
        BootstrapTestDataGet.patchLoadedData(this.searchService, this.nodeService, this.recordsManagementService, this.recordsManagementActionService, this.permissionService, this.authorityService, this.recordsManagementSecurityService, this.recordsManagementSearchBehaviour, this.dispositionService, this.recordFolderService);
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("success", true);
        return model;
    }

    public static void patchLoadedData(final SearchService searchService, final NodeService nodeService, final RecordsManagementService recordsManagementService, RecordsManagementActionService recordsManagementActionService, final PermissionService permissionService, final AuthorityService authorityService, final RecordsManagementSecurityService recordsManagementSecurityService, final RecordsManagementSearchBehaviour recordManagementSearchBehaviour, final DispositionService dispositionService, final RecordFolderService recordFolderService) {
        AuthenticationUtil.RunAsWork<Object> runAsWork = new AuthenticationUtil.RunAsWork<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() {
                List<NodeRef> rmRoots = recordsManagementService.getFilePlans();
                logger.info((Object)("Bootstraping " + rmRoots.size() + " rm roots ..."));
                for (NodeRef rmRoot : rmRoots) {
                    String allRoleShortName;
                    String allRoleGroupName;
                    if (permissionService.getInheritParentPermissions(rmRoot)) {
                        logger.info((Object)("Updating permissions for rm root: " + rmRoot));
                        permissionService.setInheritParentPermissions(rmRoot, false);
                    }
                    if (authorityService.authorityExists(allRoleGroupName = authorityService.getName(AuthorityType.GROUP, allRoleShortName = "AllRoles" + rmRoot.getId()))) continue;
                    logger.info((Object)("Creating all roles group for root node: " + rmRoot.toString()));
                    String allRoles = authorityService.createAuthority(AuthorityType.GROUP, allRoleShortName, "All Roles", new HashSet<String>(Arrays.asList("APP.RM")));
                    Set<Role> roles = recordsManagementSecurityService.getRoles(rmRoot);
                    for (Role role : roles) {
                        logger.info((Object)("   - adding role group " + role.getRoleGroupName() + " to all roles group"));
                        authorityService.addAuthority(allRoles, role.getRoleGroupName());
                    }
                    permissionService.setPermission(rmRoot, allRoles, "ReadRecords", true);
                }
                try (ResultSet rs = searchService.query(SPACES_STORE, "fts-alfresco", "TYPE:\"rma:recordsManagementContainer\"");){
                    logger.info((Object)("Bootstraping " + rs.length() + " record containers ..."));
                    for (NodeRef container : rs.getNodeRefs()) {
                        String containerName = (String)((Object)nodeService.getProperty(container, ContentModel.PROP_NAME));
                        if (!permissionService.getInheritParentPermissions(container)) continue;
                        logger.info((Object)("Updating permissions for record container: " + containerName));
                        permissionService.setInheritParentPermissions(container, false);
                    }
                }
                rs = searchService.query(SPACES_STORE, "fts-alfresco", "TYPE:\"rma:recordFolder\"");
                try {
                    logger.info((Object)("Bootstraping " + rs.length() + " record folders ..."));
                    for (NodeRef recordFolder : rs.getNodeRefs()) {
                        DispositionSchedule ds;
                        String folderName = (String)((Object)nodeService.getProperty(recordFolder, ContentModel.PROP_NAME));
                        if (permissionService.getInheritParentPermissions(recordFolder)) {
                            logger.info((Object)("Updating permissions for record folder: " + folderName));
                            permissionService.setInheritParentPermissions(recordFolder, false);
                        }
                        if (!nodeService.hasAspect(recordFolder, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE) && (ds = dispositionService.getDispositionSchedule(recordFolder)) != null) {
                            logger.info((Object)("Setting up bootstraped record folder: " + folderName));
                            recordFolderService.setupRecordFolder(recordFolder);
                        }
                        logger.info((Object)("Setting up search aspect for record folder: " + folderName));
                        recordManagementSearchBehaviour.fixupSearchAspect(recordFolder);
                    }
                }
                finally {
                    rs.close();
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)AuthenticationUtil.getAdminUserName());
    }
}

