/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.web.scripts.content.StreamACP;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public abstract class BaseTransferWebScript
extends StreamACP
implements RecordsManagementModel {
    private static Log logger = LogFactory.getLog(BaseTransferWebScript.class);
    protected FilePlanService filePlanService;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        File tempFile = null;
        try {
            String format = req.getFormat();
            Status status = new Status();
            Cache cache = new Cache(this.getDescription().getRequiredCache());
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("status", status);
            model.put("cache", cache);
            Map templateVars = req.getServiceMatch().getTemplateVars();
            String storeType = (String)templateVars.get("store_type");
            String storeId = (String)templateVars.get("store_id");
            String nodeId = (String)templateVars.get("id");
            String transferId = (String)templateVars.get("transfer_id");
            NodeRef filePlan = new NodeRef(new StoreRef(storeType, storeId), nodeId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieving transfer '" + transferId + "' from file plan: " + filePlan));
            }
            if (!this.nodeService.exists(filePlan)) {
                status.setCode(404, "Node " + filePlan.toString() + " does not exist");
                Map templateModel = this.createTemplateParameters(req, res, model);
                this.sendStatus(req, res, status, cache, format, templateModel);
                return;
            }
            if (!this.filePlanService.isFilePlan(filePlan)) {
                status.setCode(400, "Node " + filePlan.toString() + " is not a file plan");
                Map templateModel = this.createTemplateParameters(req, res, model);
                this.sendStatus(req, res, status, cache, format, templateModel);
                return;
            }
            NodeRef transferNode = this.findTransferNode(filePlan, transferId);
            if (transferNode == null) {
                status.setCode(404, "Could not locate transfer with id: " + transferId);
                Map templateModel = this.createTemplateParameters(req, res, model);
                this.sendStatus(req, res, status, cache, format, templateModel);
                return;
            }
            tempFile = this.executeTransfer(transferNode, req, res, status, cache);
        }
        catch (Exception e) {
            throw this.createStatusException(e, req, res);
        }
        finally {
            if (tempFile != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Transfer report saved to temporary file: " + tempFile.getAbsolutePath()));
                } else {
                    tempFile.delete();
                }
            }
        }
    }

    protected abstract File executeTransfer(NodeRef var1, WebScriptRequest var2, WebScriptResponse var3, Status var4, Cache var5) throws IOException;

    protected NodeRef findTransferNode(NodeRef filePlan, String transferId) {
        NodeRef transferNode = null;
        NodeRef transferContainer = this.filePlanService.getTransferContainer(filePlan);
        List assocs = this.nodeService.getChildAssocs(transferContainer, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef child : assocs) {
            if (!child.getChildRef().getId().equals(transferId)) continue;
            transferNode = child.getChildRef();
            break;
        }
        return transferNode;
    }

    protected NodeRef[] getTransferNodes(NodeRef transferNode) {
        List assocs = this.nodeService.getChildAssocs(transferNode, (QNamePattern)RecordsManagementModel.ASSOC_TRANSFERRED, RegexQNamePattern.MATCH_ALL);
        NodeRef[] itemsToTransfer = new NodeRef[assocs.size()];
        for (int idx = 0; idx < assocs.size(); ++idx) {
            itemsToTransfer[idx] = ((ChildAssociationRef)assocs.get(idx)).getChildRef();
        }
        return itemsToTransfer;
    }
}

