/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.File;
import java.io.IOException;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditQueryParameters;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.script.BaseAuditRetrievalWebScript;
import org.alfresco.repo.web.scripts.content.ContentStreamer;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AuditLogGet
extends BaseAuditRetrievalWebScript {
    private static Log logger = LogFactory.getLog(AuditLogGet.class);
    private static final String PARAM_EXPORT = "export";
    private static final String ACCESS_AUDIT_CAPABILITY = "AccessAudit";
    private static final int DEFAULT_VIEW_LOG_MAX_SIZE = 100;
    protected ContentStreamer contentStreamer;
    protected CapabilityService capabilityService;
    protected FilePlanService filePlanService;
    private int viewLogMaxSize;

    public void setContentStreamer(ContentStreamer contentStreamer) {
        this.contentStreamer = contentStreamer;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setViewLogMaxSize(int viewLogMaxSize) {
        this.viewLogMaxSize = viewLogMaxSize <= 0 ? 100 : viewLogMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        File auditTrail = null;
        try {
            RecordsManagementAuditQueryParameters queryParams = this.parseQueryParameters(req);
            RecordsManagementAuditService.ReportFormat reportFormat = this.parseReportFormat(req);
            if (!this.userCanAccessAudit(queryParams)) {
                throw new WebScriptException(403, "Access denied because the user does not have the Access Audit capability");
            }
            if (queryParams.getMaxEntries() <= 0 || queryParams.getMaxEntries() > this.viewLogMaxSize) {
                queryParams.setMaxEntries(this.viewLogMaxSize);
            }
            auditTrail = this.rmAuditService.getAuditTrailFile(queryParams, reportFormat);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Streaming audit trail from file: " + auditTrail.getAbsolutePath()));
            }
            boolean attach = false;
            String attachFileName = null;
            String export = req.getParameter(PARAM_EXPORT);
            if (Boolean.parseBoolean(export)) {
                attach = true;
                attachFileName = auditTrail.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Exporting audit trail using file name: " + attachFileName));
                }
            }
            this.contentStreamer.streamContent(req, res, auditTrail, null, attach, attachFileName, null);
        }
        finally {
            if (auditTrail != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Audit results written to file: \n   File:      " + auditTrail + "\n   Parameter: " + this.parseQueryParameters(req)));
                } else {
                    auditTrail.delete();
                }
            }
        }
    }

    private boolean userCanAccessAudit(RecordsManagementAuditQueryParameters queryParams) {
        NodeRef targetNode = queryParams.getNodeRef();
        if (targetNode == null && (targetNode = this.filePlanService.getFilePlanBySiteId("rm")) == null) {
            throw new WebScriptException(404, "The default RM site was not found");
        }
        return AccessStatus.ALLOWED.equals((Object)this.capabilityService.getCapabilityAccessState(targetNode, ACCESS_AUDIT_CAPABILITY));
    }
}

