/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.relationship;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminBase;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinition;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinitionImpl;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDisplayName;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipImpl;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipType;
import org.alfresco.module.org_alfresco_module_rm.util.PoliciesUtil;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Association;
import org.alfresco.repo.dictionary.M2ClassAssociation;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;

public class RelationshipServiceImpl
extends RecordsManagementAdminBase
implements RelationshipService {
    private PolicyComponent policyComponent;
    private ClassPolicyDelegate<RecordsManagementPolicies.BeforeCreateReference> beforeCreateReferenceDelegate;
    private ClassPolicyDelegate<RecordsManagementPolicies.OnCreateReference> onCreateReferenceDelegate;
    private ClassPolicyDelegate<RecordsManagementPolicies.BeforeRemoveReference> beforeRemoveReferenceDelegate;
    private ClassPolicyDelegate<RecordsManagementPolicies.OnRemoveReference> onRemoveReferenceDelegate;

    private PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        this.beforeCreateReferenceDelegate = this.getPolicyComponent().registerClassPolicy(RecordsManagementPolicies.BeforeCreateReference.class);
        this.onCreateReferenceDelegate = this.getPolicyComponent().registerClassPolicy(RecordsManagementPolicies.OnCreateReference.class);
        this.beforeRemoveReferenceDelegate = this.getPolicyComponent().registerClassPolicy(RecordsManagementPolicies.BeforeRemoveReference.class);
        this.onRemoveReferenceDelegate = this.getPolicyComponent().registerClassPolicy(RecordsManagementPolicies.OnRemoveReference.class);
    }

    @Override
    public Set<RelationshipDefinition> getRelationshipDefinitions() {
        HashSet<RelationshipDefinition> relationshipDefinitions = new HashSet<RelationshipDefinition>();
        Set<Map.Entry<QName, AssociationDefinition>> associationsEntrySet = this.getCustomAssociations().entrySet();
        for (Map.Entry<QName, AssociationDefinition> associationEntry : associationsEntrySet) {
            AssociationDefinition associationDefinition = associationEntry.getValue();
            RelationshipDefinition relationshipDefinition = this.createRelationshipDefinition(associationDefinition);
            if (relationshipDefinition == null) continue;
            relationshipDefinitions.add(relationshipDefinition);
        }
        return relationshipDefinitions;
    }

    @Override
    public RelationshipDefinition getRelationshipDefinition(String uniqueName) {
        ParameterCheck.mandatoryString((String)"uniqueName", (String)uniqueName);
        RelationshipDefinition relationshipDefinition = null;
        AssociationDefinition associationDefinition = this.getAssociationDefinition(uniqueName);
        if (associationDefinition != null) {
            relationshipDefinition = this.createRelationshipDefinition(associationDefinition);
        }
        return relationshipDefinition;
    }

    @Override
    public RelationshipDefinition createRelationshipDefinition(RelationshipDisplayName displayName) {
        M2Association newAssoc;
        String customAspectName;
        String title;
        ParameterCheck.mandatory((String)"displayName", (Object)displayName);
        RelationshipType type = this.determineRelationshipTypeFromDisplayName(displayName);
        switch (type) {
            case BIDIRECTIONAL: {
                title = displayName.getSourceText();
                break;
            }
            case PARENTCHILD: {
                String sourceText = displayName.getSourceText();
                String targetText = displayName.getTargetText();
                title = this.composeAssociationDefinitionTitle(sourceText, targetText);
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append("Unsupported relationship type: '").append(type.toString()).append("'.");
                throw new AlfrescoRuntimeException(sb.toString());
            }
        }
        if (this.existsTitle(title)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot create a relationship definition for the display name: '").append(displayName.toString()).append("' as there is already a relationship definition with this display name.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        NodeRef modelRef = this.getCustomModelRef("");
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        M2Aspect customAssocsAspect = deserializedModel.getAspect(customAspectName = ASPECT_CUSTOM_ASSOCIATIONS.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        if (customAssocsAspect == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("The aspect: '").append(customAspectName).append("' is undefined.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        QName relationshipDefinitionQName = this.generateRelationshipDefinitionQNameFor(title);
        String generatedShortQName = relationshipDefinitionQName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        M2ClassAssociation customAssoc = customAssocsAspect.getAssociation(generatedShortQName);
        if (customAssoc != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("The association: '").append(customAssoc.getName()).append("' already exists.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        switch (type) {
            case BIDIRECTIONAL: {
                newAssoc = customAssocsAspect.createAssociation(generatedShortQName);
                break;
            }
            case PARENTCHILD: {
                newAssoc = customAssocsAspect.createChildAssociation(generatedShortQName);
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append("Unsupported relationship type: '").append(type.toString()).append("'.");
                throw new AlfrescoRuntimeException(sb.toString());
            }
        }
        newAssoc.setSourceMandatory(false);
        newAssoc.setTargetMandatory(false);
        newAssoc.setSourceMany(true);
        newAssoc.setTargetMany(true);
        newAssoc.setTitle(title);
        newAssoc.setTargetClassName(RecordsManagementModel.ASPECT_RECORD.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        this.writeCustomContentModel(modelRef, deserializedModel);
        return new RelationshipDefinitionImpl(relationshipDefinitionQName.getLocalName(), type, displayName);
    }

    @Override
    public RelationshipDefinition updateRelationshipDefinition(String uniqueName, RelationshipDisplayName displayName) {
        String title;
        ParameterCheck.mandatoryString((String)"uniqueName", (String)uniqueName);
        RelationshipDefinition relationshipDefinition = this.getRelationshipDefinition(uniqueName);
        if (relationshipDefinition == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("The relationship definition for the unique name '").append(uniqueName).append("' was not found.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        RelationshipType type = relationshipDefinition.getType();
        switch (type) {
            case BIDIRECTIONAL: {
                title = displayName.getSourceText();
                if (!StringUtils.isBlank((CharSequence)title)) break;
                StringBuilder sb = new StringBuilder();
                sb.append("Label text '").append(title).append(" cannot be blank.");
                throw new AlfrescoRuntimeException(sb.toString());
            }
            case PARENTCHILD: {
                String sourceText = displayName.getSourceText();
                String targetText = displayName.getTargetText();
                if (StringUtils.isBlank((CharSequence)sourceText) || StringUtils.isBlank((CharSequence)targetText)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Neither source text '").append(sourceText).append("' nor target text '").append(targetText).append(" can be blank.");
                    throw new AlfrescoRuntimeException(sb.toString());
                }
                title = this.composeAssociationDefinitionTitle(sourceText, targetText);
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append("Unsupported relationship type: '").append(type.toString()).append("'.");
                throw new AlfrescoRuntimeException(sb.toString());
            }
        }
        if (this.existsTitle(title)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot update the relationship definition as '").append(title).append("' already exists.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        QName associationDefinitionQName = this.getAssociationDefinitionName(uniqueName);
        QName updatedAssociationDefinitionQName = this.persistUpdatedAssocTitle(associationDefinitionQName, title);
        RelationshipDefinition updatedRelationshipDefinition = this.getRelationshipDefinition(updatedAssociationDefinitionQName.getLocalName());
        if (updatedRelationshipDefinition == null) {
            throw new AlfrescoRuntimeException("The relationship definition could not be updated successfully.");
        }
        return updatedRelationshipDefinition;
    }

    @Override
    public boolean removeRelationshipDefinition(String uniqueName) {
        ParameterCheck.mandatoryString((String)"uniqueName", (String)uniqueName);
        throw new UnsupportedOperationException("It is not possible to remove a relationship.");
    }

    @Override
    public boolean existsRelationshipDefinition(String uniqueName) {
        ParameterCheck.mandatoryString((String)"uniqueName", (String)uniqueName);
        boolean exists = false;
        RelationshipDefinition relationshipDefinition = this.getRelationshipDefinition(uniqueName);
        if (relationshipDefinition != null) {
            exists = true;
        }
        return exists;
    }

    @Override
    public Set<Relationship> getRelationshipsFrom(NodeRef nodeRef) {
        return this.getRelationshipsFrom(nodeRef, null);
    }

    @Override
    public Set<Relationship> getRelationshipsFrom(NodeRef nodeRef, String nameFilter) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        List customReferencesFrom = this.getNodeService().getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
        relationships.addAll(this.generateRelationshipFromAssociationRef(customReferencesFrom, nameFilter));
        List customChildReferences = this.getNodeService().getChildAssocs(nodeRef);
        relationships.addAll(this.generateRelationshipFromParentChildAssociationRef(customChildReferences, nameFilter));
        return relationships;
    }

    @Override
    public Set<Relationship> getRelationshipsTo(NodeRef nodeRef) {
        return this.getRelationshipsTo(nodeRef, null);
    }

    @Override
    public Set<Relationship> getRelationshipsTo(NodeRef nodeRef, String nameFilter) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        List customReferencesTo = this.getNodeService().getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
        relationships.addAll(this.generateRelationshipFromAssociationRef(customReferencesTo, nameFilter));
        List customParentReferences = this.getNodeService().getParentAssocs(nodeRef);
        relationships.addAll(this.generateRelationshipFromParentChildAssociationRef(customParentReferences, nameFilter));
        return relationships;
    }

    @Override
    public void addRelationship(String uniqueName, NodeRef source, NodeRef target) {
        ParameterCheck.mandatoryString((String)"uniqueName", (String)uniqueName);
        ParameterCheck.mandatory((String)"source", (Object)source);
        ParameterCheck.mandatory((String)"target", (Object)target);
        if (!this.getNodeService().exists(source)) {
            throw new AlfrescoRuntimeException("Can't create relationship '" + uniqueName + "', because source node doesn't exist.");
        }
        if (!this.getNodeService().exists(target)) {
            throw new AlfrescoRuntimeException("Can't create relationship " + uniqueName + ", because target node doesn't exist.");
        }
        if (this.getNodeService().hasAspect(target, RecordsManagementModel.ASPECT_FROZEN)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Relationship cannot be created as the target '").append(this.getNodeService().getProperty(target, ContentModel.PROP_NAME)).append("' is in a hold.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        AssociationDefinition associationDefinition = this.getAssociationDefinition(uniqueName);
        if (associationDefinition == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("No association definition found for '").append(uniqueName).append("'.");
            throw new IllegalArgumentException(sb.toString());
        }
        QName associationDefinitionName = associationDefinition.getName();
        boolean associationAlreadyExists = this.associationExists(associationDefinition, source, target);
        if (associationAlreadyExists) {
            StringBuilder sb = new StringBuilder();
            sb.append("Association '").append(associationDefinitionName.getLocalName()).append("' already exists from '").append(source).append("' to '").append(target).append("'.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        this.invokeBeforeCreateReference(source, target, associationDefinitionName);
        if (associationDefinition.isChild()) {
            this.getNodeService().addChild(source, target, associationDefinitionName, associationDefinitionName);
        } else {
            this.getNodeService().createAssociation(source, target, associationDefinitionName);
        }
        this.invokeOnCreateReference(source, target, associationDefinitionName);
    }

    @Override
    public void removeRelationship(String uniqueName, NodeRef source, NodeRef target) {
        ParameterCheck.mandatoryString((String)"uniqueName", (String)uniqueName);
        ParameterCheck.mandatory((String)"source", (Object)source);
        ParameterCheck.mandatory((String)"target", (Object)target);
        AssociationDefinition associationDefinition = this.getAssociationDefinition(uniqueName);
        if (associationDefinition == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("No association definition found for '").append(uniqueName).append("'.");
            throw new IllegalArgumentException(sb.toString());
        }
        final QName associationDefinitionName = associationDefinition.getName();
        final NodeRef targetNode = target;
        final NodeRef sourceNode = source;
        this.invokeBeforeRemoveReference(sourceNode, targetNode, associationDefinitionName);
        if (associationDefinition.isChild()) {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    List children = RelationshipServiceImpl.this.getNodeService().getChildAssocs(sourceNode);
                    for (ChildAssociationRef chRef : children) {
                        if (!associationDefinitionName.equals((Object)chRef.getTypeQName()) || !chRef.getChildRef().equals((Object)targetNode)) continue;
                        RelationshipServiceImpl.this.getNodeService().removeChildAssociation(chRef);
                    }
                    return null;
                }
            });
        } else {
            this.getNodeService().removeAssociation(source, targetNode, associationDefinitionName);
        }
        this.invokeOnRemoveReference(source, targetNode, associationDefinitionName);
    }

    private RelationshipDefinition createRelationshipDefinition(AssociationDefinition associationDefinition) {
        RelationshipDefinitionImpl relationshipDefinition = null;
        if (associationDefinition != null) {
            String uniqueName = associationDefinition.getName().getLocalName();
            RelationshipType type = this.getRelationshipType(associationDefinition);
            String title = associationDefinition.getTitle((MessageLookup)this.getDictionaryService());
            RelationshipDisplayName displayName = this.getRelationshipDisplayName(type, title);
            relationshipDefinition = new RelationshipDefinitionImpl(uniqueName, type, displayName);
        }
        return relationshipDefinition;
    }

    private RelationshipType getRelationshipType(AssociationDefinition associationDefinition) {
        RelationshipType type = associationDefinition instanceof ChildAssociationDefinition ? RelationshipType.PARENTCHILD : RelationshipType.BIDIRECTIONAL;
        return type;
    }

    private RelationshipDisplayName getRelationshipDisplayName(RelationshipType type, String title) {
        String sourceText = null;
        String targetText = null;
        switch (type) {
            case BIDIRECTIONAL: {
                sourceText = title;
                targetText = title;
                break;
            }
            case PARENTCHILD: {
                String[] sourceAndTarget = this.splitAssociationDefinitionTitle(title);
                sourceText = sourceAndTarget[0];
                targetText = sourceAndTarget[1];
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append("Unsupported relationship type: '").append(type.toString()).append("'.");
                throw new AlfrescoRuntimeException(sb.toString());
            }
        }
        return new RelationshipDisplayName(sourceText, targetText);
    }

    private Set<Relationship> generateRelationshipFromAssociationRef(List<AssociationRef> associationRefs, String nameFilter) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        for (AssociationRef associationRef : associationRefs) {
            String uniqueName = associationRef.getTypeQName().getLocalName();
            if (!this.existsRelationshipDefinition(uniqueName) || nameFilter != null && !uniqueName.equals(nameFilter)) continue;
            NodeRef from = associationRef.getSourceRef();
            NodeRef to = associationRef.getTargetRef();
            relationships.add(new RelationshipImpl(uniqueName, from, to));
        }
        return relationships;
    }

    private Set<Relationship> generateRelationshipFromParentChildAssociationRef(List<ChildAssociationRef> childAssociationRefs, String nameFilter) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        for (ChildAssociationRef childAssociationRef : childAssociationRefs) {
            String uniqueName = childAssociationRef.getQName().getLocalName();
            if (!this.existsRelationshipDefinition(uniqueName) || nameFilter != null && !uniqueName.equals(nameFilter)) continue;
            NodeRef from = childAssociationRef.getParentRef();
            NodeRef to = childAssociationRef.getChildRef();
            relationships.add(new RelationshipImpl(uniqueName, from, to));
        }
        return relationships;
    }

    private RelationshipType determineRelationshipTypeFromDisplayName(RelationshipDisplayName displayName) {
        String sourceText = displayName.getSourceText();
        String targetText = displayName.getTargetText();
        String errorMsg = "Relationship type could not be determined from the display name. It is neither biderectional nor parent/child relationship";
        if (StringUtils.isBlank((CharSequence)sourceText) || StringUtils.isBlank((CharSequence)targetText)) {
            throw new AlfrescoRuntimeException(errorMsg);
        }
        RelationshipType relationshipType = sourceText.equals(targetText) ? RelationshipType.BIDIRECTIONAL : RelationshipType.PARENTCHILD;
        return relationshipType;
    }

    private void invokeBeforeCreateReference(NodeRef source, NodeRef target, QName associationDefinitionName) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.getNodeService(), source);
        RecordsManagementPolicies.BeforeCreateReference policy = (RecordsManagementPolicies.BeforeCreateReference)this.beforeCreateReferenceDelegate.get(qnames);
        policy.beforeCreateReference(source, target, associationDefinitionName);
    }

    private void invokeOnCreateReference(NodeRef source, NodeRef target, QName associationDefinitionName) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.getNodeService(), source);
        RecordsManagementPolicies.OnCreateReference policy = (RecordsManagementPolicies.OnCreateReference)this.onCreateReferenceDelegate.get(qnames);
        policy.onCreateReference(source, target, associationDefinitionName);
    }

    private void invokeBeforeRemoveReference(NodeRef source, NodeRef target, QName associationDefinitionName) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.getNodeService(), source);
        RecordsManagementPolicies.BeforeRemoveReference policy = (RecordsManagementPolicies.BeforeRemoveReference)this.beforeRemoveReferenceDelegate.get(qnames);
        policy.beforeRemoveReference(source, target, associationDefinitionName);
    }

    private void invokeOnRemoveReference(NodeRef source, NodeRef target, QName associationDefinitionName) {
        Set<QName> qnames = PoliciesUtil.getTypeAndAspectQNames(this.getNodeService(), source);
        RecordsManagementPolicies.OnRemoveReference policy = (RecordsManagementPolicies.OnRemoveReference)this.onRemoveReferenceDelegate.get(qnames);
        policy.onRemoveReference(source, target, associationDefinitionName);
    }

    private boolean associationExists(AssociationDefinition associationDefinition, NodeRef source, NodeRef target) {
        boolean associationAlreadyExists = false;
        QName associationDefinitionName = associationDefinition.getName();
        if (associationDefinition.isChild()) {
            List childAssocs = this.getNodeService().getChildAssocs(source, (QNamePattern)associationDefinitionName, (QNamePattern)associationDefinitionName);
            for (ChildAssociationRef chAssRef : childAssocs) {
                if (!chAssRef.getChildRef().equals((Object)target)) continue;
                associationAlreadyExists = true;
            }
        } else {
            List assocs = this.getNodeService().getTargetAssocs(source, (QNamePattern)associationDefinitionName);
            for (AssociationRef assRef : assocs) {
                if (!assRef.getTargetRef().equals((Object)target)) continue;
                associationAlreadyExists = true;
            }
        }
        return associationAlreadyExists;
    }

    private AssociationDefinition getAssociationDefinition(String uniqueName) {
        AssociationDefinition associationDefinition = null;
        Set<Map.Entry<QName, AssociationDefinition>> associationsEntrySet = this.getCustomAssociations().entrySet();
        for (Map.Entry<QName, AssociationDefinition> associationEntry : associationsEntrySet) {
            String localName = associationEntry.getKey().getLocalName();
            if (!uniqueName.equals(localName)) continue;
            associationDefinition = associationEntry.getValue();
            break;
        }
        return associationDefinition;
    }

    private QName getAssociationDefinitionName(String uniqueName) {
        AssociationDefinition associationDefinition = this.getAssociationDefinition(uniqueName);
        if (associationDefinition == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("The qualified name for '").append(uniqueName).append("' was not found.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        return associationDefinition.getName();
    }

    private QName persistUpdatedAssocTitle(QName associationDefinitionQName, String newTitle) {
        ParameterCheck.mandatory((String)"associationDefinitionQName", (Object)associationDefinitionQName);
        AssociationDefinition assocDefn = this.getDictionaryService().getAssociation(associationDefinitionQName);
        if (assocDefn == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot find the association definiton for '").append(associationDefinitionQName.getLocalName()).append("'.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        NodeRef modelRef = this.getCustomModelRef("");
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        String customAspectName = ASPECT_CUSTOM_ASSOCIATIONS.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        M2Aspect customAssocsAspect = deserializedModel.getAspect(customAspectName);
        for (M2ClassAssociation assoc : customAssocsAspect.getAssociations()) {
            if (!associationDefinitionQName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()).equals(assoc.getName()) || newTitle == null) continue;
            assoc.setTitle(newTitle);
        }
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("persistUpdatedAssocTitle: " + associationDefinitionQName + "=" + newTitle + " to aspect: " + customAspectName));
        }
        return associationDefinitionQName;
    }

    private QName generateRelationshipDefinitionQNameFor(String uniqueName) {
        ParameterCheck.mandatoryString((String)"uniqueName", (String)uniqueName);
        QName existingQName = null;
        Set<QName> customAssociationsQNames = this.getCustomAssociations().keySet();
        for (QName customAssociationsQName : customAssociationsQNames) {
            if (!uniqueName.equals(customAssociationsQName.getLocalName())) continue;
            existingQName = customAssociationsQName;
        }
        if (existingQName != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot create qualified name for given unique name '").append(uniqueName).append("' as it already exists.");
            throw new AlfrescoRuntimeException(sb.toString());
        }
        return QName.createQName((String)"rmc", (String)GUID.generate(), (NamespacePrefixResolver)this.getNamespaceService());
    }
}

