/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v35;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.AbstractModulePatch;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class RMv35HoldNewChildAssocPatch
extends AbstractModulePatch {
    protected static final QName PATCH_ASSOC_NAME = QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)RMv35HoldNewChildAssocPatch.class.getSimpleName());
    private FilePlanService filePlanService;
    private HoldService holdService;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public BehaviourFilter getBehaviourFilter() {
        return this.behaviourFilter;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyInternal() {
        this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.behaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            for (NodeRef filePlan : this.filePlanService.getFilePlans()) {
                for (NodeRef hold : this.holdService.getHolds(filePlan)) {
                    List frozenAssoc = this.nodeService.getChildAssocs(hold, (QNamePattern)RecordsManagementModel.ASSOC_FROZEN_CONTENT, RegexQNamePattern.MATCH_ALL);
                    for (ChildAssociationRef ref : frozenAssoc) {
                        NodeRef childNodeRef = ref.getChildRef();
                        List parentAssocs = this.nodeService.getParentAssocs(childNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                        boolean childContainedByHold = parentAssocs.stream().anyMatch(entry -> entry.getParentRef().equals((Object)hold) && entry.getTypeQName().equals((Object)ContentModel.ASSOC_CONTAINS));
                        if (childContainedByHold) continue;
                        this.nodeService.addChild(hold, childNodeRef, ContentModel.ASSOC_CONTAINS, PATCH_ASSOC_NAME);
                    }
                }
            }
        }
        finally {
            this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            this.behaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
    }
}

