/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.rma.type.FilePlanType;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchService;
import org.alfresco.module.org_alfresco_module_rm.util.RMContainerCacheManager;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyMap;

@BehaviourBean(defaultType="rma:rmsite")
public class RmSiteType
extends BaseBehaviourBean
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy {
    public static final String COMPONENT_DOCUMENT_LIBRARY = "documentLibrary";
    public static final String DEFAULT_SITE_NAME = "rm";
    public static final QName DEFAULT_FILE_PLAN_TYPE = TYPE_FILE_PLAN;
    private static final List<QName> ACCEPTED_NON_UNIQUE_CHILD_TYPES = Arrays.asList(ContentModel.TYPE_FOLDER);
    protected SiteService siteService;
    protected RecordsManagementSearchService recordsManagementSearchService;
    protected CapabilityService capabilityService;
    private AuthorityService authorityService;
    private FilePlanType filePlanType;
    private RMContainerCacheManager rmContainerCacheManager;
    protected Map<QName, QName> mapFilePlanType = new HashMap<QName, QName>(3);

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setRecordsManagementSearchService(RecordsManagementSearchService recordsManagementSearchService) {
        this.recordsManagementSearchService = recordsManagementSearchService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setFilePlanType(FilePlanType filePlanType) {
        this.filePlanType = filePlanType;
    }

    public void setRmContainerCacheManager(RMContainerCacheManager rmContainerCacheManager) {
        this.rmContainerCacheManager = rmContainerCacheManager;
    }

    public void registerFilePlanType(QName siteType, QName filePlanType) {
        ParameterCheck.mandatory((String)"siteType", (Object)siteType);
        ParameterCheck.mandatory((String)"filePlanType", (Object)filePlanType);
        if (!this.dictionaryService.isSubClass(siteType, TYPE_RM_SITE)) {
            throw new AlfrescoRuntimeException("Can't register site type, because site type is not a sub type of rma:rmsite (siteType=" + siteType.toString() + ")");
        }
        if (!this.dictionaryService.isSubClass(filePlanType, TYPE_FILE_PLAN)) {
            throw new AlfrescoRuntimeException("Can't register file plan type, because site type is not a sub type of rma:filePlan (filePlanType=" + filePlanType.toString() + ")");
        }
        this.mapFilePlanType.put(siteType, filePlanType);
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        final NodeRef rmSite = childAssocRef.getChildRef();
        if (rmSite.getStoreRef().equals((Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE)) {
            return;
        }
        if (this.nodeService.exists(rmSite)) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    SiteInfo siteInfo = RmSiteType.this.siteService.getSite(rmSite);
                    if (siteInfo != null) {
                        RmSiteType.this.siteService.createContainer(siteInfo.getShortName(), RmSiteType.COMPONENT_DOCUMENT_LIBRARY, RmSiteType.this.getFilePlanType(siteInfo), null);
                        RmSiteType.this.recordsManagementSearchService.addReports(siteInfo.getShortName());
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private QName getFilePlanType(SiteInfo siteInfo) {
        ParameterCheck.mandatory((String)"siteInfo", (Object)siteInfo);
        QName result = DEFAULT_FILE_PLAN_TYPE;
        QName siteType = this.nodeService.getType(siteInfo.getNodeRef());
        if (this.mapFilePlanType.containsKey(siteType)) {
            result = this.mapFilePlanType.get(siteType);
        }
        return result;
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Map changed;
        if (this.nodeService.exists(nodeRef) && (changed = PropertyMap.getChangedProperties(before, after)).containsKey(SiteModel.PROP_SITE_VISIBILITY) && changed.get(SiteModel.PROP_SITE_VISIBILITY) != null && !SiteVisibility.PUBLIC.equals(changed.get(SiteModel.PROP_SITE_VISIBILITY))) {
            throw new AlfrescoRuntimeException("The records management site must have public visibility.  It can't be changed to " + changed.get(SiteModel.PROP_SITE_VISIBILITY));
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void beforeDeleteNode(NodeRef nodeRef) {
        NodeRef filePlan;
        final SiteInfo siteInfo = this.siteService.getSite(nodeRef);
        if (siteInfo != null && (filePlan = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() {
                return RmSiteType.this.siteService.getContainer(siteInfo.getShortName(), RmSiteType.COMPONENT_DOCUMENT_LIBRARY);
            }
        })) != null) {
            AccessStatus accessStatus = this.capabilityService.getCapabilityAccessState(filePlan, "Delete");
            if (AccessStatus.DENIED.equals((Object)accessStatus)) {
                throw new AlfrescoRuntimeException("The records management site can not be deleted, because the user doesn't have sufficient privillages to delete the file plan.");
            }
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    String siteGroup = RmSiteType.this.siteService.getSiteGroup(siteInfo.getShortName());
                    RmSiteType.this.authorityService.deleteAuthority(siteGroup, true);
                    return null;
                }
            });
            this.filePlanType.disable();
        }
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION)
    public void onDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (RmSiteType.this.rmContainerCacheManager != null) {
                    RmSiteType.this.rmContainerCacheManager.reset();
                }
                return null;
            }
        });
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION)
    public void onCreateChildAssociation(final ChildAssociationRef childAssocRef, boolean isNewNode) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                NodeRef child = childAssocRef.getChildRef();
                NodeRef parent = childAssocRef.getParentRef();
                ArrayList<QName> acceptedUniqueChildTypes = new ArrayList<QName>();
                SiteInfo siteInfo = RmSiteType.this.siteService.getSite(parent);
                acceptedUniqueChildTypes.add(RmSiteType.this.getFilePlanType(siteInfo));
                RmSiteType.this.validateNewChildAssociation(parent, child, acceptedUniqueChildTypes, ACCEPTED_NON_UNIQUE_CHILD_TYPES);
                return null;
            }
        });
    }

    @Behaviour(kind=BehaviourKind.CLASS, policy="alf:onDeleteNode", notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onDeleteNodeOnCommit(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        if (this.rmContainerCacheManager != null) {
            this.rmContainerCacheManager.reset();
        }
        this.filePlanType.enable();
    }
}

