/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.behaviour;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementServiceRegistry;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionScheduleImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.model.rma.aspect.FrozenAspect;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordDefinition;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordsManagementSearchBehaviour
implements RecordsManagementModel,
NodeServicePolicies.OnMoveNodePolicy {
    private static Log logger = LogFactory.getLog(RecordsManagementSearchBehaviour.class);
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private DispositionService dispositionService;
    private RecordsManagementServiceRegistry recordsManagementServiceRegistry;
    private VitalRecordService vitalRecordService;
    private RecordFolderService recordFolderService;
    private RecordService recordService;
    private FrozenAspect frozenAspect;
    private JavaBehaviour onAddSearchAspect = new JavaBehaviour((Object)this, "rmSearchAspectAdd", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
    private JavaBehaviour jbDispositionActionCreate = new JavaBehaviour((Object)this, "dispositionActionCreate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
    private JavaBehaviour jbDispositionActionPropertiesUpdate = new JavaBehaviour((Object)this, "dispositionActionPropertiesUpdate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
    private JavaBehaviour jbDispositionLifeCycleAspect = new JavaBehaviour((Object)this, "onAddDispositionLifecycleAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
    private JavaBehaviour jbDispositionSchedulePropertiesUpdate = new JavaBehaviour((Object)this, "dispositionSchedulePropertiesUpdate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
    private JavaBehaviour jbEventExecutionUpdate = new JavaBehaviour((Object)this, "eventExecutionUpdate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
    private JavaBehaviour jbEventExecutionDelete = new JavaBehaviour((Object)this, "eventExecutionDelete", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
    private JavaBehaviour jbMoveNode = new JavaBehaviour((Object)this, "onMoveNode", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
    private JavaBehaviour[] jbDispositionBehaviours = new JavaBehaviour[]{this.jbDispositionActionCreate, this.jbDispositionActionPropertiesUpdate, this.jbDispositionSchedulePropertiesUpdate, this.jbEventExecutionUpdate, this.jbEventExecutionDelete, this.jbDispositionLifeCycleAspect};

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRecordsManagementServiceRegistry(RecordsManagementServiceRegistry recordsManagementServiceRegistry) {
        this.recordsManagementServiceRegistry = recordsManagementServiceRegistry;
    }

    public void setVitalRecordService(VitalRecordService vitalRecordService) {
        this.vitalRecordService = vitalRecordService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setFrozenAspect(FrozenAspect frozenAspect) {
        this.frozenAspect = frozenAspect;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), TYPE_DISPOSITION_ACTION, (Behaviour)this.jbDispositionActionCreate);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), TYPE_DISPOSITION_ACTION, (Behaviour)this.jbDispositionActionPropertiesUpdate);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), TYPE_DISPOSITION_SCHEDULE, (Behaviour)this.jbDispositionSchedulePropertiesUpdate);
        this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateChildAssociation"), TYPE_DISPOSITION_ACTION, ASSOC_EVENT_EXECUTIONS, (Behaviour)this.jbEventExecutionUpdate);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), TYPE_EVENT_EXECUTION, (Behaviour)this.jbEventExecutionDelete);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ASPECT_RM_SEARCH, (Behaviour)this.onAddSearchAspect);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ASPECT_DISPOSITION_LIFECYCLE, (Behaviour)this.jbDispositionLifeCycleAspect);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ASPECT_RECORD, (Behaviour)new JavaBehaviour((Object)this, "onAddRecordAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), TYPE_RECORD_FOLDER, (Behaviour)new JavaBehaviour((Object)this, "recordFolderCreate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onSetNodeType"), TYPE_RECORD_FOLDER, (Behaviour)new JavaBehaviour((Object)this, "convertedToOrFromRecordFolder", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ASPECT_VITAL_RECORD_DEFINITION, (Behaviour)new JavaBehaviour((Object)this, "vitalRecordDefintionAddAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ASPECT_VITAL_RECORD_DEFINITION, (Behaviour)new JavaBehaviour((Object)this, "vitalRecordDefintionUpdateProperties", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onMoveNode"), ASPECT_FILE_PLAN_COMPONENT, (Behaviour)this.jbMoveNode);
    }

    public void disableDispositionScheduleBehaviour() {
        for (JavaBehaviour jb : this.jbDispositionBehaviours) {
            jb.disable();
        }
    }

    public void enableDispositionScheduleBehaviour() {
        for (JavaBehaviour jb : this.jbDispositionBehaviours) {
            jb.enable();
        }
    }

    public void fixupSearchAspect(NodeRef recordOrFolder) {
        if (this.recordFolderService.isRecordFolder(recordOrFolder)) {
            this.applySearchAspect(recordOrFolder);
            this.setupDispositionScheduleProperties(recordOrFolder);
            DispositionAction da = this.dispositionService.getNextDispositionAction(recordOrFolder);
            if (da != null) {
                this.updateDispositionActionProperties(recordOrFolder, da.getNodeRef());
                this.setupDispositionActionEvents(recordOrFolder, da);
            }
            this.setVitalRecordDefintionDetails(recordOrFolder);
        }
    }

    public void dispositionActionPropertiesUpdate(final NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.nodeService.exists(nodeRef)) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    ChildAssociationRef assoc = RecordsManagementSearchBehaviour.this.nodeService.getPrimaryParent(nodeRef);
                    if (assoc.getTypeQName().equals((Object)RecordsManagementModel.ASSOC_NEXT_DISPOSITION_ACTION)) {
                        NodeRef record = assoc.getParentRef();
                        RecordsManagementSearchBehaviour.this.applySearchAspect(record);
                        RecordsManagementSearchBehaviour.this.updateDispositionActionProperties(record, nodeRef);
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private void applySearchAspect(NodeRef nodeRef) {
        this.onAddSearchAspect.disable();
        try {
            if (!this.nodeService.hasAspect(nodeRef, ASPECT_RM_SEARCH)) {
                this.nodeService.addAspect(nodeRef, ASPECT_RM_SEARCH, null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added search aspect to node: " + nodeRef));
                }
            }
        }
        finally {
            this.onAddSearchAspect.enable();
        }
    }

    public void onAddRecordAspect(final NodeRef nodeRef, QName aspectTypeQName) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (RecordsManagementSearchBehaviour.this.nodeService.exists(nodeRef) && RecordsManagementSearchBehaviour.this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_RECORD)) {
                    RecordsManagementSearchBehaviour.this.applySearchAspect(nodeRef);
                    RecordsManagementSearchBehaviour.this.setupDispositionScheduleProperties(nodeRef);
                }
                return null;
            }
        });
    }

    public void onAddDispositionLifecycleAspect(final NodeRef nodeRef, QName aspectTypeQName) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (RecordsManagementSearchBehaviour.this.nodeService.exists(nodeRef) && RecordsManagementSearchBehaviour.this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_RECORD)) {
                    RecordsManagementSearchBehaviour.this.applySearchAspect(nodeRef);
                    RecordsManagementSearchBehaviour.this.setupDispositionScheduleProperties(nodeRef);
                }
                return null;
            }
        });
    }

    public void recordFolderCreate(final ChildAssociationRef childAssocRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef nodeRef = childAssocRef.getChildRef();
                if (RecordsManagementSearchBehaviour.this.nodeService.exists(nodeRef)) {
                    RecordsManagementSearchBehaviour.this.applySearchAspect(nodeRef);
                    RecordsManagementSearchBehaviour.this.setupDispositionScheduleProperties(nodeRef);
                }
                return null;
            }
        });
    }

    public void convertedToOrFromRecordFolder(final NodeRef nodeRef, QName oldType, final QName newType) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (newType.equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER) && RecordsManagementSearchBehaviour.this.nodeService.exists(nodeRef)) {
                    RecordsManagementSearchBehaviour.this.applySearchAspect(nodeRef);
                    RecordsManagementSearchBehaviour.this.setupDispositionScheduleProperties(nodeRef);
                }
                return null;
            }
        });
    }

    private void setupDispositionScheduleProperties(NodeRef recordOrFolder) {
        if (!this.methodCached("setupDispositionScheduleProperties", recordOrFolder)) {
            DispositionSchedule ds = this.dispositionService.getDispositionSchedule(recordOrFolder);
            if (ds == null) {
                this.nodeService.setProperty(recordOrFolder, PROP_RS_HAS_DISPOITION_SCHEDULE, (Serializable)Boolean.valueOf(false));
            } else {
                this.nodeService.setProperty(recordOrFolder, PROP_RS_HAS_DISPOITION_SCHEDULE, (Serializable)Boolean.valueOf(true));
                this.setDispositionScheduleProperties(recordOrFolder, ds);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set rma:recordSearchHasDispositionSchedule for node " + recordOrFolder + " to: " + (ds != null)));
            }
        }
    }

    public void dispositionActionCreate(final ChildAssociationRef childAssocRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef child = childAssocRef.getChildRef();
                if (RecordsManagementSearchBehaviour.this.nodeService.exists(child) && childAssocRef.getTypeQName().equals((Object)RecordsManagementModel.ASSOC_NEXT_DISPOSITION_ACTION)) {
                    NodeRef record = childAssocRef.getParentRef();
                    RecordsManagementSearchBehaviour.this.applySearchAspect(record);
                    RecordsManagementSearchBehaviour.this.updateDispositionActionProperties(record, childAssocRef.getChildRef());
                    RecordsManagementSearchBehaviour.this.nodeService.setProperty(record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS, null);
                }
                return null;
            }
        });
    }

    private boolean methodCached(String method, NodeRef nodeRef) {
        String key;
        boolean result = true;
        Set methods = TransactionalResourceHelper.getSet((Object)"rm.seachrollup.methodCache");
        if (!methods.contains(key = method + "|" + nodeRef)) {
            result = false;
            methods.add(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDispositionActionProperties(NodeRef record, NodeRef dispositionAction) {
        Map props = this.nodeService.getProperties(record);
        DispositionActionImpl da = new DispositionActionImpl(this.recordsManagementServiceRegistry, dispositionAction);
        props.put(PROP_RS_DISPOSITION_ACTION_NAME, da.getName());
        props.put(PROP_RS_DISPOSITION_ACTION_AS_OF, da.getAsOfDate());
        props.put(PROP_RS_DISPOSITION_EVENTS_ELIGIBLE, this.nodeService.getProperty(dispositionAction, PROP_DISPOSITION_EVENTS_ELIGIBLE));
        DispositionActionDefinition daDefinition = da.getDispositionActionDefinition();
        if (daDefinition != null) {
            Period period = daDefinition.getPeriod();
            if (period != null) {
                props.put(PROP_RS_DISPOSITION_PERIOD, period.getPeriodType());
                props.put(PROP_RS_DISPOSITION_PERIOD_EXPRESSION, period.getExpression());
            } else {
                props.put(PROP_RS_DISPOSITION_PERIOD, null);
                props.put(PROP_RS_DISPOSITION_PERIOD_EXPRESSION, null);
            }
        }
        try {
            this.frozenAspect.disableOnPropUpdateFrozenAspect();
            this.nodeService.setProperties(record, props);
        }
        finally {
            this.frozenAspect.enableOnPropUpdateFrozenAspect();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set rma:recordSearchDispositionActionName for node " + record + " to: " + props.get(PROP_RS_DISPOSITION_ACTION_NAME)));
            logger.debug((Object)("Set rma:recordSearchDispositionActionAsOf for node " + record + " to: " + props.get(PROP_RS_DISPOSITION_ACTION_AS_OF)));
            logger.debug((Object)("Set rma:recordSearchDispositionEventsEligible for node " + record + " to: " + props.get(PROP_RS_DISPOSITION_EVENTS_ELIGIBLE)));
            logger.debug((Object)("Set rma:recordSearchDispositionPeriod for node " + record + " to: " + props.get(PROP_RS_DISPOSITION_PERIOD)));
            logger.debug((Object)("Set rma:recordSearchDispositionPeriodExpression for node " + record + " to: " + props.get(PROP_RS_DISPOSITION_PERIOD_EXPRESSION)));
        }
    }

    public void eventExecutionUpdate(ChildAssociationRef childAssocRef, boolean isNewNode) {
        ChildAssociationRef assoc;
        NodeRef dispositionAction = childAssocRef.getParentRef();
        NodeRef eventExecution = childAssocRef.getChildRef();
        if (this.nodeService.exists(dispositionAction) && this.nodeService.exists(eventExecution) && (assoc = this.nodeService.getPrimaryParent(dispositionAction)).getTypeQName().equals((Object)ASSOC_NEXT_DISPOSITION_ACTION)) {
            NodeRef record = assoc.getParentRef();
            this.applySearchAspect(record);
            ArrayList<String> events = (ArrayList<String>)this.nodeService.getProperty(record, PROP_RS_DISPOSITION_EVENTS);
            if (events == null) {
                events = new ArrayList<String>(1);
            }
            events.add((String)((Object)this.nodeService.getProperty(eventExecution, PROP_EVENT_EXECUTION_NAME)));
            this.nodeService.setProperty(record, PROP_RS_DISPOSITION_EVENTS, (Serializable)events);
        }
    }

    public void eventExecutionDelete(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        ChildAssociationRef assoc;
        NodeRef dispositionActionNode = childAssocRef.getParentRef();
        if (this.nodeService.exists(dispositionActionNode) && (assoc = this.nodeService.getPrimaryParent(dispositionActionNode)).getTypeQName().equals((Object)ASSOC_NEXT_DISPOSITION_ACTION)) {
            NodeRef record = assoc.getParentRef();
            this.applySearchAspect(record);
            this.setupDispositionActionEvents(record, this.dispositionService.getNextDispositionAction(record));
        }
    }

    private void setupDispositionActionEvents(NodeRef nodeRef, DispositionAction da) {
        if (!this.methodCached("setupDispositionActionEvents", nodeRef) && da != null) {
            ArrayList<String> eventNames = null;
            List<EventCompletionDetails> eventsList = da.getEventCompletionDetails();
            if (eventsList.size() > 0) {
                eventNames = new ArrayList<String>(eventsList.size());
                for (EventCompletionDetails event : eventsList) {
                    eventNames.add(event.getEventName());
                }
            }
            this.nodeService.setProperty(nodeRef, PROP_RS_DISPOSITION_EVENTS, (Serializable)eventNames);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set rma:recordSearchDispositionEvents for node " + nodeRef + " to: " + eventNames));
            }
        }
    }

    public void rmSearchAspectAdd(final NodeRef nodeRef, QName aspectTypeQName) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (RecordsManagementSearchBehaviour.this.nodeService.exists(nodeRef)) {
                    RecordsManagementSearchBehaviour.this.setVitalRecordDefintionDetails(nodeRef);
                }
                return null;
            }
        });
    }

    public void vitalRecordDefintionAddAspect(final NodeRef nodeRef, QName aspectTypeQName) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (RecordsManagementSearchBehaviour.this.nodeService.exists(nodeRef) && RecordsManagementSearchBehaviour.this.recordFolderService.isRecordFolder(nodeRef)) {
                    RecordsManagementSearchBehaviour.this.updateVitalRecordDefinitionValues(nodeRef);
                }
                return null;
            }
        });
    }

    public void vitalRecordDefintionUpdateProperties(final NodeRef nodeRef, final Map<QName, Serializable> before, final Map<QName, Serializable> after) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (RecordsManagementSearchBehaviour.this.nodeService.exists(nodeRef) && RecordsManagementSearchBehaviour.this.recordFolderService.isRecordFolder(nodeRef)) {
                    HashSet<QName> props = new HashSet<QName>(1);
                    props.add(RecordsManagementModel.PROP_REVIEW_PERIOD);
                    Set<QName> changed = RecordsManagementSearchBehaviour.this.determineChangedProps(before, after);
                    changed.retainAll(props);
                    if (!changed.isEmpty()) {
                        RecordsManagementSearchBehaviour.this.updateVitalRecordDefinitionValues(nodeRef);
                    }
                }
                return null;
            }
        });
    }

    private void updateVitalRecordDefinitionValues(NodeRef nodeRef) {
        if (!this.methodCached("updateVitalRecordDefinitionValues", nodeRef)) {
            this.applySearchAspect(nodeRef);
            this.setVitalRecordDefintionDetails(nodeRef);
            List<NodeRef> records = this.recordService.getRecords(nodeRef);
            for (NodeRef record : records) {
                this.applySearchAspect(record);
                this.setVitalRecordDefintionDetails(record);
            }
        }
    }

    private void setVitalRecordDefintionDetails(NodeRef nodeRef) {
        if (!this.methodCached("setVitalRecordDefinitionDetails", nodeRef)) {
            VitalRecordDefinition vrd = this.vitalRecordService.getVitalRecordDefinition(nodeRef);
            try {
                this.frozenAspect.disableOnPropUpdateFrozenAspect();
                if (vrd != null && vrd.isEnabled() && vrd.getReviewPeriod() != null) {
                    this.nodeService.setProperty(nodeRef, PROP_RS_VITAL_RECORD_REVIEW_PERIOD, (Serializable)((Object)vrd.getReviewPeriod().getPeriodType()));
                    this.nodeService.setProperty(nodeRef, PROP_RS_VITAL_RECORD_REVIEW_PERIOD_EXPRESSION, (Serializable)((Object)vrd.getReviewPeriod().getExpression()));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Set rma:recordSearchVitalRecordReviewPeriod for node " + nodeRef + " to: " + vrd.getReviewPeriod().getPeriodType()));
                        logger.debug((Object)("Set rma:recordSearchVitalRecordReviewPeriodExpression for node " + nodeRef + " to: " + vrd.getReviewPeriod().getExpression()));
                    }
                } else {
                    this.nodeService.setProperty(nodeRef, PROP_RS_VITAL_RECORD_REVIEW_PERIOD, null);
                    this.nodeService.setProperty(nodeRef, PROP_RS_VITAL_RECORD_REVIEW_PERIOD_EXPRESSION, null);
                }
            }
            finally {
                this.frozenAspect.enableOnPropUpdateFrozenAspect();
            }
        }
    }

    public void dispositionSchedulePropertiesUpdate(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        block5: {
            if (!this.nodeService.exists(nodeRef)) break block5;
            DispositionScheduleImpl schedule = new DispositionScheduleImpl(this.recordsManagementServiceRegistry, this.nodeService, nodeRef);
            NodeRef recordCategoryNode = this.nodeService.getPrimaryParent(schedule.getNodeRef()).getParentRef();
            if (schedule.isRecordLevelDisposition()) {
                for (NodeRef recordFolder : this.getRecordFolders(recordCategoryNode)) {
                    for (NodeRef record : this.recordService.getRecords(recordFolder)) {
                        this.applySearchAspect(record);
                        this.setDispositionScheduleProperties(record, schedule);
                    }
                }
            } else {
                for (NodeRef recordFolder : this.getRecordFolders(recordCategoryNode)) {
                    this.applySearchAspect(recordFolder);
                    this.setDispositionScheduleProperties(recordFolder, schedule);
                }
            }
        }
    }

    private void setDispositionScheduleProperties(NodeRef recordOrFolder, DispositionSchedule schedule) {
        if (schedule != null) {
            try {
                this.frozenAspect.disableOnPropUpdateFrozenAspect();
                this.nodeService.setProperty(recordOrFolder, PROP_RS_DISPOITION_AUTHORITY, (Serializable)((Object)schedule.getDispositionAuthority()));
                this.nodeService.setProperty(recordOrFolder, PROP_RS_DISPOITION_INSTRUCTIONS, (Serializable)((Object)schedule.getDispositionInstructions()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set rma:recordSearchDispositionAuthority for node " + recordOrFolder + " to: " + schedule.getDispositionAuthority()));
                    logger.debug((Object)("Set rma:recordSearchDispositionInstructions for node " + recordOrFolder + " to: " + schedule.getDispositionInstructions()));
                }
            }
            finally {
                this.frozenAspect.enableOnPropUpdateFrozenAspect();
            }
        }
    }

    private Set<QName> determineChangedProps(Map<QName, Serializable> oldProps, Map<QName, Serializable> newProps) {
        HashSet<QName> result = new HashSet<QName>();
        for (Map.Entry<QName, Serializable> entry : oldProps.entrySet()) {
            QName qn = entry.getKey();
            if (newProps.get(qn) != null && newProps.get(qn).equals(entry.getValue())) continue;
            result.add(qn);
        }
        for (QName qn : newProps.keySet()) {
            if (oldProps.get(qn) != null) continue;
            result.add(qn);
        }
        return result;
    }

    private List<NodeRef> getRecordFolders(NodeRef recordCategoryNode) {
        ArrayList<NodeRef> results = new ArrayList<NodeRef>(8);
        List folderAssocs = this.nodeService.getChildAssocs(recordCategoryNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef folderAssoc : folderAssocs) {
            NodeRef folder = folderAssoc.getChildRef();
            if (!this.recordFolderService.isRecordFolder(folder)) continue;
            results.add(folder);
        }
        return results;
    }

    @org.alfresco.repo.policy.annotation.Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (!oldChildAssocRef.getParentRef().equals((Object)newChildAssocRef.getParentRef())) {
            final NodeRef recordOrFolder = newChildAssocRef.getChildRef();
            final boolean isRecordOrFolder = this.recordService.isRecord(recordOrFolder) || this.recordFolderService.isRecordFolder(recordOrFolder);
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    if (RecordsManagementSearchBehaviour.this.nodeService.exists(recordOrFolder) && isRecordOrFolder) {
                        RecordsManagementSearchBehaviour.this.applySearchAspect(recordOrFolder);
                    }
                    return null;
                }
            });
        }
    }
}

