/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.job;

import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.job.DispositionLifecycleJobExecuter;
import org.alfresco.module.org_alfresco_module_rm.job.RecordsManagementJobExecuter;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RecordsManagementJob
implements Job {
    private static Log logger = LogFactory.getLog(RecordsManagementJob.class);
    private String runAuditAs = AuthenticationUtil.getSystemUserName();
    private static final long DEFAULT_TIME = 30000L;
    private JobLockService jobLockService;
    private RecordsManagementJobExecuter jobExecuter = null;
    private String jobName;

    private QName getLockQName() {
        return QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)this.jobName);
    }

    private String getLock() {
        try {
            return this.jobLockService.getLock(this.getLockQName(), 30000L);
        }
        catch (LockAcquisitionException e) {
            return null;
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.jobLockService = (JobLockService)context.getJobDetail().getJobDataMap().get((Object)"jobLockService");
        if (this.jobLockService == null) {
            throw new AlfrescoRuntimeException("Job lock service has not been specified.");
        }
        this.jobExecuter = (RecordsManagementJobExecuter)context.getJobDetail().getJobDataMap().get((Object)"jobExecuter");
        if (this.jobExecuter == null) {
            throw new AlfrescoRuntimeException("Job executer has not been specified.");
        }
        this.jobName = (String)context.getJobDetail().getJobDataMap().get((Object)"jobName");
        if (this.jobName == null) {
            throw new AlfrescoRuntimeException("Job name has not been specified.");
        }
        if (this.jobName.compareTo("dispositionLifecycle") == 0) {
            if (this.jobExecuter instanceof DispositionLifecycleJobExecuter) {
                String auditUser = (String)context.getJobDetail().getJobDataMap().get((Object)"runAuditAs");
                if (((DispositionLifecycleJobExecuter)this.jobExecuter).getPersonService().getPersonOrNull(auditUser) != null) {
                    this.setRunAuditAs(auditUser);
                } else {
                    this.setRunAuditAs(AuthenticationUtil.getSystemUserName());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DispositionLifecycleJobExecuter() logged audit history with user: " + this.getRunAuditAs()));
            }
        }
        final LockCallback lockCallback = new LockCallback();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                String lockToken = RecordsManagementJob.this.getLock();
                if (lockToken != null) {
                    try {
                        RecordsManagementJob.this.jobLockService.refreshLock(lockToken, RecordsManagementJob.this.getLockQName(), 30000L, (JobLockService.JobLockRefreshCallback)lockCallback);
                        RecordsManagementJob.this.jobExecuter.execute();
                    }
                    finally {
                        block9: {
                            try {
                                lockCallback.running.set(false);
                                RecordsManagementJob.this.jobLockService.releaseLock(lockToken, RecordsManagementJob.this.getLockQName());
                            }
                            catch (LockAcquisitionException e) {
                                if (!logger.isDebugEnabled()) break block9;
                                logger.debug((Object)("Lock release failed: " + RecordsManagementJob.this.getLockQName() + ": " + lockToken + "(" + e.getMessage() + ")"));
                            }
                        }
                    }
                }
                return null;
            }
        }, (String)this.getRunAuditAs());
    }

    public String getRunAuditAs() {
        return this.runAuditAs;
    }

    public void setRunAuditAs(String runAuditAs) {
        this.runAuditAs = runAuditAs;
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);

        private LockCallback() {
        }

        public boolean isActive() {
            return this.running.get();
        }

        public void lockReleased() {
            this.running.set(false);
        }
    }
}

