/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.forms;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementServiceRegistry;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.processor.AbstractFilter;
import org.alfresco.repo.forms.processor.node.FieldUtils;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RecordsManagementFormFilter<ItemType>
extends AbstractFilter<ItemType, NodeRef> {
    private static Log logger = LogFactory.getLog(RecordsManagementFormFilter.class);
    public static final String CUSTOM_RM_FIELD_GROUP_ID = "rm-custom";
    public static final String RM_METADATA_PREFIX = "rm-metadata-";
    protected NamespaceService namespaceService;
    protected NodeService nodeService;
    protected RecordsManagementServiceRegistry rmServiceRegistry;
    protected RecordsManagementAdminService rmAdminService;
    protected RecordService recordService;
    protected DictionaryService dictionaryService;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRecordsManagementServiceRegistry(RecordsManagementServiceRegistry rmServiceRegistry) {
        this.rmServiceRegistry = rmServiceRegistry;
    }

    public void setRecordsManagementAdminService(RecordsManagementAdminService rmAdminService) {
        this.rmAdminService = rmAdminService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected void addPropertyFieldsToGroup(Form form, Map<QName, PropertyDefinition> props, String setId, String setLabel) {
        if (props != null) {
            for (Map.Entry<QName, PropertyDefinition> entry : props.entrySet()) {
                PropertyDefinition prop = entry.getValue();
                String id = form.getItem().getId();
                id = id.replaceFirst("/", "://");
                NodeRef nodeRef = new NodeRef(id);
                Serializable value = this.nodeService.getProperty(nodeRef, entry.getKey());
                FieldGroup group = new FieldGroup(setId, setLabel, false, false, null);
                Field field = FieldUtils.makePropertyField((PropertyDefinition)prop, (Object)value, (FieldGroup)group, (NamespaceService)this.namespaceService, (DictionaryService)this.dictionaryService);
                form.addField(field);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Adding custom property .. " + prop.getName().toString() + " .. with value " + value + ".. to group .. " + setId));
            }
        }
    }

    public void beforePersist(ItemType item, FormData data) {
    }

    public void beforeGenerate(ItemType item, List<String> fields, List<String> forcedFields, Form form, Map<String, Object> context) {
    }

    public void afterPersist(ItemType item, FormData data, NodeRef persistedObject) {
    }
}

