/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.disposition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementServiceRegistry;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DispositionActionImpl
implements DispositionAction,
RecordsManagementModel {
    private static Log logger = LogFactory.getLog(DispositionActionImpl.class);
    private RecordsManagementServiceRegistry services;
    private NodeRef dispositionNodeRef;
    private DispositionActionDefinition dispositionActionDefinition;

    public DispositionActionImpl(RecordsManagementServiceRegistry services, NodeRef dispositionActionNodeRef) {
        this.services = services;
        this.dispositionNodeRef = dispositionActionNodeRef;
    }

    @Override
    public DispositionActionDefinition getDispositionActionDefinition() {
        if (this.dispositionActionDefinition == null) {
            DispositionSchedule ds;
            String id = (String)((Object)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_ACTION_ID));
            NodeRef recordNodeRef = this.services.getNodeService().getPrimaryParent(this.dispositionNodeRef).getParentRef();
            if (recordNodeRef != null && (ds = this.services.getDispositionService().getDispositionSchedule(recordNodeRef)) != null) {
                this.dispositionActionDefinition = ds.getDispositionActionDefinition(id);
            }
        }
        return this.dispositionActionDefinition;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.dispositionNodeRef;
    }

    @Override
    public String getLabel() {
        String name;
        String label = name = this.getName();
        RecordsManagementAction action = this.services.getRecordsManagementActionService().getDispositionAction(name);
        if (action != null) {
            label = action.getLabel();
        }
        return label;
    }

    @Override
    public String getId() {
        return (String)((Object)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_ACTION_ID));
    }

    @Override
    public String getName() {
        return (String)((Object)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_ACTION));
    }

    @Override
    public Date getAsOfDate() {
        return (Date)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_AS_OF);
    }

    @Override
    public boolean isEventsEligible() {
        return (Boolean)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_EVENTS_ELIGIBLE);
    }

    @Override
    public Date getCompletedAt() {
        return (Date)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_ACTION_COMPLETED_AT);
    }

    @Override
    public String getCompletedBy() {
        return (String)((Object)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_ACTION_COMPLETED_BY));
    }

    @Override
    public Date getStartedAt() {
        return (Date)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_ACTION_STARTED_AT);
    }

    @Override
    public String getStartedBy() {
        return (String)((Object)this.services.getNodeService().getProperty(this.dispositionNodeRef, PROP_DISPOSITION_ACTION_STARTED_BY));
    }

    @Override
    public List<EventCompletionDetails> getEventCompletionDetails() {
        List assocs = this.services.getNodeService().getChildAssocs(this.dispositionNodeRef, (QNamePattern)ASSOC_EVENT_EXECUTIONS, RegexQNamePattern.MATCH_ALL);
        ArrayList<EventCompletionDetails> result = new ArrayList<EventCompletionDetails>(assocs.size());
        for (ChildAssociationRef assoc : assocs) {
            result.add(this.getEventCompletionDetailsFromNodeRef(assoc.getChildRef()));
        }
        return result;
    }

    private EventCompletionDetails getEventCompletionDetailsFromNodeRef(NodeRef nodeRef) {
        Map props = this.services.getNodeService().getProperties(nodeRef);
        String eventName = (String)props.get(PROP_EVENT_EXECUTION_NAME);
        return new EventCompletionDetails(nodeRef, eventName, this.services.getRecordsManagementEventService().getEvent(eventName).getDisplayLabel(), this.getBooleanValue(props.get(PROP_EVENT_EXECUTION_AUTOMATIC), false), this.getBooleanValue(props.get(PROP_EVENT_EXECUTION_COMPLETE), false), (Date)props.get(PROP_EVENT_EXECUTION_COMPLETED_AT), (String)props.get(PROP_EVENT_EXECUTION_COMPLETED_BY));
    }

    private boolean getBooleanValue(Object value, boolean defaultValue) {
        boolean result = defaultValue;
        if (value instanceof Boolean) {
            result = (Boolean)value;
        }
        return result;
    }

    @Override
    public EventCompletionDetails getEventCompletionDetails(String eventName) {
        EventCompletionDetails result = null;
        List assocs = this.services.getNodeService().getChildAssocsByPropertyValue(this.dispositionNodeRef, PROP_EVENT_EXECUTION_NAME, (Serializable)((Object)eventName));
        if (!assocs.isEmpty()) {
            if (assocs.size() != 1) {
                throw new AlfrescoRuntimeException("Unable to get event completion details, because more than one child was found for event " + eventName);
            }
            result = this.getEventCompletionDetailsFromNodeRef(((ChildAssociationRef)assocs.get(0)).getChildRef());
        }
        return result;
    }

    @Override
    public void completeEvent(final String eventName, final Date completedAt, final String completedBy) {
        final EventCompletionDetails event = this.getEventCompletionDetails(eventName);
        if (event != null && !event.isEventComplete()) {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    Date completedAtValue = completedAt;
                    if (completedAt == null) {
                        completedAtValue = new Date();
                    }
                    String completedByValue = completedBy;
                    if (completedBy == null) {
                        completedByValue = AuthenticationUtil.getFullyAuthenticatedUser();
                    }
                    NodeRef eventNodeRef = event.getNodeRef();
                    Map props = DispositionActionImpl.this.services.getNodeService().getProperties(eventNodeRef);
                    props.put(RecordsManagementModel.PROP_EVENT_EXECUTION_COMPLETE, true);
                    props.put(RecordsManagementModel.PROP_EVENT_EXECUTION_COMPLETED_AT, completedAtValue);
                    props.put(RecordsManagementModel.PROP_EVENT_EXECUTION_COMPLETED_BY, completedByValue);
                    DispositionActionImpl.this.services.getNodeService().setProperties(eventNodeRef, props);
                    if (eventName.equals("declassification_review")) {
                        DispositionActionImpl.this.setDeclassificationReview(eventNodeRef, completedAtValue, completedByValue);
                    }
                    DispositionActionImpl.this.updateEventEligible();
                    return null;
                }
            });
        }
    }

    @Override
    public void undoEvent(String eventName) {
        final EventCompletionDetails event = this.getEventCompletionDetails(eventName);
        if (event != null && event.isEventComplete()) {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    NodeRef eventNodeRef = event.getNodeRef();
                    Map props = DispositionActionImpl.this.services.getNodeService().getProperties(eventNodeRef);
                    props.put(RecordsManagementModel.PROP_EVENT_EXECUTION_COMPLETE, false);
                    props.put(RecordsManagementModel.PROP_EVENT_EXECUTION_COMPLETED_AT, null);
                    props.put(RecordsManagementModel.PROP_EVENT_EXECUTION_COMPLETED_BY, null);
                    DispositionActionImpl.this.services.getNodeService().setProperties(eventNodeRef, props);
                    DispositionActionImpl.this.updateEventEligible();
                    return null;
                }
            });
        }
    }

    @Override
    public void refreshEvents() {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                List stepEvents = (List)((Object)DispositionActionImpl.this.services.getNodeService().getProperty(DispositionActionImpl.this.getDispositionActionDefinition().getNodeRef(), RecordsManagementModel.PROP_DISPOSITION_EVENT));
                List<EventCompletionDetails> eventsList = DispositionActionImpl.this.getEventCompletionDetails();
                ArrayList<String> nextActionEvents = new ArrayList<String>(eventsList.size());
                for (EventCompletionDetails event : eventsList) {
                    String eventName = event.getEventName();
                    nextActionEvents.add(eventName);
                    if (stepEvents == null || stepEvents.contains(event.getEventName())) continue;
                    DispositionActionImpl.this.services.getNodeService().removeChild(DispositionActionImpl.this.getNodeRef(), event.getNodeRef());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Removed '" + eventName + "' from next action '" + DispositionActionImpl.this.getName() + "' (" + DispositionActionImpl.this.getNodeRef() + ")"));
                }
                if (stepEvents != null) {
                    for (String eventName : stepEvents) {
                        if (nextActionEvents.contains(eventName)) continue;
                        DispositionActionImpl.this.addEventCompletionDetails(DispositionActionImpl.this.services.getRecordsManagementEventService().getEvent(eventName));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Added '" + eventName + "' to next action '" + DispositionActionImpl.this.getName() + "' (" + DispositionActionImpl.this.getNodeRef() + ")"));
                    }
                }
                boolean eligible = DispositionActionImpl.this.updateEventEligible();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set events eligible flag to '" + eligible + "' for next action '" + DispositionActionImpl.this.getName() + "' (" + DispositionActionImpl.this.getNodeRef() + ")"));
                }
                return null;
            }
        });
    }

    @Override
    public void addEventCompletionDetails(RecordsManagementEvent event) {
        HashMap<QName, Object> eventProps = new HashMap<QName, Object>(7);
        eventProps.put(PROP_EVENT_EXECUTION_NAME, event.getName());
        eventProps.put(PROP_EVENT_EXECUTION_AUTOMATIC, event.getRecordsManagementEventType().isAutomaticEvent());
        eventProps.put(PROP_EVENT_EXECUTION_COMPLETE, false);
        this.services.getNodeService().createNode(this.getNodeRef(), ASSOC_EVENT_EXECUTIONS, ASSOC_EVENT_EXECUTIONS, TYPE_EVENT_EXECUTION, eventProps);
    }

    private boolean updateEventEligible() {
        DispositionActionDefinition dispositionActionDefinition;
        boolean eligible = false;
        List<EventCompletionDetails> events = this.getEventCompletionDetails();
        if (!events.isEmpty() && (dispositionActionDefinition = this.getDispositionActionDefinition()) != null) {
            if (!dispositionActionDefinition.eligibleOnFirstCompleteEvent()) {
                eligible = true;
                for (EventCompletionDetails event : events) {
                    if (event.isEventComplete()) continue;
                    eligible = false;
                    break;
                }
            } else {
                for (EventCompletionDetails event : events) {
                    if (!event.isEventComplete()) continue;
                    eligible = true;
                    break;
                }
            }
        }
        this.services.getNodeService().setProperty(this.getNodeRef(), PROP_DISPOSITION_EVENTS_ELIGIBLE, (Serializable)Boolean.valueOf(eligible));
        return eligible;
    }

    private void setDeclassificationReview(NodeRef eventNodeRef, Date completedAtValue, String completedByValue) {
        NodeRef nextDispositionActionNodeRef = this.services.getNodeService().getPrimaryParent(eventNodeRef).getParentRef();
        NodeRef nodeRef = this.services.getNodeService().getPrimaryParent(nextDispositionActionNodeRef).getParentRef();
        this.setPropsOnContent(nodeRef, completedAtValue, completedByValue);
        if (this.services.getNodeService().getType(nodeRef).equals((Object)RecordsManagementModel.TYPE_RECORD_FOLDER)) {
            List records = this.services.getNodeService().getChildAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef child : records) {
                NodeRef recordNodeRef = child.getChildRef();
                this.setPropsOnContent(recordNodeRef, completedAtValue, completedByValue);
            }
        }
    }

    private void setPropsOnContent(NodeRef nodeRef, Date completedAtValue, String completedByValue) {
        Map nodeProps = this.services.getNodeService().getProperties(nodeRef);
        nodeProps.put(PROP_RS_DECLASSIFICATION_REVIEW_COMPLETED_AT, completedAtValue);
        nodeProps.put(PROP_RS_DECLASSIFICATION_REVIEW_COMPLETED_BY, completedByValue);
        this.services.getNodeService().setProperties(nodeRef, nodeProps);
    }
}

