/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.content;

import java.io.File;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.content.cleanser.ContentCleanser;
import org.alfresco.module.org_alfresco_module_rm.util.TransactionalResourceHelper;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.cmr.repository.ContentReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EagerContentStoreCleaner
extends org.alfresco.repo.content.cleanup.EagerContentStoreCleaner {
    protected static final String KEY_POST_COMMIT_CLEANSING_URLS = "postCommitCleansingUrls";
    private static Log logger = LogFactory.getLog(EagerContentStoreCleaner.class);
    private TransactionalResourceHelper transactionalResourceHelper;
    private ContentCleanser contentCleanser;

    public void setTransactionalResourceHelper(TransactionalResourceHelper transactionalResourceHelper) {
        this.transactionalResourceHelper = transactionalResourceHelper;
    }

    public void setContentCleanser(ContentCleanser contentCleanser) {
        this.contentCleanser = contentCleanser;
    }

    public void registerOrphanedContentUrlForCleansing(String contentUrl) {
        Set cleansingUrls = this.transactionalResourceHelper.getSet(KEY_POST_COMMIT_CLEANSING_URLS);
        cleansingUrls.add(contentUrl);
        this.registerOrphanedContentUrl(contentUrl, true);
    }

    protected boolean deleteFromStore(String contentUrl, ContentStore store) {
        Set cleansingUrls = this.transactionalResourceHelper.getSet(KEY_POST_COMMIT_CLEANSING_URLS);
        if (cleansingUrls.contains(contentUrl)) {
            this.cleanseContent(contentUrl, store);
        }
        return super.deleteFromStore(contentUrl, store);
    }

    private void cleanseContent(String contentUrl, ContentStore store) {
        if (this.contentCleanser == null) {
            logger.error((Object)("No content cleanser specified.  Unable to cleanse: \n   URL:    " + contentUrl + "\n   Source: " + store));
        } else {
            ContentReader reader = store.getReader(contentUrl);
            if (reader != null && reader.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("About to cleanse: \n   URL:    " + contentUrl + "\n   Source: " + store));
                }
                try {
                    if (reader instanceof FileContentReader) {
                        FileContentReader fileReader = (FileContentReader)reader;
                        File file = fileReader.getFile();
                        this.contentCleanser.cleanse(file);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Content cleansing failed: \n   URL:    " + contentUrl + "\n   Source: " + store + "\n   Reader: " + reader), (Throwable)e);
                }
            } else {
                logger.error((Object)("Content no longer exists.  Unable to cleanse: \n   URL:    " + contentUrl + "\n   Source: " + store));
            }
        }
    }
}

