/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.caveat;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMCaveatConfigComponent;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMCaveatConfigService;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMConstraintInfo;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMListOfValuesConstraint;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMCaveatConfigServiceImpl
implements RMCaveatConfigService {
    private static Log logger = LogFactory.getLog(RMCaveatConfigServiceImpl.class);
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private RMCaveatConfigComponent rmCaveatConfigComponent;
    private RecordsManagementAdminService recordsManagementAdminService;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setCaveatConfigComponent(RMCaveatConfigComponent rmCaveatConfigComponent) {
        this.rmCaveatConfigComponent = rmCaveatConfigComponent;
    }

    public void setRecordsManagementAdminService(RecordsManagementAdminService recordsManagementAdminService) {
        this.recordsManagementAdminService = recordsManagementAdminService;
    }

    public RecordsManagementAdminService getRecordsManagementAdminService() {
        return this.recordsManagementAdminService;
    }

    @Override
    public void init() {
        this.rmCaveatConfigComponent.init();
    }

    @Override
    public NodeRef updateOrCreateCaveatConfig(InputStream is) {
        return this.rmCaveatConfigComponent.updateOrCreateCaveatConfig(is);
    }

    @Override
    public NodeRef updateOrCreateCaveatConfig(File jsonFile) {
        return this.rmCaveatConfigComponent.updateOrCreateCaveatConfig(jsonFile);
    }

    @Override
    public NodeRef updateOrCreateCaveatConfig(String jsonString) {
        return this.rmCaveatConfigComponent.updateOrCreateCaveatConfig(jsonString);
    }

    @Override
    public List<String> getRMAllowedValues(String constraintName) {
        return this.rmCaveatConfigComponent.getRMAllowedValues(constraintName);
    }

    @Override
    public boolean hasAccess(NodeRef nodeRef) {
        return this.rmCaveatConfigComponent.hasAccess(nodeRef);
    }

    @Override
    public RMConstraintInfo addRMConstraint(String listName, String title, String[] values) {
        return this.addRMConstraint(listName, title, values, RMListOfValuesConstraint.MatchLogic.AND);
    }

    public RMConstraintInfo addRMConstraint(String listName, String title, String[] values, RMListOfValuesConstraint.MatchLogic matchLogic) {
        QName listQName;
        block4: {
            if (listName == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("rmc");
                sb.append(':');
                sb.append(UUID.randomUUID().toString());
                listName = sb.toString();
            }
            ArrayList<String> allowedValues = new ArrayList<String>();
            for (String value : values) {
                allowedValues.add(value);
            }
            listQName = QName.createQName((String)listName, (NamespacePrefixResolver)this.namespaceService);
            try {
                this.recordsManagementAdminService.addCustomConstraintDefinition(listQName, title, true, allowedValues, matchLogic);
            }
            catch (AlfrescoRuntimeException e) {
                if (!e.getMessage().contains("Constraint already exists")) break block4;
                this.recordsManagementAdminService.changeCustomConstraintValues(listQName, allowedValues);
                this.recordsManagementAdminService.changeCustomConstraintTitle(listQName, title);
            }
        }
        this.rmCaveatConfigComponent.addRMConstraint(listName);
        RMConstraintInfo info = new RMConstraintInfo();
        info.setName(listQName.toPrefixString());
        info.setTitle(title);
        info.setAllowedValues(values);
        info.setCaseSensitive(true);
        return info;
    }

    @Override
    public void deleteRMConstraint(String listName) {
        this.rmCaveatConfigComponent.deleteRMConstraint(listName);
        QName listQName = QName.createQName((String)listName, (NamespacePrefixResolver)this.namespaceService);
        this.recordsManagementAdminService.removeCustomConstraintDefinition(listQName);
    }

    @Override
    public void addRMConstraintListValue(String listName, String authorityName, String value) {
        this.rmCaveatConfigComponent.addRMConstraintListValue(listName, authorityName, value);
    }

    @Override
    public Map<String, List<String>> getListDetails(String listName) {
        return this.rmCaveatConfigComponent.getListDetails(listName);
    }

    @Override
    public void updateRMConstraintListAuthority(String listName, String authorityName, List<String> values) {
        this.rmCaveatConfigComponent.updateRMConstraintListAuthority(listName, authorityName, values);
    }

    @Override
    public void updateRMConstraintListValue(String listName, String valueName, List<String> authorities) {
        this.rmCaveatConfigComponent.updateRMConstraintListValue(listName, valueName, authorities);
    }

    @Override
    public void removeRMConstraintListAuthority(String listName, String authorityName) {
        this.rmCaveatConfigComponent.removeRMConstraintListAuthority(listName, authorityName);
    }

    @Override
    public Set<RMConstraintInfo> getAllRMConstraints() {
        HashSet<RMConstraintInfo> info = new HashSet<RMConstraintInfo>();
        ArrayList<ConstraintDefinition> defs = new ArrayList<ConstraintDefinition>(10);
        for (QName caveatModelQName : this.rmCaveatConfigComponent.getRMCaveatModels()) {
            defs.addAll(this.recordsManagementAdminService.getCustomConstraintDefinitions(caveatModelQName));
        }
        for (ConstraintDefinition dictionaryDef : defs) {
            Constraint con = dictionaryDef.getConstraint();
            if (!(con instanceof RMListOfValuesConstraint)) continue;
            final RMListOfValuesConstraint def = (RMListOfValuesConstraint)con;
            RMConstraintInfo i = new RMConstraintInfo();
            i.setName(def.getShortName());
            i.setTitle(def.getTitle());
            List allowedValues = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<String>>(){

                public List<String> doWork() {
                    return def.getAllowedValues();
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            i.setAllowedValues(allowedValues.toArray(new String[allowedValues.size()]));
            i.setCaseSensitive(def.isCaseSensitive());
            info.add(i);
        }
        return info;
    }

    public RMConstraintInfo getRMConstraint(QName listQName) {
        Constraint con;
        ConstraintDefinition dictionaryDef = this.dictionaryService.getConstraint(listQName);
        if (dictionaryDef != null && (con = dictionaryDef.getConstraint()) instanceof RMListOfValuesConstraint) {
            final RMListOfValuesConstraint def = (RMListOfValuesConstraint)con;
            RMConstraintInfo info = new RMConstraintInfo();
            info.setName(listQName.toPrefixString());
            info.setTitle(con.getTitle());
            List allowedValues = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<String>>(){

                public List<String> doWork() {
                    return def.getAllowedValues();
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            info.setAllowedValues(allowedValues.toArray(new String[allowedValues.size()]));
            info.setCaseSensitive(def.isCaseSensitive());
            return info;
        }
        return null;
    }

    @Override
    public RMConstraintInfo getRMConstraint(String listName) {
        QName listQName = QName.createQName((String)listName, (NamespacePrefixResolver)this.namespaceService);
        return this.getRMConstraint(listQName);
    }

    @Override
    public RMConstraintInfo updateRMConstraintAllowedValues(String listName, String[] allowedValues) {
        QName listQName = QName.createQName((String)listName, (NamespacePrefixResolver)this.namespaceService);
        if (allowedValues != null) {
            ArrayList<String> allowedValueList = new ArrayList<String>();
            for (String value : allowedValues) {
                allowedValueList.add(value);
            }
            ConstraintDefinition dictionaryDef = this.dictionaryService.getConstraint(listQName);
            Constraint con = dictionaryDef.getConstraint();
            if (con instanceof RMListOfValuesConstraint) {
                final RMListOfValuesConstraint def = (RMListOfValuesConstraint)con;
                List oldAllowedValues = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<String>>(){

                    public List<String> doWork() {
                        return def.getAllowedValues();
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                for (String newValue : allowedValueList) {
                    if (oldAllowedValues.contains(newValue) || !logger.isDebugEnabled()) continue;
                    logger.debug((Object)("value added to list:" + listQName + ":" + newValue));
                }
                for (String oldValue : oldAllowedValues) {
                    if (allowedValueList.contains(oldValue)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("value removed from list:" + listQName + ":" + oldValue));
                    }
                    this.removeRMConstraintListValue(listName, oldValue);
                }
            }
            this.recordsManagementAdminService.changeCustomConstraintValues(listQName, allowedValueList);
        }
        return this.getRMConstraint(listName);
    }

    @Override
    public void removeRMConstraintListValue(String listName, String valueName) {
        this.rmCaveatConfigComponent.removeRMConstraintListValue(listName, valueName);
    }

    @Override
    public RMConstraintInfo updateRMConstraintTitle(String listName, String newTitle) {
        QName listQName = QName.createQName((String)listName, (NamespacePrefixResolver)this.namespaceService);
        this.recordsManagementAdminService.changeCustomConstraintTitle(listQName, newTitle);
        return this.getRMConstraint(listName);
    }
}

