/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.caveat;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.acegisecurity.AccessDeniedException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.caveat.PivotUtil;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMCaveatConfigComponent;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMConstraintInfo;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMListOfValuesConstraint;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.JSONtoFmModel;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

@BehaviourBean(defaultType="rma:caveatConfig")
public class RMCaveatConfigComponentImpl
implements ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnCreateNodePolicy,
RMCaveatConfigComponent {
    private static Log logger = LogFactory.getLog(RMCaveatConfigComponentImpl.class);
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private AuthorityService authorityService;
    private PersonService personService;
    private NodeService nodeService;
    private StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
    private List<String> caveatAspectURINames = new ArrayList<String>(0);
    private List<QName> caveatAspectQNames = new ArrayList<QName>(0);
    private List<String> caveatModelURINames = new ArrayList<String>(0);
    private List<QName> caveatModelQNames = new ArrayList<QName>(0);
    private static final String CAVEAT_CONFIG_NAME = "caveatConfig.json";
    private static final QName DATATYPE_TEXT = DataTypeDefinition.TEXT;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private SimpleCache<String, Map<String, List<String>>> caveatConfig;

    public void setCaveatConfig(SimpleCache<String, Map<String, List<String>>> caveatConfig) {
        this.caveatConfig = caveatConfig;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setStoreRef(String storeRef) {
        this.storeRef = new StoreRef(storeRef);
    }

    public void setCaveatAspects(List<String> caveatAspectNames) {
        this.caveatAspectURINames = caveatAspectNames;
    }

    public void setCaveatModels(List<String> caveatModelNames) {
        this.caveatModelURINames = caveatModelNames;
    }

    @Override
    public void init() {
        NodeRef caveatConfigNodeRef;
        if (this.caveatAspectURINames.size() > 0) {
            for (String caveatAspectURIName : this.caveatAspectURINames) {
                this.caveatAspectQNames.add(QName.createQName((String)caveatAspectURIName));
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Caveat aspects configured " + this.caveatAspectQNames));
            }
        } else {
            logger.warn((Object)"No caveat aspects configured - caveats will not be applied");
        }
        if (this.caveatModelURINames.size() > 0) {
            for (String caveatModelURIName : this.caveatModelURINames) {
                this.caveatModelQNames.add(QName.createQName((String)caveatModelURIName));
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Caveat models configured " + this.caveatModelQNames));
            }
        } else {
            logger.info((Object)"No caveat models configured - all models will be checked");
        }
        if ((caveatConfigNodeRef = this.getCaveatConfigNode()) != null) {
            this.validateAndReset(caveatConfigNodeRef);
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("onContentUpdate: " + nodeRef + ", " + newContent));
        }
        this.validateAndReset(nodeRef);
    }

    @Behaviour(kind=BehaviourKind.CLASS)
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("beforeDeleteNode: " + nodeRef));
        }
        this.validateAndReset(nodeRef);
    }

    @Behaviour(kind=BehaviourKind.CLASS)
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("onCreateNode: " + childAssocRef));
        }
        this.validateAndReset(childAssocRef.getChildRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAndReset(NodeRef nodeRef) {
        String caveatConfigData;
        ContentReader cr = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (cr != null && (caveatConfigData = cr.getContentString()) != null) {
            NodeRef existing = this.getCaveatConfigNode();
            if (existing != null && !existing.equals((Object)nodeRef)) {
                throw new AlfrescoRuntimeException("Cannot create more than one caveat config (existing=" + existing + ", new=" + nodeRef + ")");
            }
            try {
                String conStr;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)caveatConfigData);
                }
                HashSet<QName> models = new HashSet<QName>(1);
                HashSet props = new HashSet(10);
                HashSet expectedPrefixes = new HashSet(10);
                if (this.caveatModelQNames.size() > 0) {
                    models.addAll(this.caveatModelQNames);
                } else {
                    models.addAll(this.dictionaryService.getAllModels());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("validateAndReset: models to check " + models));
                }
                for (QName model : models) {
                    props.addAll(this.dictionaryService.getProperties(model, DATATYPE_TEXT));
                    expectedPrefixes.addAll(this.namespaceService.getPrefixes(model.getNamespaceURI()));
                }
                if (props.size() == 0) {
                    logger.warn((Object)"validateAndReset: no caveat properties found");
                } else if (logger.isTraceEnabled()) {
                    logger.trace((Object)("validateAndReset: properties to check " + props));
                }
                Map caveatConfigMap = JSONtoFmModel.convertJSONObjectToMap((String)caveatConfigData);
                for (Map.Entry conEntry : caveatConfigMap.entrySet()) {
                    conStr = (String)conEntry.getKey();
                    QName conQName = QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)conStr);
                    String conPrefix = QName.splitPrefixedQName((String)conStr)[0];
                    boolean prefixFound = false;
                    for (String expectedPrefix : expectedPrefixes) {
                        if (!conPrefix.equals(expectedPrefix)) continue;
                        prefixFound = true;
                    }
                    if (!prefixFound) {
                        throw new AlfrescoRuntimeException("Unexpected prefix: " + conPrefix + " (" + conStr + ") expected one of " + expectedPrefixes + ")");
                    }
                    Map caveatMap = (Map)conEntry.getValue();
                    List allowedValues = null;
                    boolean found = false;
                    block8: for (QName qName : props) {
                        PropertyDefinition propDef = this.dictionaryService.getProperty(qName);
                        List conDefs = propDef.getConstraints();
                        for (ConstraintDefinition conDef : conDefs) {
                            String conName;
                            final Constraint con = conDef.getConstraint();
                            if (!(con instanceof RMListOfValuesConstraint) || !(conName = ((RMListOfValuesConstraint)con).getShortName()).equals(conStr)) continue;
                            allowedValues = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<String>>(){

                                public List<String> doWork() {
                                    return ((RMListOfValuesConstraint)con).getAllowedValues();
                                }
                            }, (String)AuthenticationUtil.getSystemUserName());
                            found = true;
                            continue block8;
                        }
                    }
                    if (allowedValues == null) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Processing constraint: " + conQName));
                    }
                    for (Map.Entry entry : caveatMap.entrySet()) {
                        String authorityName = (String)entry.getKey();
                        List caveatList = (List)entry.getValue();
                        if (!this.authorityService.authorityExists(authorityName) && !this.personService.personExists(authorityName)) {
                            String msg = "User/group does not exist: " + authorityName + " (constraint=" + conStr + ")";
                            logger.warn((Object)msg);
                        }
                        for (String value : caveatList) {
                            if (allowedValues.contains(value)) continue;
                            String msg = "Invalid value in list: " + value + " (authority=" + authorityName + ", constraint=" + conStr + ")";
                            logger.warn((Object)msg);
                        }
                    }
                }
                try {
                    this.writeLock.lock();
                    this.caveatConfig.getKeys().retainAll(caveatConfigMap.keySet());
                    for (Map.Entry conEntry : caveatConfigMap.entrySet()) {
                        conStr = (String)conEntry.getKey();
                        Map caveatMap = (Map)conEntry.getValue();
                        Map cacheValue = (Map)this.caveatConfig.get((Serializable)((Object)conStr));
                        if (cacheValue != null && cacheValue.equals(caveatMap)) continue;
                        this.caveatConfig.put((Serializable)((Object)conStr), (Object)caveatMap);
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            catch (JSONException e) {
                throw new AlfrescoRuntimeException("Invalid caveat config syntax: " + e);
            }
        }
    }

    private NodeRef getCaveatConfigNode() {
        NodeRef rootNode = this.nodeService.getRootNode(this.storeRef);
        return this.nodeService.getChildByName(rootNode, RecordsManagementModel.ASSOC_CAVEAT_CONFIG, CAVEAT_CONFIG_NAME);
    }

    @Override
    public NodeRef updateOrCreateCaveatConfig(InputStream is) {
        NodeRef caveatConfig = this.getOrCreateCaveatConfig();
        ContentWriter writer = this.contentService.getWriter(caveatConfig, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(is);
        return caveatConfig;
    }

    @Override
    public NodeRef updateOrCreateCaveatConfig(File jsonFile) {
        NodeRef caveatConfig = this.getOrCreateCaveatConfig();
        ContentWriter writer = this.contentService.getWriter(caveatConfig, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(jsonFile);
        return caveatConfig;
    }

    @Override
    public NodeRef updateOrCreateCaveatConfig(String jsonString) {
        NodeRef caveatConfig = this.getOrCreateCaveatConfig();
        ContentWriter writer = this.contentService.getWriter(caveatConfig, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(jsonString);
        return caveatConfig;
    }

    private NodeRef getOrCreateCaveatConfig() {
        NodeRef caveatConfig = this.getCaveatConfigNode();
        if (caveatConfig == null) {
            NodeRef rootNode = this.nodeService.getRootNode(this.storeRef);
            this.nodeService.addAspect(rootNode, VersionModel.ASPECT_VERSION_STORE_ROOT, null);
            caveatConfig = this.nodeService.createNode(rootNode, RecordsManagementModel.ASSOC_CAVEAT_CONFIG, QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)CAVEAT_CONFIG_NAME), RecordsManagementModel.TYPE_CAVEAT_CONFIG).getChildRef();
            this.nodeService.setProperty(caveatConfig, ContentModel.PROP_NAME, (Serializable)((Object)CAVEAT_CONFIG_NAME));
        }
        return caveatConfig;
    }

    public Collection<String> getRMConstraintNames() {
        Collection<Object> rmConstraintNames = Collections.emptySet();
        try {
            this.readLock.lock();
            rmConstraintNames = this.caveatConfig.getKeys();
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.unmodifiableCollection(rmConstraintNames);
    }

    @Override
    public List<String> getRMAllowedValues(String constraintName) {
        List<String> allowedValues = new ArrayList<String>(0);
        String userName = AuthenticationUtil.getRunAsUser();
        if (!(userName == null || AuthenticationUtil.isMtEnabled() && AuthenticationUtil.isRunAsUserTheSystemUser())) {
            this.caveatConfig.get((Serializable)((Object)constraintName));
            Set userGroupFullNames = this.authorityService.getAuthoritiesForUser(userName);
            allowedValues = this.getRMAllowedValues(userName, userGroupFullNames, constraintName);
        }
        return allowedValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRMAllowedValues(String userName, Set<String> userGroupFullNames, String constraintName) {
        HashSet allowedValues = new HashSet();
        Map caveatConstraintDef = null;
        try {
            this.readLock.lock();
            caveatConstraintDef = (Map)this.caveatConfig.get((Serializable)((Object)constraintName));
        }
        finally {
            this.readLock.unlock();
        }
        if (caveatConstraintDef != null) {
            List direct = (List)caveatConstraintDef.get(userName);
            if (direct != null) {
                allowedValues.addAll(direct);
            }
            for (String group : userGroupFullNames) {
                List values = (List)caveatConstraintDef.get(group);
                if (values == null) continue;
                allowedValues.addAll(values);
            }
        }
        ArrayList ret = new ArrayList();
        ret.addAll(allowedValues);
        return Collections.unmodifiableList(ret);
    }

    @Override
    public boolean hasAccess(NodeRef nodeRef) {
        try {
            if (!this.nodeService.exists(nodeRef) || this.caveatAspectQNames.size() == 0) {
                return true;
            }
            boolean found = false;
            for (QName caveatAspectQName : this.caveatAspectQNames) {
                if (!this.nodeService.hasAspect(nodeRef, caveatAspectQName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return true;
            }
            String userName = AuthenticationUtil.getRunAsUser();
            if (userName != null) {
                Map props = this.nodeService.getProperties(nodeRef);
                for (Map.Entry entry : props.entrySet()) {
                    QName propName = (QName)entry.getKey();
                    PropertyDefinition propDef = this.dictionaryService.getProperty(propName);
                    if (propDef == null || !propDef.getDataType().getName().equals((Object)DATATYPE_TEXT)) continue;
                    List conDefs = propDef.getConstraints();
                    for (ConstraintDefinition conDef : conDefs) {
                        Constraint con = conDef.getConstraint();
                        if (!(con instanceof RMListOfValuesConstraint)) continue;
                        RMListOfValuesConstraint rmCon = (RMListOfValuesConstraint)con;
                        String conName = rmCon.getShortName();
                        RMListOfValuesConstraint.MatchLogic matchLogic = rmCon.getMatchLogicEnum();
                        Map caveatConstraintDef = (Map)this.caveatConfig.get((Serializable)((Object)conName));
                        if (caveatConstraintDef == null) continue;
                        Set userGroupNames = this.authorityService.getAuthoritiesForUser(userName);
                        List<String> allowedValues = this.getRMAllowedValues(userName, userGroupNames, conName);
                        ArrayList<String> propValues = null;
                        Object val = entry.getValue();
                        if (val instanceof String) {
                            propValues = new ArrayList<String>(1);
                            propValues.add((String)val);
                        } else if (val instanceof List) {
                            propValues = (List)val;
                        }
                        if (propValues == null || this.isAllowed(propValues, allowedValues, matchLogic)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Veto access: caveat=" + conName + ", userName=" + userName + ", nodeRef=" + nodeRef + ", propName=" + propName + ", propValues=" + propValues + ", allowedValues=" + allowedValues));
                        }
                        return false;
                    }
                }
            }
            return true;
        }
        catch (AccessDeniedException ade) {
            return false;
        }
    }

    private boolean isAllowed(List<String> propValues, List<String> userGroupValues, RMListOfValuesConstraint.MatchLogic matchLogic) {
        if (matchLogic.equals((Object)RMListOfValuesConstraint.MatchLogic.AND)) {
            for (String propValue : propValues) {
                if (userGroupValues.contains(propValue)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Not allowed: " + propValues + ", " + userGroupValues + ", " + matchLogic));
                }
                return false;
            }
            return true;
        }
        if (matchLogic.equals((Object)RMListOfValuesConstraint.MatchLogic.OR)) {
            for (String propValue : propValues) {
                if (!userGroupValues.contains(propValue)) continue;
                return true;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Not allowed: " + propValues + ", " + userGroupValues + ", " + matchLogic));
            }
            return false;
        }
        logger.error((Object)("Unexpected match logic type: " + matchLogic));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRMConstraintListValue(String listName, String authorityName, String value) {
        Map members = null;
        try {
            this.readLock.lock();
            members = (Map)this.caveatConfig.get((Serializable)((Object)listName));
            if (members == null) {
                throw new AlfrescoRuntimeException("unable to add to list, list not defined:" + listName);
            }
            try {
                this.readLock.unlock();
                this.writeLock.lock();
                members = (Map)this.caveatConfig.get((Serializable)((Object)listName));
                if (members == null) {
                    throw new AlfrescoRuntimeException("unable to add to list, list not defined:" + listName);
                }
                List values = (List)members.get(authorityName);
                if (values == null) {
                    throw new AlfrescoRuntimeException("Unable to add to authority in list.   Authority not member listName: " + listName + " authorityName:" + authorityName);
                }
                values.add(value);
                this.caveatConfig.put((Serializable)((Object)listName), (Object)members);
                this.updateOrCreateCaveatConfig(this.convertToJSONString(this.caveatConfig));
            }
            finally {
                this.readLock.lock();
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<String, List<String>> getListDetails(String listName) {
        Map listDetails = null;
        try {
            this.readLock.lock();
            listDetails = (Map)this.caveatConfig.get((Serializable)((Object)listName));
        }
        finally {
            this.readLock.unlock();
        }
        if (listDetails == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(listDetails);
    }

    @Override
    public List<QName> getRMCaveatModels() {
        return this.caveatModelQNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRMConstraintListAuthority(String listName, String authorityName, List<String> values) {
        HashMap<String, ArrayList<String>> members = null;
        try {
            this.writeLock.lock();
            members = (HashMap<String, ArrayList<String>>)this.caveatConfig.get((Serializable)((Object)listName));
            if (members == null) {
                HashMap<String, ArrayList<String>> constraint = new HashMap<String, ArrayList<String>>(0);
                constraint.put(authorityName, new ArrayList<String>(values));
                members = constraint;
            } else {
                members.put(authorityName, new ArrayList<String>(values));
            }
            this.caveatConfig.put((Serializable)((Object)listName), (Object)members);
            this.updateOrCreateCaveatConfig(this.convertToJSONString(this.caveatConfig));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRMConstraintListValue(String listName, String valueName, List<String> authorities) {
        HashMap<String, ArrayList<String>> members = (HashMap<String, ArrayList<String>>)this.caveatConfig.get((Serializable)((Object)listName));
        try {
            List<String> vals;
            Map<String, List<String>> pivot;
            List<String> existingAuthorities;
            this.writeLock.lock();
            if (members == null) {
                HashMap<String, ArrayList<String>> emptyConstraint = new HashMap<String, ArrayList<String>>(0);
                this.caveatConfig.put((Serializable)((Object)listName), emptyConstraint);
                members = emptyConstraint;
            }
            if ((existingAuthorities = (pivot = PivotUtil.getPivot((Map<String, List<String>>)members)).get(valueName)) != null) {
                for (String authority : existingAuthorities) {
                    vals = (ArrayList<String>)members.get(authority);
                    vals.remove(valueName);
                }
            }
            for (String authority : authorities) {
                vals = (List)members.get(authority);
                if (vals == null) {
                    vals = new ArrayList<String>();
                    members.put(authority, (ArrayList<String>)vals);
                }
                vals.add(valueName);
            }
            this.caveatConfig.put((Serializable)((Object)listName), members);
            this.updateOrCreateCaveatConfig(this.convertToJSONString(this.caveatConfig));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRMConstraintListValue(String listName, String valueName) {
        block8: {
            Map members = null;
            try {
                this.readLock.lock();
                members = (Map)this.caveatConfig.get((Serializable)((Object)listName));
                if (members == null) break block8;
                try {
                    Map<String, List<String>> pivot;
                    List<String> existingAuthorities;
                    this.readLock.unlock();
                    this.writeLock.lock();
                    members = (Map)this.caveatConfig.get((Serializable)((Object)listName));
                    if (members != null && (existingAuthorities = (pivot = PivotUtil.getPivot(members)).get(valueName)) != null) {
                        for (String authority : existingAuthorities) {
                            List vals = (List)members.get(authority);
                            vals.remove(valueName);
                        }
                        this.caveatConfig.put((Serializable)((Object)listName), (Object)members);
                    }
                    this.updateOrCreateCaveatConfig(this.convertToJSONString(this.caveatConfig));
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRMConstraintListAuthority(String listName, String authorityName) {
        Map members = null;
        try {
            this.writeLock.lock();
            members = (Map)this.caveatConfig.get((Serializable)((Object)listName));
            if (members != null) {
                members.remove(listName);
            }
            this.caveatConfig.put((Serializable)((Object)listName), (Object)members);
            this.updateOrCreateCaveatConfig(this.convertToJSONString(this.caveatConfig));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String convertToJSONString(SimpleCache<String, Map<String, List<String>>> config) {
        JSONObject configJSONObject = new JSONObject();
        Collection listNames = config.getKeys();
        for (String listName : listNames) {
            Map members = (Map)config.get((Serializable)((Object)listName));
            JSONObject listMembers = new JSONObject();
            for (Map.Entry member : members.entrySet()) {
                String authorityName = (String)member.getKey();
                List authorities = (List)member.getValue();
                try {
                    listMembers.put(authorityName, (Collection)authorities);
                }
                catch (JSONException error) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Cannot add the key '");
                    sb.append(authorityName);
                    sb.append("' with the value '");
                    sb.append(authorities);
                    sb.append("' to the JSONObject 'listMembers' '");
                    sb.append(listMembers);
                    sb.append("': ");
                    sb.append(ExceptionUtils.getStackTrace((Throwable)error));
                    throw new AlfrescoRuntimeException(sb.toString());
                }
            }
            try {
                configJSONObject.put(listName, (Object)listMembers);
            }
            catch (JSONException error) {
                StringBuilder sb = new StringBuilder();
                sb.append("Cannot add the key '");
                sb.append(listName);
                sb.append("' with the value '");
                sb.append(listMembers);
                sb.append("' to the JSONObject 'configJSONObject' '");
                sb.append(configJSONObject);
                sb.append("': ");
                sb.append(ExceptionUtils.getStackTrace((Throwable)error));
                throw new AlfrescoRuntimeException(sb.toString());
            }
        }
        return configJSONObject.toString();
    }

    public RMConstraintInfo getRMConstraint(QName listQName) {
        Constraint con;
        ConstraintDefinition dictionaryDef = this.dictionaryService.getConstraint(listQName);
        if (dictionaryDef != null && (con = dictionaryDef.getConstraint()) instanceof RMListOfValuesConstraint) {
            final RMListOfValuesConstraint def = (RMListOfValuesConstraint)con;
            RMConstraintInfo info = new RMConstraintInfo();
            info.setName(listQName.toPrefixString());
            info.setTitle(con.getTitle());
            List allowedValues = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<String>>(){

                public List<String> doWork() {
                    return def.getAllowedValues();
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            info.setAllowedValues(allowedValues.toArray(new String[allowedValues.size()]));
            info.setCaseSensitive(def.isCaseSensitive());
            return info;
        }
        return null;
    }

    @Override
    public RMConstraintInfo getRMConstraint(String listName) {
        QName listQName = QName.createQName((String)listName, (NamespacePrefixResolver)this.namespaceService);
        return this.getRMConstraint(listQName);
    }

    @Override
    public void deleteRMConstraint(String listName) {
        try {
            this.writeLock.lock();
            this.caveatConfig.remove((Serializable)((Object)listName));
            this.updateOrCreateCaveatConfig(this.convertToJSONString(this.caveatConfig));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addRMConstraint(String listName) {
        try {
            this.writeLock.lock();
            HashMap emptyConstraint = new HashMap(0);
            this.caveatConfig.put((Serializable)((Object)listName), emptyConstraint);
            this.updateOrCreateCaveatConfig(this.convertToJSONString(this.caveatConfig));
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

