/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability;

import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMCaveatConfigComponent;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.util.Pair;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RMSecurityCommon
implements ApplicationContextAware {
    protected static final int NOSET_VALUE = -100;
    private static Log logger = LogFactory.getLog(RMSecurityCommon.class);
    protected NodeService nodeService;
    protected PermissionService permissionService;
    protected RMCaveatConfigComponent caveatConfigComponent;
    private FilePlanService filePlanService;
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setCaveatConfigComponent(RMCaveatConfigComponent caveatConfigComponent) {
        this.caveatConfigComponent = caveatConfigComponent;
    }

    protected FilePlanService getFilePlanService() {
        if (this.filePlanService == null) {
            this.filePlanService = (FilePlanService)this.applicationContext.getBean("filePlanService");
        }
        return this.filePlanService;
    }

    protected int setTransactionCache(String prefix, NodeRef nodeRef, int value) {
        String user = AuthenticationUtil.getRunAsUser();
        AlfrescoTransactionSupport.bindResource((Object)(prefix + nodeRef.toString() + user), (Object)value);
        return value;
    }

    protected int getTransactionCache(String prefix, NodeRef nodeRef) {
        int result = -100;
        StringBuffer key = new StringBuffer(prefix).append(nodeRef).append(AuthenticationUtil.getRunAsUser());
        Integer value = (Integer)AlfrescoTransactionSupport.getResource((Object)key);
        if (value != null) {
            result = value;
        }
        return result;
    }

    public int checkRead(NodeRef nodeRef) {
        int result = 0;
        if (nodeRef != null) {
            result = this.checkRead(nodeRef, false);
        }
        return result;
    }

    public int checkRead(NodeRef nodeRef, boolean allowDMRead) {
        int result = 0;
        if (this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)) {
            result = this.checkRmRead(nodeRef);
        } else if (allowDMRead) {
            if (this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.DENIED) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\t\tPermission is denied");
                    Thread.dumpStack();
                }
                result = -1;
            } else {
                result = 1;
            }
        }
        return result;
    }

    public int checkRmRead(NodeRef nodeRef) {
        Pair key;
        int result = 0;
        Map transactionCache = TransactionalResourceHelper.getMap((Object)"rm.security.checkRMRead");
        if (transactionCache.containsKey(key = new Pair((Object)AuthenticationUtil.getRunAsUser(), (Object)nodeRef))) {
            result = (Integer)transactionCache.get(key);
        } else {
            if (this.permissionService.hasPermission(nodeRef, "ReadRecords") == AccessStatus.DENIED) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\t\tUser does not have read record permission on node, access denied.  (nodeRef=" + nodeRef.toString() + ", user=" + AuthenticationUtil.getRunAsUser() + ")"));
                }
                result = -1;
            } else {
                NodeRef filePlan = this.getFilePlanService().getFilePlan(nodeRef);
                if (filePlan != null && this.hasViewCapability(filePlan) == AccessStatus.DENIED) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\t\tUser does not have view records capability permission on node, access denied. (filePlan=" + filePlan.toString() + ", user=" + AuthenticationUtil.getRunAsUser() + ")"));
                    }
                    result = -1;
                } else {
                    result = !this.caveatConfigComponent.hasAccess(nodeRef) ? -1 : 1;
                }
            }
            transactionCache.put(key, result);
        }
        return result;
    }

    private AccessStatus hasViewCapability(NodeRef filePlan) {
        Pair key;
        Map transactionCache = TransactionalResourceHelper.getMap((Object)"rm.security.hasViewCapability");
        if (transactionCache.containsKey(key = new Pair((Object)AuthenticationUtil.getRunAsUser(), (Object)filePlan))) {
            return (AccessStatus)transactionCache.get(key);
        }
        AccessStatus result = this.permissionService.hasPermission(filePlan, "ViewRecords");
        transactionCache.put(key, result);
        return result;
    }

    protected NodeRef getTestNode(MethodInvocation invocation, Class[] params, int position, boolean parent) {
        NodeRef testNodeRef = null;
        if (position < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\tNothing to test permission against.");
            }
            testNodeRef = null;
        } else if (StoreRef.class.isAssignableFrom(params[position])) {
            if (invocation.getArguments()[position] != null) {
                StoreRef storeRef;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\tPermission test against the store - using permissions on the root node");
                }
                if (this.nodeService.exists(storeRef = (StoreRef)invocation.getArguments()[position])) {
                    testNodeRef = this.nodeService.getRootNode(storeRef);
                }
            }
        } else if (NodeRef.class.isAssignableFrom(params[position])) {
            testNodeRef = (NodeRef)invocation.getArguments()[position];
            if (parent) {
                testNodeRef = this.nodeService.getPrimaryParent(testNodeRef).getParentRef();
                if (logger.isDebugEnabled()) {
                    if (this.nodeService.exists(testNodeRef)) {
                        logger.debug((Object)("\tPermission test for parent on node " + this.nodeService.getPath(testNodeRef)));
                    } else {
                        logger.debug((Object)("\tPermission test for parent on non-existing node " + testNodeRef));
                    }
                    logger.debug((Object)("\tPermission test for parent on node " + this.nodeService.getPath(testNodeRef)));
                }
            } else if (logger.isDebugEnabled()) {
                if (this.nodeService.exists(testNodeRef)) {
                    logger.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                } else {
                    logger.debug((Object)("\tPermission test on non-existing node " + testNodeRef));
                }
            }
        } else if (ChildAssociationRef.class.isAssignableFrom(params[position])) {
            if (invocation.getArguments()[position] != null) {
                testNodeRef = parent ? ((ChildAssociationRef)invocation.getArguments()[position]).getParentRef() : ((ChildAssociationRef)invocation.getArguments()[position]).getChildRef();
                if (logger.isDebugEnabled()) {
                    if (this.nodeService.exists(testNodeRef)) {
                        logger.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                    } else {
                        logger.debug((Object)("\tPermission test on non-existing node " + testNodeRef));
                    }
                }
            }
        } else if (AssociationRef.class.isAssignableFrom(params[position]) && invocation.getArguments()[position] != null) {
            testNodeRef = parent ? ((AssociationRef)invocation.getArguments()[position]).getSourceRef() : ((AssociationRef)invocation.getArguments()[position]).getTargetRef();
            if (logger.isDebugEnabled()) {
                if (this.nodeService.exists(testNodeRef)) {
                    logger.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                } else {
                    logger.debug((Object)("\tPermission test on non-existing node " + testNodeRef));
                }
            }
        }
        return testNodeRef;
    }
}

