/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.capability.RMSecurityCommon;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.security.permissions.PermissionCheckCollection;
import org.alfresco.repo.security.permissions.PermissionCheckValue;
import org.alfresco.repo.security.permissions.PermissionCheckedCollection;
import org.alfresco.repo.security.permissions.PermissionCheckedValue;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class RMAfterInvocationProvider
extends RMSecurityCommon
implements AfterInvocationProvider,
InitializingBean {
    private static Log logger = LogFactory.getLog(RMAfterInvocationProvider.class);
    private static final String AFTER_RM = "AFTER_RM";
    private AuthenticationUtil authenticationUtil;
    private int maxPermissionChecks = Integer.MAX_VALUE;
    private long maxPermissionCheckTimeMillis = Long.MAX_VALUE;

    public boolean supports(ConfigAttribute configAttribute) {
        String attribute = configAttribute.getAttribute();
        return StringUtils.isNotBlank((CharSequence)attribute) && attribute.startsWith(AFTER_RM);
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    public void afterPropertiesSet() {
    }

    public void setMaxPermissionChecks(int maxPermissionChecks) {
        this.maxPermissionChecks = maxPermissionChecks;
    }

    public void setMaxPermissionCheckTimeMillis(long maxPermissionCheckTimeMillis) {
        this.maxPermissionCheckTimeMillis = maxPermissionCheckTimeMillis;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) {
        if (logger.isDebugEnabled()) {
            MethodInvocation mi = (MethodInvocation)object;
            if (mi == null) {
                logger.debug((Object)"Method is null.");
            } else {
                logger.debug((Object)("Method: " + mi.getMethod().toString()));
            }
        }
        try {
            if (this.authenticationUtil.isRunAsUserTheSystemUser()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Allowing system user access");
                }
                return returnedObject;
            }
            if (returnedObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Allowing null object access");
                }
                return null;
            }
            if (PermissionCheckedValue.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (PermissionCheckedValue)returnedObject);
            }
            if (PermissionCheckValue.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (PermissionCheckValue)returnedObject);
            }
            if (StoreRef.class.isAssignableFrom(returnedObject.getClass())) {
                NodeRef rootNodeRef = this.decide(authentication, object, config, this.nodeService.getRootNode((StoreRef)returnedObject));
                if (rootNodeRef == null) {
                    throw new AlfrescoRuntimeException("Root node reference of '" + returnedObject + "' is null.");
                }
                return rootNodeRef.getStoreRef();
            }
            if (NodeRef.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (NodeRef)returnedObject);
            }
            if (ChildAssociationRef.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (ChildAssociationRef)returnedObject);
            }
            if (AssociationRef.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (AssociationRef)returnedObject);
            }
            if (PagingLuceneResultSet.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (PagingLuceneResultSet)returnedObject);
            }
            if (ResultSet.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (ResultSet)returnedObject);
            }
            if (QueryEngineResults.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (QueryEngineResults)returnedObject);
            }
            if (Collection.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (Collection)returnedObject);
            }
            if (returnedObject.getClass().isArray()) {
                return this.decide(authentication, object, config, (Object[])returnedObject);
            }
            if (logger.isDebugEnabled() && object != null) {
                logger.debug((Object)("Uncontrolled object - access allowed for " + object.getClass().getName()));
            }
            return returnedObject;
        }
        catch (AccessDeniedException ade) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Access denied: " + ade.getMessage()));
            }
            throw ade;
        }
        catch (RuntimeException re) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Access denied by runtime exception: " + re.getMessage()));
            }
            throw re;
        }
    }

    private PermissionCheckedValue decide(Authentication authentication, Object object, ConfigAttributeDefinition config, PermissionCheckedValue returnedObject) {
        return returnedObject;
    }

    private PermissionCheckValue decide(Authentication authentication, Object object, ConfigAttributeDefinition config, PermissionCheckValue returnedObject) {
        NodeRef nodeRef = returnedObject.getNodeRef();
        this.decide(authentication, object, config, nodeRef);
        return returnedObject;
    }

    private NodeRef decide(Authentication authentication, Object object, ConfigAttributeDefinition config, NodeRef returnedObject) {
        if (returnedObject == null) {
            return null;
        }
        if (this.isUnfiltered(returnedObject)) {
            return returnedObject;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        int parentResult = this.checkRead(this.nodeService.getPrimaryParent(returnedObject).getParentRef());
        int childResult = this.checkRead(returnedObject);
        this.checkSupportedDefinitions(supportedDefinitions, parentResult, childResult);
        return returnedObject;
    }

    private void checkSupportedDefinitions(List<ConfigAttributeDefintion> supportedDefinitions, int parentResult, int childResult) {
        for (ConfigAttributeDefintion cad : supportedDefinitions) {
            if ((!cad.parent || parentResult != -1) && (cad.parent || childResult != -1)) continue;
            throw new AccessDeniedException("Access Denied");
        }
    }

    protected boolean isUnfiltered(NodeRef nodeRef) {
        return !this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT);
    }

    private List<ConfigAttributeDefintion> extractSupportedDefinitions(ConfigAttributeDefinition config) {
        ArrayList<ConfigAttributeDefintion> definitions = new ArrayList<ConfigAttributeDefintion>();
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            definitions.add(new ConfigAttributeDefintion(attr));
        }
        return definitions;
    }

    private ChildAssociationRef decide(Authentication authentication, Object object, ConfigAttributeDefinition config, ChildAssociationRef returnedObject) {
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        int parentReadCheck = this.checkRead(returnedObject.getParentRef());
        int childReadCheck = this.checkRead(returnedObject.getChildRef());
        for (ConfigAttributeDefintion cad : supportedDefinitions) {
            NodeRef testNodeRef = null;
            testNodeRef = cad.parent ? returnedObject.getParentRef() : returnedObject.getChildRef();
            if (this.isUnfiltered(testNodeRef) || (!cad.parent || parentReadCheck == 1) && childReadCheck == 1) continue;
            throw new AccessDeniedException("Access Denied");
        }
        return returnedObject;
    }

    private AssociationRef decide(Authentication authentication, Object object, ConfigAttributeDefinition config, AssociationRef returnedObject) {
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        for (ConfigAttributeDefintion cad : supportedDefinitions) {
            NodeRef testNodeRef = null;
            testNodeRef = cad.parent ? returnedObject.getSourceRef() : returnedObject.getTargetRef();
            if (this.isUnfiltered(testNodeRef) || this.checkRead(testNodeRef) == 1) continue;
            throw new AccessDeniedException("Access Denied");
        }
        return returnedObject;
    }

    private ResultSet decide(Authentication authentication, Object object, ConfigAttributeDefinition config, PagingLuceneResultSet returnedObject) {
        ResultSet raw = ((FilteringResultSet)returnedObject.getWrapped()).getUnFilteredResultSet();
        ResultSet filteredForPermissions = this.decide(authentication, object, config, raw);
        PagingLuceneResultSet plrs = new PagingLuceneResultSet(filteredForPermissions, returnedObject.getResultSetMetaData().getSearchParameters(), this.nodeService);
        plrs.setTrimmedResultSet(true);
        return plrs;
    }

    private ResultSet decide(Authentication authentication, Object object, ConfigAttributeDefinition config, ResultSet returnedObject) {
        if (returnedObject == null) {
            return null;
        }
        if (returnedObject.getResultSetMetaData().getSearchParameters().getLanguage().equalsIgnoreCase("index-sql")) {
            return returnedObject;
        }
        BitSet inclusionMask = new BitSet(returnedObject.length());
        class RMFilteringResultSet
        extends FilteringResultSet {
            private long numberFound;

            public RMFilteringResultSet(ResultSet unfiltered, BitSet inclusionMask) {
                super(unfiltered, inclusionMask);
            }

            public long getNumberFound() {
                return this.numberFound;
            }

            private void setNumberFound(long numberFound) {
                this.numberFound = numberFound;
            }
        }
        RMFilteringResultSet filteringResultSet = new RMFilteringResultSet(returnedObject, inclusionMask);
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        Integer maxSize = null;
        if (returnedObject.getResultSetMetaData().getSearchParameters().getMaxItems() >= 0) {
            maxSize = returnedObject.getResultSetMetaData().getSearchParameters().getMaxItems();
        }
        if (maxSize == null && returnedObject.getResultSetMetaData().getSearchParameters().getLimitBy() == LimitBy.FINAL_SIZE) {
            maxSize = returnedObject.getResultSetMetaData().getSearchParameters().getLimit();
        }
        if (maxSize != null && returnedObject.getResultSetMetaData().getSearchParameters().getSkipCount() >= 0) {
            maxSize = maxSize + returnedObject.getResultSetMetaData().getSearchParameters().getSkipCount();
        }
        if (supportedDefinitions.size() == 0) {
            if (maxSize == null) {
                return returnedObject;
            }
            if (returnedObject.length() > maxSize) {
                for (int i = 0; i < maxSize; ++i) {
                    inclusionMask.set(i, true);
                }
                filteringResultSet.setResultSetMetaData((ResultSetMetaData)new SimpleResultSetMetaData(returnedObject.getResultSetMetaData().getLimitedBy(), PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
                filteringResultSet.setNumberFound(returnedObject.getNumberFound());
                return filteringResultSet;
            }
            for (int i = 0; i < returnedObject.length(); ++i) {
                inclusionMask.set(i, true);
            }
            filteringResultSet.setResultSetMetaData((ResultSetMetaData)new SimpleResultSetMetaData(returnedObject.getResultSetMetaData().getLimitedBy(), PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            filteringResultSet.setNumberFound(returnedObject.getNumberFound());
            return filteringResultSet;
        }
        long startTimeMillis = System.currentTimeMillis();
        filteringResultSet.setResultSetMetaData((ResultSetMetaData)new SimpleResultSetMetaData(returnedObject.getResultSetMetaData().getLimitedBy(), PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
        for (int i = 0; i < returnedObject.length(); ++i) {
            long currentTimeMillis = System.currentTimeMillis();
            inclusionMask.set(i, true);
            if (!this.nodeService.exists(returnedObject.getNodeRef(i))) {
                inclusionMask.set(i, false);
            } else {
                int parentCheckRead = this.checkRead(returnedObject.getChildAssocRef(i).getParentRef());
                int childCheckRead = this.checkRead(returnedObject.getNodeRef(i));
                for (ConfigAttributeDefintion cad : supportedDefinitions) {
                    NodeRef testNodeRef = returnedObject.getNodeRef(i);
                    int checkRead = childCheckRead;
                    if (cad.parent) {
                        testNodeRef = returnedObject.getChildAssocRef(i).getParentRef();
                        checkRead = parentCheckRead;
                    }
                    if (this.isUnfiltered(testNodeRef) || !inclusionMask.get(i) || testNodeRef == null || checkRead == 1) continue;
                    inclusionMask.set(i, false);
                }
            }
            if (maxSize == null || filteringResultSet.length() <= maxSize) continue;
            inclusionMask.set(i, false);
            filteringResultSet.setResultSetMetaData((ResultSetMetaData)new SimpleResultSetMetaData(LimitBy.FINAL_SIZE, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            break;
        }
        if (maxSize != null) {
            LimitBy limitBy = returnedObject.length() > maxSize ? LimitBy.FINAL_SIZE : LimitBy.UNLIMITED;
            filteringResultSet.setResultSetMetaData((ResultSetMetaData)new SimpleResultSetMetaData(limitBy, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
        }
        filteringResultSet.setNumberFound(returnedObject.getNumberFound());
        return filteringResultSet;
    }

    private QueryEngineResults decide(Authentication authentication, Object object, ConfigAttributeDefinition config, QueryEngineResults returnedObject) {
        Map map = returnedObject.getResults();
        HashMap<Set, ResultSet> answer = new HashMap<Set, ResultSet>(map.size(), 1.0f);
        for (Map.Entry entry : map.entrySet()) {
            ResultSet raw = (ResultSet)entry.getValue();
            ResultSet permed = PagingLuceneResultSet.class.isAssignableFrom(raw.getClass()) ? this.decide(authentication, object, config, (PagingLuceneResultSet)raw) : this.decide(authentication, object, config, raw);
            answer.put((Set)entry.getKey(), permed);
        }
        return new QueryEngineResults(answer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Collection returnedObject) {
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entries are " + supportedDefinitions));
        }
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        long targetResultCount = returnedObject.size();
        int maxPermissionChecks = Integer.MAX_VALUE;
        long maxPermissionCheckTimeMillis = this.maxPermissionCheckTimeMillis;
        if (returnedObject instanceof PermissionCheckCollection) {
            PermissionCheckCollection permissionCheckCollection = (PermissionCheckCollection)returnedObject;
            targetResultCount = permissionCheckCollection.getTargetResultCount();
            if (permissionCheckCollection.getCutOffAfterCount() > 0) {
                maxPermissionChecks = permissionCheckCollection.getCutOffAfterCount();
            }
            if (permissionCheckCollection.getCutOffAfterTimeMs() > 0L) {
                maxPermissionCheckTimeMillis = permissionCheckCollection.getCutOffAfterTimeMs();
            }
        }
        boolean cutoff = false;
        long startTimeMillis = System.currentTimeMillis();
        int count = 0;
        ArrayList keepValues = new ArrayList(returnedObject.size());
        for (Object nextObject : returnedObject) {
            long currentTimeMillis = System.currentTimeMillis();
            if ((long)count >= targetResultCount) break;
            if (count >= maxPermissionChecks) {
                cutoff = true;
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("decide (collection) cut-off: " + count + " checks exceeded " + maxPermissionChecks + " checks"));
                break;
            }
            if (currentTimeMillis - startTimeMillis > maxPermissionCheckTimeMillis) {
                cutoff = true;
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("decide (collection) cut-off: " + (currentTimeMillis - startTimeMillis) + "ms exceeded " + maxPermissionCheckTimeMillis + "ms"));
                break;
            }
            boolean allowed = true;
            for (ConfigAttributeDefintion cad : supportedDefinitions) {
                if (!cad.mode.equalsIgnoreCase("FilterNode")) continue;
                NodeRef testNodeRef = null;
                if (cad.parent) {
                    if (StoreRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = null;
                    } else if (NodeRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = this.nodeService.getPrimaryParent((NodeRef)nextObject).getParentRef();
                    } else if (ChildAssociationRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = ((ChildAssociationRef)nextObject).getParentRef();
                    } else if (AssociationRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = ((AssociationRef)nextObject).getSourceRef();
                    } else {
                        if (!PermissionCheckValue.class.isAssignableFrom(nextObject.getClass())) throw new ACLEntryVoterException("The specified parameter is recognized: " + nextObject.getClass());
                        NodeRef nodeRef = ((PermissionCheckValue)nextObject).getNodeRef();
                        testNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                    }
                } else if (StoreRef.class.isAssignableFrom(nextObject.getClass())) {
                    testNodeRef = this.nodeService.getRootNode((StoreRef)nextObject);
                } else if (NodeRef.class.isAssignableFrom(nextObject.getClass())) {
                    testNodeRef = (NodeRef)nextObject;
                } else if (ChildAssociationRef.class.isAssignableFrom(nextObject.getClass())) {
                    testNodeRef = ((ChildAssociationRef)nextObject).getChildRef();
                } else if (AssociationRef.class.isAssignableFrom(nextObject.getClass())) {
                    testNodeRef = ((AssociationRef)nextObject).getTargetRef();
                } else {
                    if (!PermissionCheckValue.class.isAssignableFrom(nextObject.getClass())) throw new ACLEntryVoterException("The specified parameter is recognized: " + nextObject.getClass());
                    testNodeRef = ((PermissionCheckValue)nextObject).getNodeRef();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\t" + cad.typeString + " test on " + testNodeRef + " from " + nextObject.getClass().getName()));
                }
                if (this.isUnfiltered(testNodeRef) || !allowed || testNodeRef == null || this.checkRead(testNodeRef) == 1) continue;
                allowed = false;
                break;
            }
            ++count;
            if (!allowed) continue;
            keepValues.add(nextObject);
        }
        int sizeOriginal = returnedObject.size();
        int checksRemaining = sizeOriginal - count;
        if (keepValues.size() >= sizeOriginal) return PermissionCheckedCollection.PermissionCheckedCollectionMixin.create((Collection)returnedObject, (boolean)cutoff, (int)checksRemaining, (int)sizeOriginal);
        try {
            returnedObject.clear();
            returnedObject.addAll(keepValues);
            return PermissionCheckedCollection.PermissionCheckedCollectionMixin.create((Collection)returnedObject, (boolean)cutoff, (int)checksRemaining, (int)sizeOriginal);
        }
        catch (UnsupportedOperationException e) {
            throw new AccessDeniedException("Permission-checked list must be modifiable", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object[] returnedObject) {
        BitSet incudedSet = new BitSet(returnedObject.length);
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        int l = returnedObject.length;
        for (int i = 0; i < l; ++i) {
            Object current = returnedObject[i];
            int parentReadCheck = this.checkRead(this.getParentReadCheckNode(current));
            int childReadChek = this.checkRead(this.getChildReadCheckNode(current));
            for (ConfigAttributeDefintion cad : supportedDefinitions) {
                incudedSet.set(i, true);
                NodeRef testNodeRef = null;
                if (cad.parent) {
                    if (StoreRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = null;
                    } else if (NodeRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = this.nodeService.getPrimaryParent((NodeRef)current).getParentRef();
                    } else if (ChildAssociationRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = ((ChildAssociationRef)current).getParentRef();
                    } else {
                        if (!PermissionCheckValue.class.isAssignableFrom(current.getClass())) throw new ACLEntryVoterException("The specified parameter is recognized: " + current.getClass());
                        NodeRef nodeRef = ((PermissionCheckValue)current).getNodeRef();
                        testNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                    }
                } else if (StoreRef.class.isAssignableFrom(current.getClass())) {
                    testNodeRef = this.nodeService.getRootNode((StoreRef)current);
                } else if (NodeRef.class.isAssignableFrom(current.getClass())) {
                    testNodeRef = (NodeRef)current;
                } else if (ChildAssociationRef.class.isAssignableFrom(current.getClass())) {
                    testNodeRef = ((ChildAssociationRef)current).getChildRef();
                } else {
                    if (!PermissionCheckValue.class.isAssignableFrom(current.getClass())) throw new ACLEntryVoterException("The specified parameter is recognized: " + current.getClass());
                    testNodeRef = ((PermissionCheckValue)current).getNodeRef();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\t" + cad.typeString + " test on " + testNodeRef + " from " + current.getClass().getName()));
                }
                if (this.isUnfiltered(testNodeRef)) continue;
                int readCheck = childReadChek;
                if (cad.parent) {
                    readCheck = parentReadCheck;
                }
                if (!incudedSet.get(i) || testNodeRef == null || readCheck == 1) continue;
                incudedSet.set(i, false);
            }
        }
        if (incudedSet.cardinality() == returnedObject.length) {
            return returnedObject;
        }
        Object[] answer = new Object[incudedSet.cardinality()];
        int i = incudedSet.nextSetBit(0);
        int p = 0;
        while (i >= 0) {
            answer[p] = returnedObject[i];
            ++i;
            i = incudedSet.nextSetBit(i);
            ++p;
        }
        return answer;
    }

    private NodeRef getParentReadCheckNode(Object current) {
        NodeRef testNodeRef = null;
        if (StoreRef.class.isAssignableFrom(current.getClass())) {
            testNodeRef = null;
        } else if (NodeRef.class.isAssignableFrom(current.getClass())) {
            testNodeRef = this.nodeService.getPrimaryParent((NodeRef)current).getParentRef();
        } else if (ChildAssociationRef.class.isAssignableFrom(current.getClass())) {
            testNodeRef = ((ChildAssociationRef)current).getParentRef();
        } else if (PermissionCheckValue.class.isAssignableFrom(current.getClass())) {
            NodeRef nodeRef = ((PermissionCheckValue)current).getNodeRef();
            testNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        } else {
            throw new ACLEntryVoterException("The specified array is not of NodeRef or ChildAssociationRef");
        }
        return testNodeRef;
    }

    private NodeRef getChildReadCheckNode(Object current) {
        NodeRef testNodeRef = null;
        if (StoreRef.class.isAssignableFrom(current.getClass())) {
            testNodeRef = this.nodeService.getRootNode((StoreRef)current);
        } else if (NodeRef.class.isAssignableFrom(current.getClass())) {
            testNodeRef = (NodeRef)current;
        } else if (ChildAssociationRef.class.isAssignableFrom(current.getClass())) {
            testNodeRef = ((ChildAssociationRef)current).getChildRef();
        } else if (PermissionCheckValue.class.isAssignableFrom(current.getClass())) {
            testNodeRef = ((PermissionCheckValue)current).getNodeRef();
        } else {
            throw new ACLEntryVoterException("The specified array is not of NodeRef or ChildAssociationRef");
        }
        return testNodeRef;
    }

    private class ConfigAttributeDefintion {
        String typeString;
        String mode;
        boolean parent = false;

        ConfigAttributeDefintion(ConfigAttribute attr) {
            StringTokenizer st = new StringTokenizer(attr.getAttribute(), ".", false);
            this.typeString = st.nextToken();
            if (!this.typeString.equals(RMAfterInvocationProvider.AFTER_RM)) {
                throw new ACLEntryVoterException("Invalid type: must be AFTER_RM");
            }
            this.mode = st.nextToken();
            if (st.hasMoreElements()) {
                this.parent = true;
            }
        }
    }
}

