/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.audit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementAction;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditEntry;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditQueryParameters;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.audit.event.AuditEvent;
import org.alfresco.module.org_alfresco_module_rm.audit.event.UserGroupMembershipUtils;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.surf.util.ParameterCheck;

public class RecordsManagementAuditServiceImpl
extends AbstractLifecycleBean
implements RecordsManagementAuditService {
    private static final String MSG_TRAIL_FILE_FAIL = "rm.audit.trail-file-fail";
    private static final String MSG_AUDIT_REPORT = "rm.audit.audit-report";
    private static Log logger = LogFactory.getLog(RecordsManagementAuditServiceImpl.class);
    private static final String ACCESS_AUDIT_CAPABILITY = "AccessAudit";
    private static final String KEY_RM_AUDIT_NODE_RECORDS = "RMAUditNodeRecords";
    protected static final String RM_AUDIT_EVENT_LOGIN_SUCCESS = "Login.Success";
    protected static final String RM_AUDIT_EVENT_LOGIN_FAILURE = "Login.Failure";
    protected static final String RM_AUDIT_APPLICATION_NAME = "RM";
    protected static final String RM_AUDIT_PATH_ROOT = "/RM";
    protected static final String RM_AUDIT_SNIPPET_EVENT = "/event";
    protected static final String RM_AUDIT_SNIPPET_PERSON = "/person";
    protected static final String RM_AUDIT_SNIPPET_NAME = "/name";
    protected static final String RM_AUDIT_SNIPPET_NODE = "/node";
    protected static final String RM_AUDIT_SNIPPET_CHANGES = "/changes";
    protected static final String RM_AUDIT_SNIPPET_BEFORE = "/before";
    protected static final String RM_AUDIT_SNIPPET_AFTER = "/after";
    protected static final String RM_AUDIT_SITES_PATH = "/Sites";
    protected static final String RM_AUDIT_DATA_PERSON_FULLNAME = "/RM/event/person/fullName";
    protected static final String RM_AUDIT_DATA_PERSON_ROLES = "/RM/event/person/roles";
    protected static final String RM_AUDIT_DATA_EVENT_NAME = "/RM/event/name/value";
    protected static final String RM_AUDIT_DATA_NODE_NODEREF = "/RM/event/node/noderef";
    protected static final String RM_AUDIT_DATA_NODE_NAME = "/RM/event/node/name";
    protected static final String RM_AUDIT_DATA_NODE_TYPE = "/RM/event/node/type";
    protected static final String RM_AUDIT_DATA_NODE_IDENTIFIER = "/RM/event/node/identifier";
    protected static final String RM_AUDIT_DATA_NODE_NAMEPATH = "/RM/event/node/namePath";
    protected static final String RM_AUDIT_DATA_NODE_CHANGES_BEFORE = "/RM/event/node/changes/before/value";
    protected static final String RM_AUDIT_DATA_NODE_CHANGES_AFTER = "/RM/event/node/changes/after/value";
    protected static final String RM_AUDIT_DATA_LOGIN_USERNAME = "/RM/login/args/userName/value";
    protected static final String RM_AUDIT_DATA_LOGIN_FULLNAME = "/RM/login/no-error/fullName";
    protected static final String RM_AUDIT_DATA_LOGIN_ERROR = "/RM/login/error/value";
    protected static final String DOD5015_AUDIT_APPLICATION_NAME = "DOD5015";
    protected static final String DOD5015_AUDIT_PATH_ROOT = "/DOD5015";
    protected static final String DOD5015_AUDIT_SNIPPET_EVENT = "/event";
    protected static final String DOD5015_AUDIT_SNIPPET_PERSON = "/person";
    protected static final String DOD5015_AUDIT_SNIPPET_NAME = "/name";
    protected static final String DOD5015_AUDIT_SNIPPET_NODE = "/node";
    protected static final String DOD5015_AUDIT_SNIPPET_CHANGES = "/changes";
    protected static final String DOD5015_AUDIT_SNIPPET_BEFORE = "/before";
    protected static final String DOD5015_AUDIT_SNIPPET_AFTER = "/after";
    protected static final String DOD5015_AUDIT_DATA_PERSON_FULLNAME = "/DOD5015/event/person/fullName";
    protected static final String DOD5015_AUDIT_DATA_PERSON_ROLES = "/DOD5015/event/person/roles";
    protected static final String DOD5015_AUDIT_DATA_EVENT_NAME = "/DOD5015/event/name/value";
    protected static final String DOD5015_AUDIT_DATA_NODE_NODEREF = "/DOD5015/event/node/noderef";
    protected static final String DOD5015_AUDIT_DATA_NODE_NAME = "/DOD5015/event/node/name";
    protected static final String DOD5015_AUDIT_DATA_NODE_TYPE = "/DOD5015/event/node/type";
    protected static final String DOD5015_AUDIT_DATA_NODE_IDENTIFIER = "/DOD5015/event/node/identifier";
    protected static final String DOD5015_AUDIT_DATA_NODE_NAMEPATH = "/DOD5015/event/node/namePath";
    protected static final String DOD5015_AUDIT_DATA_NODE_CHANGES_BEFORE = "/DOD5015/event/node/changes/before/value";
    protected static final String DOD5015_AUDIT_DATA_NODE_CHANGES_AFTER = "/DOD5015/event/node/changes/after/value";
    protected static final String DOD5015_AUDIT_DATA_LOGIN_USERNAME = "/DOD5015/login/args/userName/value";
    protected static final String DOD5015_AUDIT_DATA_LOGIN_FULLNAME = "/DOD5015/login/no-error/fullName";
    protected static final String DOD5015_AUDIT_DATA_LOGIN_ERROR = "/DOD5015/login/error/value";
    protected static final String AUDIT_TRAIL_FILE_PREFIX = "audit_";
    protected static final String AUDIT_TRAIL_JSON_FILE_SUFFIX = ".json";
    protected static final String AUDIT_TRAIL_HTML_FILE_SUFFIX = ".html";
    private static final String AUDIT_EVENT_START = "audit.start";
    private static final String MSG_AUDIT_START = "rm.audit.audit-start";
    private static final String AUDIT_EVENT_STOP = "audit.stop";
    private static final String MSG_AUDIT_STOP = "rm.audit.audit-stop";
    private static final String AUDIT_EVENT_CLEAR = "audit.clear";
    private static final String MSG_AUDIT_CLEAR = "rm.audit.audit-clear";
    private static final String AUDIT_EVENT_VIEW = "audit.view";
    private static final String MSG_AUDIT_VIEW = "rm.audit.audit-view";
    private static final QName PROPERTY_HOLD_NAME = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"Hold Name");
    private static final QName PROPERTY_HOLD_NODEREF = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"Hold NodeRef");
    private static final String HOLD_PERMISSION_DENIED_MSG = "rm.audit.holdPermission-Error";
    private PolicyComponent policyComponent;
    private DictionaryService dictionaryService;
    private TransactionService transactionService;
    private NodeService nodeService;
    private SiteService siteService;
    private ContentService contentService;
    private AuditComponent auditComponent;
    private AuditService auditService;
    private RecordsManagementActionService rmActionService;
    private FilePlanService filePlanService;
    private NamespaceService namespaceService;
    protected CapabilityService capabilityService;
    protected PermissionService permissionService;
    protected HoldService holdService;
    private boolean shutdown = false;
    private List<String> ignoredAuditProperties;
    private List<QName> propertiesToBeRemoved = new ArrayList<QName>();
    private RMAuditTxnListener txnListener = new RMAuditTxnListener();
    private Map<String, AuditEvent> auditEvents = new HashMap<String, AuditEvent>();

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setAuditComponent(AuditComponent auditComponent) {
        this.auditComponent = auditComponent;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setRecordsManagementActionService(RecordsManagementActionService rmActionService) {
        this.rmActionService = rmActionService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setIgnoredAuditProperties(List<String> ignoredAuditProperties) {
        this.ignoredAuditProperties = ignoredAuditProperties;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    @Override
    public void registerAuditEvent(String name, String label) {
        this.registerAuditEvent(new AuditEvent(name, label));
    }

    @Override
    public void registerAuditEvent(AuditEvent auditEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering audit event " + auditEvent.getName()));
        }
        this.auditEvents.put(auditEvent.getName(), auditEvent);
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"auditComponent", (Object)this.auditComponent);
        PropertyCheck.mandatory((Object)this, (String)"auditService", (Object)this.auditService);
        PropertyCheck.mandatory((Object)this, (String)"rmActionService", (Object)this.rmActionService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"filePlanService", (Object)this.filePlanService);
        this.registerAuditEvent(AUDIT_EVENT_CLEAR, MSG_AUDIT_CLEAR);
        this.registerAuditEvent(AUDIT_EVENT_START, MSG_AUDIT_START);
        this.registerAuditEvent(AUDIT_EVENT_STOP, MSG_AUDIT_STOP);
        this.registerAuditEvent(AUDIT_EVENT_VIEW, MSG_AUDIT_VIEW);
        for (String qname : this.ignoredAuditProperties) {
            this.propertiesToBeRemoved.add(QName.createQName((String)qname, (NamespacePrefixResolver)this.namespaceService));
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.shutdown = false;
    }

    protected void onShutdown(ApplicationEvent event) {
        this.shutdown = true;
    }

    @Override
    public boolean isAuditLogEnabled(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        return this.auditService.isAuditEnabled(RM_AUDIT_APPLICATION_NAME, RM_AUDIT_PATH_ROOT);
    }

    @Override
    public void startAuditLog(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        this.auditService.enableAudit(RM_AUDIT_APPLICATION_NAME, RM_AUDIT_PATH_ROOT);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Started Records Management auditing");
        }
        this.auditEvent(filePlan, AUDIT_EVENT_START, null, null, true);
    }

    @Override
    public void stopAuditLog(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        this.auditEvent(filePlan, AUDIT_EVENT_STOP, null, null, true);
        this.auditService.disableAudit(RM_AUDIT_APPLICATION_NAME, RM_AUDIT_PATH_ROOT);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Stopped Records Management auditing");
        }
    }

    @Override
    public void clearAuditLog(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        this.auditService.clearAudit(RM_AUDIT_APPLICATION_NAME, null, null);
        if (logger.isInfoEnabled()) {
            logger.debug((Object)"Records Management audit log has been cleared");
        }
        this.auditEvent(filePlan, AUDIT_EVENT_CLEAR, null, null, true);
    }

    @Override
    public Date getDateAuditLogLastStarted(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        return this.getStartOfDay(new Date());
    }

    @Override
    public Date getDateAuditLogLastStopped(NodeRef filePlan) {
        ParameterCheck.mandatory((String)"filePlan", (Object)filePlan);
        return this.getEndOfDay(new Date());
    }

    @Override
    public void auditEvent(NodeRef nodeRef, String eventName) {
        this.auditEvent(nodeRef, eventName, null, null, false, false);
    }

    @Override
    public void auditEvent(NodeRef nodeRef, String eventName, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        this.auditEvent(nodeRef, eventName, before, after, false, false);
    }

    @Override
    public void auditEvent(NodeRef nodeRef, String eventName, Map<QName, Serializable> before, Map<QName, Serializable> after, boolean immediate) {
        this.auditEvent(nodeRef, eventName, before, after, immediate, false);
    }

    @Override
    public void auditEvent(NodeRef nodeRef, String eventName, Map<QName, Serializable> before, Map<QName, Serializable> after, boolean immediate, boolean removeIfNoPropertyChanged) {
        if (immediate) {
            Map<String, Serializable> auditMap = this.buildAuditMap(nodeRef, eventName, before, after, removeIfNoPropertyChanged);
            this.auditComponent.recordAuditValues(RM_AUDIT_PATH_ROOT, auditMap);
        } else {
            RMAuditNode existingEventNode = this.findExistingEventNode(nodeRef, eventName);
            if (existingEventNode != null) {
                existingEventNode.setNodePropertiesAfter(after);
            } else {
                this.createAuditEventInTransaction(nodeRef, eventName, before, after, removeIfNoPropertyChanged);
            }
        }
    }

    @Override
    public void auditOrUpdateEvent(NodeRef nodeRef, String eventName, Map<QName, Serializable> before, Map<QName, Serializable> after, boolean removeIfNoPropertyChanged) {
        RMAuditNode existingEventNode = this.findExistingEventNode(nodeRef, eventName);
        if (existingEventNode != null) {
            existingEventNode.getNodePropertiesBefore().putAll(before);
            existingEventNode.getNodePropertiesAfter().putAll(after);
        } else {
            this.createAuditEventInTransaction(nodeRef, eventName, before, after, removeIfNoPropertyChanged);
        }
    }

    private void createAuditEventInTransaction(NodeRef nodeRef, String eventName, Map<QName, Serializable> before, Map<QName, Serializable> after, boolean removeIfNoPropertyChanged) {
        RMAuditNode auditedNode = new RMAuditNode();
        auditedNode.setNodeRef(nodeRef);
        auditedNode.setEventName(eventName);
        auditedNode.setNodePropertiesBefore(before);
        auditedNode.setNodePropertiesAfter(after);
        auditedNode.setRemoveIfNoPropertyChanged(removeIfNoPropertyChanged);
        Set auditDetails = TransactionalResourceHelper.getSet((Object)KEY_RM_AUDIT_NODE_RECORDS);
        auditDetails.add(auditedNode);
    }

    private RMAuditNode findExistingEventNode(NodeRef nodeRef, String eventName) {
        AlfrescoTransactionSupport.bindListener((TransactionListener)this.txnListener);
        Set auditDetails = TransactionalResourceHelper.getSet((Object)KEY_RM_AUDIT_NODE_RECORDS);
        for (RMAuditNode existingRMAuditNode : auditDetails) {
            if (!existingRMAuditNode.getNodeRef().equals((Object)nodeRef) || !existingRMAuditNode.getEventName().equals(eventName)) continue;
            return existingRMAuditNode;
        }
        return null;
    }

    private Map<String, Serializable> buildAuditMap(NodeRef nodeRef, String eventName, Map<QName, Serializable> propertiesBefore, Map<QName, Serializable> propertiesAfter, boolean removeOnNoPropertyChange) {
        Pair deltaPair;
        HashMap<String, Serializable> auditMap = new HashMap<String, Serializable>(13);
        auditMap.put(AuditApplication.buildPath((String[])new String[]{"/event", "/name"}), (Serializable)((Object)eventName));
        if (nodeRef != null) {
            auditMap.put(AuditApplication.buildPath((String[])new String[]{"/event", "/node"}), (Serializable)nodeRef);
        }
        if (!this.ignoredAuditProperties.isEmpty()) {
            this.removeAuditProperties(propertiesBefore, propertiesAfter);
        }
        if (((Map)(deltaPair = PropertyMap.getBeforeAndAfterMapsForChanges(propertiesBefore, propertiesAfter)).getFirst()).isEmpty() && ((Map)deltaPair.getSecond()).isEmpty() && removeOnNoPropertyChange) {
            auditMap.clear();
        } else {
            auditMap.put(AuditApplication.buildPath((String[])new String[]{"/event", "/node", "/changes", "/before"}), (Serializable)deltaPair.getFirst());
            auditMap.put(AuditApplication.buildPath((String[])new String[]{"/event", "/node", "/changes", "/after"}), (Serializable)deltaPair.getSecond());
        }
        return auditMap;
    }

    private void removeAuditProperties(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (before != null) {
            before.keySet().removeAll(this.propertiesToBeRemoved);
        }
        if (after != null) {
            after.keySet().removeAll(this.propertiesToBeRemoved);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getAuditTrailFile(RecordsManagementAuditQueryParameters params, RecordsManagementAuditService.ReportFormat format) {
        ParameterCheck.mandatory((String)"params", (Object)params);
        File auditTrailFile = TempFileProvider.createTempFile((String)AUDIT_TRAIL_FILE_PREFIX, (String)(format == RecordsManagementAuditService.ReportFormat.HTML ? AUDIT_TRAIL_HTML_FILE_SUFFIX : AUDIT_TRAIL_JSON_FILE_SUFFIX));
        try (FileOutputStream fileOutputStream = new FileOutputStream(auditTrailFile);){
            File file;
            try (BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8"));){
                this.getAuditTrailImpl(params, null, fileWriter, format);
                file = auditTrailFile;
            }
            return file;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException(MSG_TRAIL_FILE_FAIL, (Throwable)e);
        }
    }

    @Override
    public List<RecordsManagementAuditEntry> getAuditTrail(RecordsManagementAuditQueryParameters params) {
        ParameterCheck.mandatory((String)"params", (Object)params);
        ArrayList<RecordsManagementAuditEntry> entries = new ArrayList<RecordsManagementAuditEntry>(50);
        try {
            this.getAuditTrailImpl(params, entries, null, null);
            return entries;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException(MSG_TRAIL_FILE_FAIL, (Throwable)e);
        }
    }

    protected void getAuditTrailImpl(RecordsManagementAuditQueryParameters params, List<RecordsManagementAuditEntry> results, Writer writer, RecordsManagementAuditService.ReportFormat reportFormat) throws IOException {
        QName siteType;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving audit trail in '" + reportFormat + "' format using parameters: " + params));
        }
        AuditTrailQueryCallback callback = new AuditTrailQueryCallback(results, writer, reportFormat);
        String user = params.getUser();
        Long fromTime = this.getFromDateTime(params.getDateFrom());
        Long toTime = this.getToDateTime(params.getDateTo());
        NodeRef nodeRef = params.getNodeRef();
        int maxEntries = params.getMaxEntries();
        boolean forward = maxEntries <= 0;
        this.writeAuditTrailHeader(writer, params, reportFormat);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RM Audit: Issuing query: " + params));
        }
        AuditQueryParameters dod5015AuditQueryParams = new AuditQueryParameters();
        dod5015AuditQueryParams.setForward(forward);
        dod5015AuditQueryParams.setApplicationName(DOD5015_AUDIT_APPLICATION_NAME);
        dod5015AuditQueryParams.setUser(user);
        dod5015AuditQueryParams.setFromTime(fromTime);
        dod5015AuditQueryParams.setToTime(toTime);
        if (nodeRef != null) {
            dod5015AuditQueryParams.addSearchKey(DOD5015_AUDIT_DATA_NODE_NODEREF, (Serializable)nodeRef);
        }
        AuditQueryParameters auditQueryParams = new AuditQueryParameters();
        auditQueryParams.setForward(forward);
        auditQueryParams.setApplicationName(RM_AUDIT_APPLICATION_NAME);
        auditQueryParams.setUser(user);
        auditQueryParams.setFromTime(fromTime);
        auditQueryParams.setToTime(toTime);
        if (nodeRef != null) {
            auditQueryParams.addSearchKey(RM_AUDIT_DATA_NODE_NODEREF, (Serializable)nodeRef);
        } else if (params.getEvent() != null) {
            if (params.getEvent().equalsIgnoreCase(RM_AUDIT_EVENT_LOGIN_SUCCESS)) {
                auditQueryParams.addSearchKey(RM_AUDIT_DATA_LOGIN_FULLNAME, null);
            } else if (params.getEvent().equalsIgnoreCase(RM_AUDIT_EVENT_LOGIN_FAILURE)) {
                auditQueryParams.addSearchKey(RM_AUDIT_DATA_LOGIN_ERROR, null);
            } else {
                auditQueryParams.addSearchKey(RM_AUDIT_DATA_EVENT_NAME, (Serializable)((Object)params.getEvent()));
            }
        }
        SiteInfo siteInfo = this.siteService.getSite("rm");
        if (siteInfo != null && (siteType = this.nodeService.getType(siteInfo.getNodeRef())).equals((Object)DOD5015Model.TYPE_DOD_5015_SITE)) {
            this.auditService.auditQuery((AuditService.AuditQueryCallback)callback, dod5015AuditQueryParams, maxEntries);
        }
        this.auditService.auditQuery((AuditService.AuditQueryCallback)callback, auditQueryParams, maxEntries);
        this.writeAuditTrailFooter(writer, reportFormat);
        if (nodeRef == null) {
            nodeRef = this.filePlanService.getFilePlanBySiteId("rm");
        }
        this.auditEvent(nodeRef, AUDIT_EVENT_VIEW, null, null, true);
    }

    protected Date getStartOfDay(Date date) {
        return DateUtils.truncate((Date)(date == null ? new Date() : date), (int)5);
    }

    private Date getFromDate(Date date) {
        return date == null ? null : this.getStartOfDay(date);
    }

    private Long getFromDateTime(Date date) {
        Long fromDateTime = null;
        Date fromDate = this.getFromDate(date);
        if (fromDate != null) {
            fromDateTime = fromDate.getTime();
        }
        return fromDateTime;
    }

    private Date getEndOfDay(Date date) {
        return DateUtils.addMilliseconds((Date)DateUtils.ceiling((Date)(date == null ? new Date() : date), (int)5), (int)-1);
    }

    private Date getToDate(Date date) {
        return date == null ? null : this.getEndOfDay(date);
    }

    private Long getToDateTime(Date date) {
        Long toDateTime = null;
        Date toDate = this.getToDate(date);
        if (toDate != null) {
            toDateTime = toDate.getTime();
        }
        return toDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef fileAuditTrailAsRecord(RecordsManagementAuditQueryParameters params, NodeRef destination, RecordsManagementAuditService.ReportFormat format) {
        ParameterCheck.mandatory((String)"params", (Object)params);
        ParameterCheck.mandatory((String)"destination", (Object)destination);
        NodeRef record = null;
        File auditTrail = this.getAuditTrailFile(params, format);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Filing audit trail in file " + auditTrail.getAbsolutePath() + " as a record in record folder: " + destination));
        }
        try {
            HashMap<QName, String> properties = new HashMap<QName, String>(1);
            properties.put(ContentModel.PROP_NAME, auditTrail.getName());
            record = this.nodeService.createNode(destination, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)auditTrail.getName())), ContentModel.TYPE_CONTENT, properties).getChildRef();
            ContentWriter writer = this.contentService.getWriter(record, ContentModel.PROP_CONTENT, true);
            writer.setMimetype(format == RecordsManagementAuditService.ReportFormat.HTML ? "text/html" : "application/json");
            writer.setEncoding("UTF-8");
            writer.putContent(auditTrail);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Audit trail report saved to temporary file: " + auditTrail.getAbsolutePath()));
            } else {
                auditTrail.delete();
            }
        }
        return record;
    }

    @Override
    public List<AuditEvent> getAuditEvents() {
        ArrayList<AuditEvent> listAuditEvents = new ArrayList<AuditEvent>(this.auditEvents.size());
        listAuditEvents.addAll(this.auditEvents.values());
        Collections.sort(listAuditEvents);
        return listAuditEvents;
    }

    private void writeAuditTrailHeader(Writer writer, RecordsManagementAuditQueryParameters params, RecordsManagementAuditService.ReportFormat reportFormat) throws IOException {
        if (writer == null) {
            return;
        }
        if (reportFormat == RecordsManagementAuditService.ReportFormat.HTML) {
            writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
            writer.write("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n");
            writer.write("<title>");
            writer.write(I18NUtil.getMessage((String)MSG_AUDIT_REPORT));
            writer.write("</title></head>\n");
            writer.write("<style>\n");
            writer.write("body { font-family: arial,verdana; font-size: 81%; color: #333; }\n");
            writer.write(".label { margin-right: 5px; font-weight: bold; }\n");
            writer.write(".value { margin-right: 40px; }\n");
            writer.write(".audit-info { background-color: #efefef; padding: 10px; margin-bottom: 4px; }\n");
            writer.write(".audit-entry { border: 1px solid #bbb; margin-top: 15px; }\n");
            writer.write(".audit-entry-header { background-color: #bbb; padding: 8px; }\n");
            writer.write(".audit-entry-node { padding: 10px; }\n");
            writer.write(".changed-values-table { margin-left: 6px; margin-bottom: 2px;width: 99%; }\n");
            writer.write(".changed-values-table th { text-align: left; background-color: #eee; padding: 4px; }\n");
            writer.write(".changed-values-table td { width: 33%; padding: 4px; border-top: 1px solid #eee; }\n");
            writer.write("</style>\n");
            writer.write("<body>\n<h2>");
            writer.write(I18NUtil.getMessage((String)MSG_AUDIT_REPORT));
            writer.write("</h2>\n");
            writer.write("<div class=\"audit-info\">\n");
            writer.write("<span class=\"label\">From:</span>");
            writer.write("<span class=\"value\">");
            Date from = params.getDateFrom();
            writer.write(from == null ? "&lt;Not Set&gt;" : StringEscapeUtils.escapeHtml4((String)from.toString()));
            writer.write("</span>");
            writer.write("<span class=\"label\">To:</span>");
            writer.write("<span class=\"value\">");
            Date to = params.getDateTo();
            writer.write(to == null ? "&lt;Not Set&gt;" : StringEscapeUtils.escapeHtml4((String)to.toString()));
            writer.write("</span>");
            writer.write("<span class=\"label\">Property:</span>");
            writer.write("<span class=\"value\">");
            QName prop = params.getProperty();
            writer.write(prop == null ? "All" : StringEscapeUtils.escapeHtml4((String)this.getPropertyLabel(prop)));
            writer.write("</span>");
            writer.write("<span class=\"label\">User:</span>");
            writer.write("<span class=\"value\">");
            writer.write(params.getUser() == null ? "All" : StringEscapeUtils.escapeHtml4((String)params.getUser()));
            writer.write("</span>");
            writer.write("<span class=\"label\">Event:</span>");
            writer.write("<span class=\"value\">");
            writer.write(params.getEvent() == null ? "All" : StringEscapeUtils.escapeHtml4((String)this.getAuditEventLabel(params.getEvent())));
            writer.write("</span>\n");
            writer.write("</div>\n");
        } else {
            writer.write("{\n\t\"data\":\n\t{");
            writer.write("\n\t\t\"started\": \"");
            writer.write(ISO8601DateFormat.format((Date)this.getStartOfDay(params.getDateFrom())));
            writer.write("\",\n\t\t\"stopped\": \"");
            writer.write(ISO8601DateFormat.format((Date)this.getEndOfDay(params.getDateTo())));
            writer.write("\",\n\t\t\"enabled\": ");
            writer.write(Boolean.toString(this.isEnabled()));
            writer.write(",\n\t\t\"entries\":[");
        }
    }

    private void writeAuditTrailEntry(Writer writer, RecordsManagementAuditEntry entry, RecordsManagementAuditService.ReportFormat reportFormat) throws IOException {
        if (writer == null) {
            return;
        }
        if (reportFormat == RecordsManagementAuditService.ReportFormat.HTML) {
            writer.write("<div class=\"audit-entry\">\n");
            writer.write("<div class=\"audit-entry-header\">");
            writer.write("<span class=\"label\">Timestamp:</span>");
            writer.write("<span class=\"value\">");
            writer.write(StringEscapeUtils.escapeHtml4((String)entry.getTimestamp().toString()));
            writer.write("</span>");
            writer.write("<span class=\"label\">User:</span>");
            writer.write("<span class=\"value\">");
            writer.write(entry.getFullName() != null ? StringEscapeUtils.escapeHtml4((String)entry.getFullName()) : StringEscapeUtils.escapeHtml4((String)entry.getUserName()));
            writer.write("</span>");
            if (entry.getUserRole() != null && entry.getUserRole().length() > 0) {
                writer.write("<span class=\"label\">Role:</span>");
                writer.write("<span class=\"value\">");
                writer.write(StringEscapeUtils.escapeHtml4((String)entry.getUserRole()));
                writer.write("</span>");
            }
            if (entry.getEvent() != null && entry.getEvent().length() > 0) {
                writer.write("<span class=\"label\">Event:</span>");
                writer.write("<span class=\"value\">");
                writer.write(StringEscapeUtils.escapeHtml4((String)this.getAuditEventLabel(entry.getEvent())));
                writer.write("</span>\n");
            }
            writer.write("</div>\n");
            writer.write("<div class=\"audit-entry-node\">");
            if (entry.getIdentifier() != null && entry.getIdentifier().length() > 0) {
                writer.write("<span class=\"label\">Identifier:</span>");
                writer.write("<span class=\"value\">");
                writer.write(StringEscapeUtils.escapeHtml4((String)entry.getIdentifier()));
                writer.write("</span>");
            }
            if (entry.getNodeType() != null && entry.getNodeType().length() > 0) {
                writer.write("<span class=\"label\">Type:</span>");
                writer.write("<span class=\"value\">");
                writer.write(StringEscapeUtils.escapeHtml4((String)entry.getNodeType()));
                writer.write("</span>");
            }
            if (entry.getPath() != null && entry.getPath().length() > 0) {
                String path = entry.getPath();
                int idx = path.indexOf(RM_AUDIT_SITES_PATH);
                Object displayPath = idx != -1 ? path.substring(idx + RM_AUDIT_SITES_PATH.length()) : path;
                writer.write("<span class=\"label\">Location:</span>");
                writer.write("<span class=\"value\">");
                writer.write(StringEscapeUtils.escapeHtml4((String)displayPath));
                writer.write("</span>");
            }
            writer.write("</div>\n");
            if (entry.getChangedProperties() != null && !entry.getChangedProperties().isEmpty()) {
                writer.write("<table class=\"changed-values-table\" cellspacing=\"0\">");
                writer.write("<tr><th>Property</th><th>Previous Value</th><th>New Value</th></tr>");
                for (QName valueName : entry.getChangedProperties().keySet()) {
                    Pair<Serializable, Serializable> values = entry.getChangedProperties().get(valueName);
                    writer.write("<tr><td>");
                    writer.write(this.getPropertyLabel(valueName));
                    writer.write("</td><td>");
                    QName propDataType = DataTypeDefinition.TEXT;
                    PropertyDefinition propDef = this.dictionaryService.getProperty(valueName);
                    if (propDef != null) {
                        propDataType = propDef.getDataType().getName();
                    }
                    if (DataTypeDefinition.MLTEXT.equals((Object)propDataType)) {
                        writer.write(values.getFirst() == null ? "&lt;none&gt;" : StringEscapeUtils.escapeHtml4((String)this.convertToMlText((Map)values.getFirst()).getDefaultValue()));
                        writer.write("</td><td>");
                        writer.write(values.getSecond() == null ? "&lt;none&gt;" : StringEscapeUtils.escapeHtml4((String)this.convertToMlText((Map)values.getSecond()).getDefaultValue()));
                    } else {
                        Serializable oldValue = (Serializable)values.getFirst();
                        writer.write(oldValue == null ? "&lt;none&gt;" : StringEscapeUtils.escapeHtml4((String)oldValue.toString()));
                        writer.write("</td><td>");
                        Serializable newValue = (Serializable)values.getSecond();
                        writer.write(newValue == null ? "&lt;none&gt;" : StringEscapeUtils.escapeHtml4((String)newValue.toString()));
                    }
                    writer.write("</td></tr>");
                }
                writer.write("</table>\n");
            }
            writer.write("</div>");
        } else {
            try {
                JSONObject json = new JSONObject();
                json.put("timestamp", (Object)entry.getTimestampString());
                json.put("userName", (Object)entry.getUserName());
                json.put("userRole", (Object)(entry.getUserRole() == null ? "" : entry.getUserRole()));
                json.put("fullName", (Object)(entry.getFullName() == null ? "" : entry.getFullName()));
                json.put("nodeRef", (Object)(entry.getNodeRef() == null ? "" : entry.getNodeRef()));
                this.setNodeName(entry, json);
                json.put("nodeType", (Object)(entry.getNodeType() == null ? "" : entry.getNodeType()));
                json.put("event", (Object)(entry.getEvent() == null ? "" : this.getAuditEventLabel(entry.getEvent())));
                json.put("identifier", (Object)(entry.getIdentifier() == null ? "" : entry.getIdentifier()));
                json.put("path", (Object)(entry.getPath() == null ? "" : entry.getPath()));
                JSONArray changedValues = new JSONArray();
                if (entry.getChangedProperties() != null) {
                    for (QName valueName : entry.getChangedProperties().keySet()) {
                        Pair<Serializable, Serializable> values = entry.getChangedProperties().get(valueName);
                        JSONObject changedValue = new JSONObject();
                        changedValue.put("name", (Object)this.getPropertyLabel(valueName));
                        QName propDataType = DataTypeDefinition.TEXT;
                        PropertyDefinition propDef = this.dictionaryService.getProperty(valueName);
                        if (propDef != null) {
                            propDataType = propDef.getDataType().getName();
                        }
                        if (DataTypeDefinition.MLTEXT.equals((Object)propDataType)) {
                            changedValue.put("previous", (Object)(values.getFirst() == null ? "" : this.convertToMlText((Map)values.getFirst()).getDefaultValue()));
                            changedValue.put("new", (Object)(values.getSecond() == null ? "" : this.convertToMlText((Map)values.getSecond()).getDefaultValue()));
                        } else {
                            changedValue.put("previous", (Object)(values.getFirst() == null ? "" : ((Serializable)values.getFirst()).toString()));
                            changedValue.put("new", (Object)(values.getSecond() == null ? "" : ((Serializable)values.getSecond()).toString()));
                        }
                        changedValues.put((Object)changedValue);
                    }
                }
                json.put("changedValues", (Object)changedValues);
                writer.write(json.toString());
            }
            catch (JSONException je) {
                writer.write("{}");
            }
        }
    }

    private void setNodeName(RecordsManagementAuditEntry entry, JSONObject json) throws JSONException {
        String nodeName = null;
        if (entry.getNodeRef() != null) {
            switch (entry.getEvent()) {
                case "Create Person": {
                    nodeName = this.getNodeName(entry.getAfterProperties(), ContentModel.PROP_USERNAME);
                    NodeRef nodeRef = entry.getNodeRef();
                    if (nodeName == null && this.nodeService.exists(nodeRef)) {
                        nodeName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
                    }
                    json.put("createPerson", true);
                    break;
                }
                case "Delete Person": {
                    nodeName = this.getNodeName(entry.getBeforeProperties(), ContentModel.PROP_USERNAME);
                    json.put("noAvailableLink", true);
                    break;
                }
                case "Create User Group": {
                    nodeName = this.getNodeName(entry.getAfterProperties(), ContentModel.PROP_AUTHORITY_DISPLAY_NAME, ContentModel.PROP_AUTHORITY_NAME);
                    json.put("noAvailableLink", true);
                    break;
                }
                case "Delete User Group": {
                    nodeName = this.getNodeName(entry.getBeforeProperties(), ContentModel.PROP_AUTHORITY_DISPLAY_NAME, ContentModel.PROP_AUTHORITY_NAME);
                    json.put("noAvailableLink", true);
                    break;
                }
                case "Add To User Group": {
                    nodeName = this.getNodeName(entry.getAfterProperties(), UserGroupMembershipUtils.PARENT_GROUP);
                    json.put("noAvailableLink", true);
                    break;
                }
                case "Remove From User Group": {
                    nodeName = this.getNodeName(entry.getBeforeProperties(), UserGroupMembershipUtils.PARENT_GROUP);
                    json.put("noAvailableLink", true);
                    break;
                }
                case "Delete RM Object": 
                case "Delete Hold": {
                    nodeName = entry.getNodeName();
                    json.put("noAvailableLink", true);
                    break;
                }
                default: {
                    nodeName = entry.getNodeName();
                }
            }
        }
        json.put("nodeName", (Object)(nodeName == null ? "" : nodeName));
    }

    private String getNodeName(Map<QName, Serializable> properties, QName ... propertyNames) {
        for (QName propertyName : propertyNames) {
            String nodeName;
            String string = nodeName = properties != null ? (String)((Object)properties.get(propertyName)) : null;
            if (StringUtils.isBlank((CharSequence)nodeName)) continue;
            return nodeName;
        }
        return null;
    }

    private MLText convertToMlText(Map<Locale, String> map) {
        MLText mlText = new MLText();
        mlText.putAll(map);
        return mlText;
    }

    private void writeAuditTrailFooter(Writer writer, RecordsManagementAuditService.ReportFormat reportFormat) throws IOException {
        if (writer == null) {
            return;
        }
        if (reportFormat == RecordsManagementAuditService.ReportFormat.HTML) {
            writer.write("\n</body></html>");
        } else {
            writer.write("\n\t\t]\n\t}\n}");
        }
    }

    private String getPropertyLabel(QName property) {
        String label = null;
        PropertyDefinition propDef = this.dictionaryService.getProperty(property);
        if (propDef != null) {
            label = propDef.getTitle((MessageLookup)this.dictionaryService);
        }
        if (label == null) {
            label = property.getLocalName();
        }
        return label;
    }

    private String getAuditEventLabel(String eventKey) {
        String label = eventKey;
        AuditEvent event = this.auditEvents.get(eventKey);
        if (event != null) {
            label = event.getLabel();
        }
        return label;
    }

    private NodeRef getDefaultFilePlan() {
        NodeRef defaultFilePlan = this.filePlanService.getFilePlanBySiteId("rm");
        if (defaultFilePlan == null) {
            throw new AlfrescoRuntimeException("Default file plan could not be found.");
        }
        return defaultFilePlan;
    }

    @Override
    @Deprecated
    public boolean isEnabled() {
        return this.isAuditLogEnabled(this.getDefaultFilePlan());
    }

    @Deprecated
    public void start() {
        this.startAuditLog(this.getDefaultFilePlan());
    }

    @Override
    @Deprecated
    public void stop() {
        this.stopAuditLog(this.getDefaultFilePlan());
    }

    @Override
    @Deprecated
    public Date getDateLastStarted() {
        return this.getDateAuditLogLastStarted(this.getDefaultFilePlan());
    }

    @Override
    @Deprecated
    public Date getDateLastStopped() {
        return this.getDateAuditLogLastStopped(this.getDefaultFilePlan());
    }

    @Override
    @Deprecated
    public void clear() {
        this.clearAuditLog(this.getDefaultFilePlan());
    }

    @Override
    @Deprecated
    public void auditRMAction(RecordsManagementAction action, NodeRef nodeRef, Map<String, Serializable> parameters) {
        this.auditEvent(nodeRef, action.getName());
    }

    private class AuditTrailQueryCallback
    implements AuditService.AuditQueryCallback {
        private final List<RecordsManagementAuditEntry> results;
        private final Writer writer;
        private final RecordsManagementAuditService.ReportFormat reportFormat;
        private boolean firstEntry;

        public AuditTrailQueryCallback(List<RecordsManagementAuditEntry> results, Writer writer, RecordsManagementAuditService.ReportFormat reportFormat) {
            this.results = results;
            this.writer = writer;
            this.reportFormat = reportFormat;
            this.firstEntry = true;
        }

        public boolean valuesRequired() {
            return true;
        }

        public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
            logger.warn((Object)errorMsg, error);
            return true;
        }

        public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
            QName nodeTypeQname;
            if (RecordsManagementAuditServiceImpl.this.shutdown) {
                return false;
            }
            Date timestamp = new Date(time);
            String eventName = null;
            String fullName = null;
            String userRoles = null;
            NodeRef nodeRef = null;
            String nodeName = null;
            String nodeType = null;
            String nodeIdentifier = null;
            String namePath = null;
            Map beforeProperties = null;
            Map afterProperties = null;
            if (values.containsKey(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_EVENT_NAME)) {
                eventName = (String)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_EVENT_NAME));
                fullName = (String)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_PERSON_FULLNAME));
                userRoles = (String)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_PERSON_ROLES));
                nodeRef = (NodeRef)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_NODE_NODEREF);
                nodeName = (String)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_NODE_NAME));
                nodeTypeQname = (QName)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_NODE_TYPE);
                nodeIdentifier = (String)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_NODE_IDENTIFIER));
                namePath = (String)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_NODE_NAMEPATH));
                beforeProperties = (Map)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_NODE_CHANGES_BEFORE));
                afterProperties = (Map)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_NODE_CHANGES_AFTER));
                if (nodeTypeQname != null) {
                    TypeDefinition typeDef = RecordsManagementAuditServiceImpl.this.dictionaryService.getType(nodeTypeQname);
                    nodeType = typeDef != null ? typeDef.getTitle((MessageLookup)RecordsManagementAuditServiceImpl.this.dictionaryService) : null;
                }
            } else if (values.containsKey(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_EVENT_NAME)) {
                eventName = (String)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_EVENT_NAME));
                fullName = (String)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_PERSON_FULLNAME));
                userRoles = (String)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_PERSON_ROLES));
                nodeRef = (NodeRef)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_NODE_NODEREF);
                nodeName = (String)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_NODE_NAME));
                nodeTypeQname = (QName)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_NODE_TYPE);
                nodeIdentifier = (String)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_NODE_IDENTIFIER));
                namePath = (String)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_NODE_NAMEPATH));
                beforeProperties = (Map)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_NODE_CHANGES_BEFORE));
                afterProperties = (Map)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_NODE_CHANGES_AFTER));
                if (nodeTypeQname != null) {
                    TypeDefinition typeDef = RecordsManagementAuditServiceImpl.this.dictionaryService.getType(nodeTypeQname);
                    nodeType = typeDef != null ? typeDef.getTitle((MessageLookup)RecordsManagementAuditServiceImpl.this.dictionaryService) : null;
                }
            } else if (values.containsKey(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_LOGIN_USERNAME)) {
                user = (String)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_LOGIN_USERNAME));
                if (values.containsKey(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_LOGIN_ERROR)) {
                    eventName = RecordsManagementAuditServiceImpl.RM_AUDIT_EVENT_LOGIN_FAILURE;
                    fullName = user;
                } else {
                    eventName = RecordsManagementAuditServiceImpl.RM_AUDIT_EVENT_LOGIN_SUCCESS;
                    fullName = (String)((Object)values.get(RecordsManagementAuditServiceImpl.RM_AUDIT_DATA_LOGIN_FULLNAME));
                }
            } else if (values.containsKey(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_LOGIN_USERNAME)) {
                user = (String)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_LOGIN_USERNAME));
                if (values.containsKey(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_LOGIN_ERROR)) {
                    eventName = RecordsManagementAuditServiceImpl.RM_AUDIT_EVENT_LOGIN_FAILURE;
                    fullName = user;
                } else {
                    eventName = RecordsManagementAuditServiceImpl.RM_AUDIT_EVENT_LOGIN_SUCCESS;
                    fullName = (String)((Object)values.get(RecordsManagementAuditServiceImpl.DOD5015_AUDIT_DATA_LOGIN_FULLNAME));
                }
            } else {
                logger.warn((Object)("Unable to process audit entry for RM.  Unexpected data: \n   Entry: " + entryId + "\n   Data:  " + values));
                return true;
            }
            if (nodeRef != null && RecordsManagementAuditServiceImpl.this.nodeService.exists(nodeRef)) {
                if (RecordsManagementAuditServiceImpl.this.filePlanService.isFilePlanComponent(nodeRef) && !AccessStatus.ALLOWED.equals((Object)RecordsManagementAuditServiceImpl.this.capabilityService.getCapabilityAccessState(nodeRef, RecordsManagementAuditServiceImpl.ACCESS_AUDIT_CAPABILITY)) || !AccessStatus.ALLOWED.equals((Object)RecordsManagementAuditServiceImpl.this.permissionService.hasPermission(nodeRef, "Read"))) {
                    return true;
                }
                this.checkPermissionIfHoldInProperties(beforeProperties);
                this.checkPermissionIfHoldInProperties(afterProperties);
            }
            this.removeHoldNodeRefIfPresent(beforeProperties);
            this.removeHoldNodeRefIfPresent(afterProperties);
            RecordsManagementAuditEntry entry = new RecordsManagementAuditEntry(timestamp, user, fullName, userRoles, nodeRef, nodeName, nodeType, eventName, nodeIdentifier, namePath, beforeProperties, afterProperties);
            this.writeEntryToFile(entry);
            if (this.results != null) {
                this.results.add(entry);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("   " + entry));
            }
            return true;
        }

        private void checkPermissionIfHoldInProperties(Map<QName, Serializable> eventProperties) {
            NodeRef holdNodeRef;
            NodeRef nodeRef = holdNodeRef = eventProperties != null ? (NodeRef)eventProperties.get(PROPERTY_HOLD_NODEREF) : null;
            if (holdNodeRef != null && !AccessStatus.ALLOWED.equals((Object)RecordsManagementAuditServiceImpl.this.permissionService.hasPermission(holdNodeRef, "Read"))) {
                eventProperties.replace(PROPERTY_HOLD_NAME, (Serializable)((Object)I18NUtil.getMessage((String)RecordsManagementAuditServiceImpl.HOLD_PERMISSION_DENIED_MSG)));
            }
        }

        private void removeHoldNodeRefIfPresent(Map<QName, Serializable> eventProperties) {
            if (eventProperties != null) {
                eventProperties.remove(PROPERTY_HOLD_NODEREF);
            }
        }

        private void writeEntryToFile(RecordsManagementAuditEntry entry) {
            if (this.writer == null) {
                return;
            }
            try {
                if (!this.firstEntry) {
                    if (this.reportFormat == RecordsManagementAuditService.ReportFormat.HTML) {
                        this.writer.write("\n");
                    } else {
                        this.writer.write(",");
                    }
                } else {
                    this.firstEntry = false;
                }
                if (this.reportFormat == RecordsManagementAuditService.ReportFormat.JSON) {
                    this.writer.write("\n\t\t");
                }
                RecordsManagementAuditServiceImpl.this.writeAuditTrailEntry(this.writer, entry, this.reportFormat);
            }
            catch (IOException ioe) {
                throw new AlfrescoRuntimeException(RecordsManagementAuditServiceImpl.MSG_TRAIL_FILE_FAIL, (Throwable)ioe);
            }
        }
    }

    private static class RMAuditNode {
        private NodeRef nodeRef;
        private String eventName;
        private Map<QName, Serializable> nodePropertiesBefore;
        private Map<QName, Serializable> nodePropertiesAfter;
        private boolean removeIfNoPropertyChanged = false;

        private RMAuditNode() {
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public void setNodeRef(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public Map<QName, Serializable> getNodePropertiesBefore() {
            return this.nodePropertiesBefore;
        }

        public void setNodePropertiesBefore(Map<QName, Serializable> nodePropertiesBefore) {
            this.nodePropertiesBefore = nodePropertiesBefore;
        }

        public Map<QName, Serializable> getNodePropertiesAfter() {
            return this.nodePropertiesAfter;
        }

        public void setNodePropertiesAfter(Map<QName, Serializable> nodePropertiesAfter) {
            this.nodePropertiesAfter = nodePropertiesAfter;
        }

        public boolean getRemoveIfNoPropertyChanged() {
            return this.removeIfNoPropertyChanged;
        }

        public void setRemoveIfNoPropertyChanged(boolean removeIfNoPropertyChanged) {
            this.removeIfNoPropertyChanged = removeIfNoPropertyChanged;
        }
    }

    private class RMAuditTxnListener
    extends TransactionListenerAdapter {
        private final Log logger = LogFactory.getLog(RecordsManagementAuditServiceImpl.class);

        private RMAuditTxnListener() {
        }

        public void afterCommit() {
            final Set auditedNodes = TransactionalResourceHelper.getSet((Object)RecordsManagementAuditServiceImpl.KEY_RM_AUDIT_NODE_RECORDS);
            RetryingTransactionHelper.RetryingTransactionCallback<Void> auditCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    RMAuditTxnListener.this.auditInTxn(auditedNodes);
                    return null;
                }
            };
            RecordsManagementAuditServiceImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)auditCallback, false, true);
        }

        private void auditInTxn(Set<RMAuditNode> auditedNodes) throws SystemException {
            boolean auditedSomething = false;
            for (RMAuditNode auditedNode : auditedNodes) {
                NodeRef nodeRef = auditedNode.getNodeRef();
                if (nodeRef != null && !RecordsManagementAuditServiceImpl.this.nodeService.exists(nodeRef)) continue;
                Map auditMap = RecordsManagementAuditServiceImpl.this.buildAuditMap(nodeRef, auditedNode.getEventName(), auditedNode.getNodePropertiesBefore(), auditedNode.getNodePropertiesAfter(), auditedNode.getRemoveIfNoPropertyChanged());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("RM Audit: Auditing values: \n" + auditMap));
                }
                if ((auditMap = RecordsManagementAuditServiceImpl.this.auditComponent.recordAuditValues(RecordsManagementAuditServiceImpl.RM_AUDIT_PATH_ROOT, auditMap)).isEmpty()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"RM Audit: Nothing was audited.");
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("RM Audit: Audited values: \n" + auditMap));
                }
                auditedSomething = true;
            }
            if (!auditedSomething) {
                RetryingTransactionHelper.getActiveUserTransaction().setRollbackOnly();
            }
        }
    }
}

