/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.admin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_dod5015.caveat.RMListOfValuesConstraint;
import org.alfresco.module.org_alfresco_module_rm.admin.CannotApplyConstraintMetadataException;
import org.alfresco.module.org_alfresco_module_rm.admin.CustomMetadataException;
import org.alfresco.module.org_alfresco_module_rm.admin.InvalidCustomAspectMetadataException;
import org.alfresco.module.org_alfresco_module_rm.admin.NotCustomisableMetadataException;
import org.alfresco.module.org_alfresco_module_rm.admin.PropertyAlreadyExistsMetadataException;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminBase;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMListOfValuesConstraint;
import org.alfresco.module.org_alfresco_module_rm.compatibility.CompatibilityModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinition;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDisplayName;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.LockCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.surf.util.URLDecoder;

@BehaviourBean
public class RecordsManagementAdminServiceImpl
extends RecordsManagementAdminBase
implements RecordsManagementAdminService,
RecordsManagementCustomModel,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnCreateNodePolicy,
ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordsManagementAdminServiceImpl.class);
    private static final String MSG_SERVICE_NOT_INIT = "rm.admin.service-not-init";
    private static final String MSG_PROP_EXIST = "rm.admin.prop-exist";
    private static final String MSG_CUSTOM_PROP_EXIST = "rm.admin.custom-prop-exist";
    private static final String MSG_UNKNOWN_ASPECT = "rm.admin.unknown-aspect";
    private static final String MSG_CONSTRAINT_EXISTS = "rm.admin.constraint-exists";
    private static final String MSG_CANNOT_FIND_CONSTRAINT = "rm.admin.contraint-cannot-find";
    private static final String MSG_UNEXPECTED_TYPE_CONSTRAINT = "rm.admin.unexpected_type_constraint";
    private static final String MSG_ERROR_CLIENT_ID = "rm.admin.error-client-id";
    private static final String CUSTOM_CONSTRAINT_TYPE = org.alfresco.module.org_alfresco_module_rm.caveat.RMListOfValuesConstraint.class.getName();
    private static final String CAPABILITY_CUSTOM_CONSTRAINT_TYPE = RMListOfValuesConstraint.class.getName();
    private static final String PARAM_ALLOWED_VALUES = "allowedValues";
    private static final String PARAM_CASE_SENSITIVE = "caseSensitive";
    private static final String PARAM_MATCH_LOGIC = "matchLogic";
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"RecordsManagementAdminServiceImpl");
    private static final long DEFAULT_TIME = 30000L;
    private RelationshipService relationshipService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private List<QName> pendingCustomisableTypes;
    private Map<QName, QName> customisableTypes;
    private boolean isCustomMapInit = false;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    protected RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent event) {
        LockCallback lockCallback = new LockCallback();
        String lockToken = this.getLock();
        if (lockToken != null) {
            block7: {
                try {
                    this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 30000L, (JobLockService.JobLockRefreshCallback)lockCallback);
                    if (this.isCustomMapInit || !this.getDictionaryService().getAllModels().contains(RM_CUSTOM_MODEL)) break block7;
                    AuthenticationUtil.runAsSystem(() -> {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                            this.initCustomMap();
                            return null;
                        });
                        return null;
                    });
                }
                catch (Throwable throwable) {
                    try {
                        lockCallback.setIsRunning(false);
                        this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                    }
                    catch (LockAcquisitionException e) {
                        LOGGER.debug("Lock release failed: {}: {}", new Object[]{LOCK_QNAME, lockToken, e});
                    }
                    throw throwable;
                }
            }
            try {
                lockCallback.setIsRunning(false);
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
            catch (LockAcquisitionException e) {
                LOGGER.debug("Lock release failed: {}: {}", new Object[]{LOCK_QNAME, lockToken, e});
            }
        }
    }

    private String getLock() {
        try {
            return this.jobLockService.getLock(LOCK_QNAME, 30000L);
        }
        catch (LockAcquisitionException e) {
            return null;
        }
    }

    public boolean isCustomMapInit() {
        return this.isCustomMapInit;
    }

    @Behaviour(kind=BehaviourKind.CLASS, isService=true, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onAddAspect(final NodeRef nodeRef, final QName aspectTypeQName) {
        if (this.isCustomMapInit) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    if (RecordsManagementAdminServiceImpl.this.getNodeService().exists(nodeRef) && RecordsManagementAdminServiceImpl.this.getDictionaryService().getAllModels().contains(RecordsManagementCustomModel.RM_CUSTOM_MODEL) && RecordsManagementAdminServiceImpl.this.isCustomisable(aspectTypeQName)) {
                        QName customPropertyAspect = RecordsManagementAdminServiceImpl.this.getCustomAspect(aspectTypeQName);
                        RecordsManagementAdminServiceImpl.this.getNodeService().addAspect(nodeRef, customPropertyAspect, null);
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, isService=true, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onRemoveAspect(final NodeRef nodeRef, final QName aspectTypeQName) {
        if (this.isCustomMapInit) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    if (RecordsManagementAdminServiceImpl.this.getNodeService().exists(nodeRef) && RecordsManagementAdminServiceImpl.this.isCustomisable(aspectTypeQName)) {
                        QName customPropertyAspect = RecordsManagementAdminServiceImpl.this.getCustomAspect(aspectTypeQName);
                        RecordsManagementAdminServiceImpl.this.getNodeService().removeAspect(nodeRef, customPropertyAspect);
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, isService=true, notificationFrequency=Behaviour.NotificationFrequency.FIRST_EVENT)
    public void onCreateNode(final ChildAssociationRef childAssocRef) {
        if (this.isCustomMapInit) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    if (RecordsManagementAdminServiceImpl.this.getDictionaryService().getAllModels().contains(RecordsManagementCustomModel.RM_CUSTOM_MODEL)) {
                        NodeRef nodeRef = childAssocRef.getChildRef();
                        QName type = RecordsManagementAdminServiceImpl.this.getNodeService().getType(nodeRef);
                        while (type != null && !ContentModel.TYPE_CMOBJECT.equals((Object)type)) {
                            TypeDefinition def;
                            if (RecordsManagementAdminServiceImpl.this.isCustomisable(type)) {
                                QName customPropertyAspect = RecordsManagementAdminServiceImpl.this.getCustomAspect(type);
                                RecordsManagementAdminServiceImpl.this.getNodeService().addAspect(nodeRef, customPropertyAspect, null);
                            }
                            if ((def = RecordsManagementAdminServiceImpl.this.getDictionaryService().getType(type)) != null) {
                                type = def.getParentName();
                                continue;
                            }
                            type = null;
                        }
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    public void setCustomisableTypes(List<String> customisableTypes) {
        ParameterCheck.mandatory((String)"customisableTypes", customisableTypes);
        this.pendingCustomisableTypes = new ArrayList<QName>();
        for (String customisableType : customisableTypes) {
            this.pendingCustomisableTypes.add(QName.createQName((String)customisableType, (NamespacePrefixResolver)this.getNamespaceService()));
        }
    }

    @Override
    public Set<QName> getCustomisable() {
        return this.getCustomisableMap().keySet();
    }

    @Override
    public Set<QName> getCustomisable(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        HashSet<QName> result = new HashSet<QName>(5);
        QName type = this.getNodeService().getType(nodeRef);
        while (type != null && !ContentModel.TYPE_CMOBJECT.equals((Object)type)) {
            TypeDefinition def;
            if (this.isCustomisable(type)) {
                result.add(type);
            }
            if ((def = this.getDictionaryService().getType(type)) != null) {
                type = def.getParentName();
                continue;
            }
            type = null;
        }
        Set aspects = this.getNodeService().getAspects(nodeRef);
        for (QName aspect : aspects) {
            QName tempAspect = QName.createQName((String)aspect.toString());
            while (tempAspect != null) {
                AspectDefinition aspectDef;
                if (this.isCustomisable(tempAspect)) {
                    result.add(tempAspect);
                }
                if ((aspectDef = this.getDictionaryService().getAspect(tempAspect)) != null) {
                    tempAspect = aspectDef.getParentName();
                    continue;
                }
                tempAspect = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCustomMap() {
        this.customisableTypes = new HashMap<QName, QName>(7);
        Collection aspects = this.getDictionaryService().getAspects(RM_CUSTOM_MODEL);
        for (QName aspect : aspects) {
            AspectDefinition aspectDef = this.getDictionaryService().getAspect(aspect);
            String name = aspectDef.getName().getLocalName();
            if (!name.endsWith("Properties")) continue;
            QName type = null;
            String prefixString = aspectDef.getDescription((MessageLookup)this.getDictionaryService());
            if (prefixString == null) {
                if ("customRecordProperties".equals(name)) {
                    type = RecordsManagementModel.ASPECT_RECORD;
                } else if ("customRecordFolderProperties".equals(name)) {
                    type = RecordsManagementModel.TYPE_RECORD_FOLDER;
                } else if ("customRecordCategoryProperties".equals(name)) {
                    type = RecordsManagementModel.TYPE_RECORD_CATEGORY;
                } else if ("customRecordSeriesProperties".equals(name) && aspectDef.getProperties().size() != 0) {
                    type = CompatibilityModel.TYPE_RECORD_SERIES;
                }
            } else {
                type = QName.createQName((String)prefixString, (NamespacePrefixResolver)this.getNamespaceService());
            }
            if (type == null) continue;
            this.customisableTypes.put(type, aspect);
            if (this.pendingCustomisableTypes == null || !this.pendingCustomisableTypes.contains(type)) continue;
            this.pendingCustomisableTypes.remove(type);
        }
        if (this.pendingCustomisableTypes != null && this.pendingCustomisableTypes.size() != 0) {
            NodeRef modelRef = this.getCustomModelRef("http://www.alfresco.org/model/rmcustom/1.0");
            M2Model model = this.readCustomContentModel(modelRef);
            try {
                for (QName customisableType : this.pendingCustomisableTypes) {
                    QName customAspect = this.getCustomAspectImpl(customisableType);
                    M2Aspect aspect = model.createAspect(customAspect.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
                    aspect.setDescription(customisableType.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
                    this.customisableTypes.put(customisableType, customAspect);
                }
            }
            finally {
                this.writeCustomContentModel(modelRef, model);
            }
        }
        this.isCustomMapInit = true;
    }

    private Map<QName, QName> getCustomisableMap() {
        if (this.customisableTypes == null) {
            throw AlfrescoRuntimeException.create((String)"Customisable map has not been initialised correctly.", (Object[])new Object[0]);
        }
        return this.customisableTypes;
    }

    private QName getCustomAspect(QName customisableType) {
        Map<QName, QName> map = this.getCustomisableMap();
        QName result = map.get(customisableType);
        if (result == null) {
            result = this.getCustomAspectImpl(customisableType);
        }
        return result;
    }

    private QName getCustomAspectImpl(QName customisableType) {
        String localName = customisableType.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()).replace(":", "");
        localName = MessageFormat.format("{0}CustomProperties", localName);
        return QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)localName);
    }

    @Override
    public boolean isCustomisable(QName type) {
        ParameterCheck.mandatory((String)"type", (Object)type);
        return this.getCustomisable().contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeCustomisable(QName type) {
        ParameterCheck.mandatory((String)"type", (Object)type);
        if (this.customisableTypes == null) {
            this.pendingCustomisableTypes.add(type);
        } else {
            QName customAspect = this.getCustomAspect(type);
            if (this.getDictionaryService().getAspect(customAspect) == null) {
                NodeRef modelRef = this.getCustomModelRef(customAspect.getNamespaceURI());
                M2Model model = this.readCustomContentModel(modelRef);
                try {
                    M2Aspect aspect = model.createAspect(customAspect.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
                    aspect.setDescription(type.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
                }
                finally {
                    this.writeCustomContentModel(modelRef, model);
                }
                this.customisableTypes.put(type, customAspect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmakeCustomisable(QName type) {
        ParameterCheck.mandatory((String)"type", (Object)type);
        if (this.customisableTypes == null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_SERVICE_NOT_INIT));
        }
        QName customAspect = this.getCustomAspect(type);
        if (this.getDictionaryService().getAspect(customAspect) != null) {
            NodeRef modelRef = this.getCustomModelRef(customAspect.getNamespaceURI());
            M2Model model = this.readCustomContentModel(modelRef);
            try {
                model.removeAspect(customAspect.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
            }
            finally {
                this.writeCustomContentModel(modelRef, model);
            }
            this.customisableTypes.remove(type);
        }
    }

    @Override
    public boolean existsCustomProperty(QName propertyName) {
        ParameterCheck.mandatory((String)"propertyName", (Object)propertyName);
        boolean result = false;
        if ("http://www.alfresco.org/model/rmcustom/1.0".equals(propertyName.getNamespaceURI()) && this.getDictionaryService().getProperty(propertyName) != null) {
            result = true;
        }
        return result;
    }

    @Override
    public Map<QName, PropertyDefinition> getCustomPropertyDefinitions() {
        HashMap<QName, PropertyDefinition> result = new HashMap<QName, PropertyDefinition>();
        for (QName customisableType : this.getCustomisable()) {
            Map<QName, PropertyDefinition> props = this.getCustomPropertyDefinitions(customisableType);
            if (props == null) continue;
            result.putAll(props);
        }
        return result;
    }

    @Override
    public Map<QName, PropertyDefinition> getCustomPropertyDefinitions(QName customisableType) {
        ParameterCheck.mandatory((String)"customisableType", (Object)customisableType);
        Map propDefns = null;
        QName relevantAspectQName = this.getCustomAspect(customisableType);
        AspectDefinition aspectDefn = this.getDictionaryService().getAspect(relevantAspectQName);
        if (aspectDefn != null) {
            propDefns = aspectDefn.getProperties();
        }
        return propDefns;
    }

    @Override
    public QName addCustomPropertyDefinition(QName propId, QName aspectName, String label, QName dataType, String title, String description) throws CustomMetadataException {
        return this.addCustomPropertyDefinition(propId, aspectName, label, dataType, title, description, null, false, false, false, null);
    }

    @Override
    public QName addCustomPropertyDefinition(QName propId, QName aspectName, String label, QName dataType, String title, String description, String defaultValue, boolean multiValued, boolean mandatory, boolean isProtected, QName lovConstraint) throws CustomMetadataException {
        if (!this.isCustomisable(aspectName)) {
            throw new NotCustomisableMetadataException(aspectName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        }
        if (propId == null) {
            propId = this.generateQNameFor(label);
        }
        ParameterCheck.mandatory((String)"aspectName", (Object)aspectName);
        ParameterCheck.mandatory((String)"label", (Object)label);
        ParameterCheck.mandatory((String)"dataType", (Object)dataType);
        NodeRef modelRef = this.getCustomModelRef(propId.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        QName customAspect = this.getCustomAspect(aspectName);
        M2Aspect customPropsAspect = deserializedModel.getAspect(customAspect.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        if (customPropsAspect == null) {
            throw new InvalidCustomAspectMetadataException(customAspect, aspectName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        }
        String propIdAsString = propId.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        M2Property customProp = customPropsAspect.getProperty(propIdAsString);
        if (customProp != null) {
            throw new PropertyAlreadyExistsMetadataException(propIdAsString);
        }
        M2Property newProp = customPropsAspect.createProperty(propIdAsString);
        newProp.setName(propIdAsString);
        newProp.setType(dataType.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
        newProp.setTitle(label);
        newProp.setDescription(description);
        newProp.setDefaultValue(defaultValue);
        newProp.setMandatory(mandatory);
        newProp.setProtected(isProtected);
        newProp.setMultiValued(multiValued);
        newProp.setIndexed(true);
        newProp.setIndexedAtomically(true);
        newProp.setStoredInIndex(false);
        newProp.setIndexTokenisationMode(IndexTokenisationMode.FALSE);
        if (lovConstraint != null) {
            if (!dataType.equals((Object)DataTypeDefinition.TEXT)) {
                throw new CannotApplyConstraintMetadataException(lovConstraint, propIdAsString, dataType);
            }
            String lovConstraintQNameAsString = lovConstraint.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
            newProp.addConstraintRef(lovConstraintQNameAsString);
        }
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("addCustomPropertyDefinition: " + label + "=" + propIdAsString + " to aspect: " + aspectName));
        }
        return propId;
    }

    @Override
    public QName updateCustomPropertyDefinitionName(QName propQName, String newName) throws CustomMetadataException {
        PropertyDefinition newPropDefn;
        ParameterCheck.mandatory((String)"propQName", (Object)propQName);
        PropertyDefinition propDefn = this.getDictionaryService().getProperty(propQName);
        if (propDefn == null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PROP_EXIST, (Object[])new Object[]{propQName}));
        }
        if (newName == null) {
            return propQName;
        }
        QName newPropQName = this.getQNameForClientId(newName);
        if (newPropQName != null && (newPropDefn = this.getDictionaryService().getProperty(newPropQName)) != null && !propDefn.equals(newPropDefn)) {
            String propIdAsString = newPropQName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
            throw new PropertyAlreadyExistsMetadataException(propIdAsString);
        }
        NodeRef modelRef = this.getCustomModelRef(propQName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        M2Property targetProperty = this.findProperty(propQName, deserializedModel);
        targetProperty.setName("rmc" + ':' + newName);
        targetProperty.setTitle(URLDecoder.decode((String)newName));
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("setCustomPropertyDefinitionLabel: " + propQName + "=" + newName));
        }
        return propQName;
    }

    @Override
    public QName setCustomPropertyDefinitionLabel(QName propQName, String newLabel) {
        ParameterCheck.mandatory((String)"propQName", (Object)propQName);
        PropertyDefinition propDefn = this.getDictionaryService().getProperty(propQName);
        if (propDefn == null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PROP_EXIST, (Object[])new Object[]{propQName}));
        }
        if (newLabel == null) {
            return propQName;
        }
        NodeRef modelRef = this.getCustomModelRef(propQName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        M2Property targetProperty = this.findProperty(propQName, deserializedModel);
        targetProperty.setTitle(newLabel);
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("setCustomPropertyDefinitionLabel: " + propQName + "=" + newLabel));
        }
        return propQName;
    }

    @Override
    public QName setCustomPropertyDefinitionConstraint(QName propQName, QName newLovConstraint) {
        String refOfExistingConstraint;
        ParameterCheck.mandatory((String)"propQName", (Object)propQName);
        ParameterCheck.mandatory((String)"newLovConstraint", (Object)newLovConstraint);
        PropertyDefinition propDefn = this.getDictionaryService().getProperty(propQName);
        if (propDefn == null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PROP_EXIST, (Object[])new Object[]{propQName}));
        }
        NodeRef modelRef = this.getCustomModelRef(propQName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        M2Property targetProp = this.findProperty(propQName, deserializedModel);
        String dataType = targetProp.getType();
        if (!dataType.equals(DataTypeDefinition.TEXT.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()))) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)"rm.admin.cannot-apply-constraint", (Object[])new Object[]{newLovConstraint, targetProp.getName(), dataType}));
        }
        String lovConstraintQNameAsString = newLovConstraint.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        String string = refOfExistingConstraint = targetProp.getConstraints().isEmpty() ? null : ((M2Constraint)targetProp.getConstraints().get(0)).getRef();
        if (refOfExistingConstraint != null) {
            targetProp.removeConstraintRef(refOfExistingConstraint);
        }
        targetProp.addConstraintRef(lovConstraintQNameAsString);
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("addCustomPropertyDefinitionConstraint: " + lovConstraintQNameAsString));
        }
        return propQName;
    }

    @Override
    public QName removeCustomPropertyDefinitionConstraints(QName propQName) {
        ParameterCheck.mandatory((String)"propQName", (Object)propQName);
        PropertyDefinition propDefn = this.getDictionaryService().getProperty(propQName);
        if (propDefn == null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PROP_EXIST, (Object[])new Object[]{propQName}));
        }
        NodeRef modelRef = this.getCustomModelRef(propQName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        M2Property targetProperty = this.findProperty(propQName, deserializedModel);
        for (int i = targetProperty.getConstraints().size() - 1; i >= 0; --i) {
            String ref = ((M2Constraint)targetProperty.getConstraints().get(i)).getRef();
            targetProperty.removeConstraintRef(ref);
        }
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("removeCustomPropertyDefinitionConstraints: " + propQName));
        }
        return propQName;
    }

    private M2Property findProperty(QName propQName, M2Model deserializedModel) {
        List aspects = deserializedModel.getAspects();
        for (M2Aspect aspect : aspects) {
            for (M2Property prop : aspect.getProperties()) {
                if (!propQName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()).equals(prop.getName())) continue;
                return prop;
            }
        }
        throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CUSTOM_PROP_EXIST, (Object[])new Object[]{propQName}));
    }

    @Override
    public void removeCustomPropertyDefinition(QName propQName) {
        ParameterCheck.mandatory((String)"propQName", (Object)propQName);
        NodeRef modelRef = this.getCustomModelRef(propQName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        String propQNameAsString = propQName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        String aspectName = null;
        boolean found = false;
        for (QName customisableType : this.getCustomisable()) {
            aspectName = this.getCustomAspect(customisableType).toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
            M2Aspect customPropsAspect = deserializedModel.getAspect(aspectName);
            if (customPropsAspect == null) {
                throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_UNKNOWN_ASPECT, (Object[])new Object[]{aspectName}));
            }
            M2Property prop = customPropsAspect.getProperty(propQNameAsString);
            if (prop == null) continue;
            if (this.logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Attempting to delete custom property: ");
                msg.append(propQNameAsString);
                this.logger.debug((Object)msg.toString());
            }
            found = true;
            customPropsAspect.removeProperty(propQNameAsString);
            break;
        }
        if (!found) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_PROP_EXIST, (Object[])new Object[]{propQNameAsString}));
        }
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("deleteCustomPropertyDefinition: " + propQNameAsString + " from aspect: " + aspectName));
        }
    }

    @Override
    public Map<QName, AssociationDefinition> getCustomReferenceDefinitions() {
        return this.getCustomAssociations();
    }

    @Override
    public void addCustomReference(NodeRef fromNode, NodeRef toNode, QName refId) {
        ParameterCheck.mandatory((String)"fromNode", (Object)fromNode);
        ParameterCheck.mandatory((String)"toNode", (Object)toNode);
        ParameterCheck.mandatory((String)"refId", (Object)refId);
        this.getRelationshipService().addRelationship(refId.getLocalName(), fromNode, toNode);
    }

    @Override
    public void removeCustomReference(NodeRef fromNode, NodeRef toNode, QName assocId) {
        ParameterCheck.mandatory((String)"fromNode", (Object)fromNode);
        ParameterCheck.mandatory((String)"toNode", (Object)toNode);
        ParameterCheck.mandatory((String)"assocId", (Object)assocId);
        this.getRelationshipService().removeRelationship(assocId.getLocalName(), fromNode, toNode);
    }

    @Override
    public List<AssociationRef> getCustomReferencesFrom(NodeRef node) {
        ParameterCheck.mandatory((String)"node", (Object)node);
        return this.getNodeService().getTargetAssocs(node, RegexQNamePattern.MATCH_ALL);
    }

    @Override
    public List<ChildAssociationRef> getCustomChildReferences(NodeRef node) {
        ParameterCheck.mandatory((String)"node", (Object)node);
        return this.getNodeService().getChildAssocs(node);
    }

    @Override
    public List<AssociationRef> getCustomReferencesTo(NodeRef node) {
        ParameterCheck.mandatory((String)"node", (Object)node);
        return this.getNodeService().getSourceAssocs(node, RegexQNamePattern.MATCH_ALL);
    }

    @Override
    public List<ChildAssociationRef> getCustomParentReferences(NodeRef node) {
        ParameterCheck.mandatory((String)"node", (Object)node);
        return this.getNodeService().getParentAssocs(node);
    }

    @Override
    public QName addCustomAssocDefinition(String label) {
        ParameterCheck.mandatoryString((String)"label", (String)label);
        return this.addCustomChildAssocDefinition(label, label);
    }

    @Override
    public QName addCustomChildAssocDefinition(String source, String target) {
        ParameterCheck.mandatoryString((String)"source", (String)source);
        ParameterCheck.mandatoryString((String)"target", (String)target);
        RelationshipDisplayName displayName = new RelationshipDisplayName(source, target);
        RelationshipDefinition relationshipDefinition = this.getRelationshipService().createRelationshipDefinition(displayName);
        return QName.createQName((String)"rmc", (String)relationshipDefinition.getUniqueName(), (NamespacePrefixResolver)this.getNamespaceService());
    }

    @Override
    public QName updateCustomChildAssocDefinition(QName refQName, String newSource, String newTarget) {
        ParameterCheck.mandatory((String)"refQName", (Object)refQName);
        ParameterCheck.mandatoryString((String)"newSource", (String)newSource);
        ParameterCheck.mandatoryString((String)"newTarget", (String)newTarget);
        RelationshipDisplayName displayName = new RelationshipDisplayName(newSource, newTarget);
        String localName = refQName.getLocalName();
        RelationshipDefinition relationshipDefinition = this.getRelationshipService().updateRelationshipDefinition(localName, displayName);
        return QName.createQName((String)"rmc", (String)relationshipDefinition.getUniqueName(), (NamespacePrefixResolver)this.getNamespaceService());
    }

    @Override
    public QName updateCustomAssocDefinition(QName refQName, String newLabel) {
        ParameterCheck.mandatory((String)"refQName", (Object)refQName);
        ParameterCheck.mandatoryString((String)"newLabel", (String)newLabel);
        return this.updateCustomChildAssocDefinition(refQName, newLabel, newLabel);
    }

    @Override
    public void addCustomConstraintDefinition(QName constraintName, String title, boolean caseSensitive, List<String> allowedValues, RMListOfValuesConstraint.MatchLogic matchLogic) {
        ParameterCheck.mandatory((String)"constraintName", (Object)constraintName);
        ParameterCheck.mandatoryString((String)"title", (String)title);
        ParameterCheck.mandatory((String)PARAM_ALLOWED_VALUES, allowedValues);
        ParameterCheck.mandatory((String)PARAM_MATCH_LOGIC, (Object)((Object)matchLogic));
        NodeRef modelRef = this.getCustomModelRef(constraintName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        String constraintNameAsPrefixString = constraintName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        M2Constraint customConstraint = deserializedModel.getConstraint(constraintNameAsPrefixString);
        if (customConstraint != null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CONSTRAINT_EXISTS, (Object[])new Object[]{constraintNameAsPrefixString}));
        }
        M2Constraint newCon = deserializedModel.createConstraint(constraintNameAsPrefixString, CUSTOM_CONSTRAINT_TYPE);
        newCon.setTitle(title);
        newCon.createParameter(PARAM_ALLOWED_VALUES, allowedValues);
        newCon.createParameter(PARAM_CASE_SENSITIVE, caseSensitive ? "true" : "false");
        newCon.createParameter(PARAM_MATCH_LOGIC, matchLogic.toString());
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("addCustomConstraintDefinition: " + constraintNameAsPrefixString + " (valueCnt: " + allowedValues.size() + ")"));
        }
    }

    @Override
    public void changeCustomConstraintValues(QName constraintName, List<String> newAllowedValues) {
        ParameterCheck.mandatory((String)"constraintName", (Object)constraintName);
        ParameterCheck.mandatory((String)"newAllowedValues", newAllowedValues);
        NodeRef modelRef = this.getCustomModelRef(constraintName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        String constraintNameAsPrefixString = constraintName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        M2Constraint customConstraint = deserializedModel.getConstraint(constraintNameAsPrefixString);
        if (customConstraint == null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CANNOT_FIND_CONSTRAINT, (Object[])new Object[]{constraintNameAsPrefixString}));
        }
        String type = customConstraint.getType();
        if (type == null || !type.equals(CUSTOM_CONSTRAINT_TYPE) && !type.equals(CAPABILITY_CUSTOM_CONSTRAINT_TYPE)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_UNEXPECTED_TYPE_CONSTRAINT, (Object[])new Object[]{type, constraintNameAsPrefixString, CUSTOM_CONSTRAINT_TYPE}));
        }
        customConstraint.removeParameter(PARAM_ALLOWED_VALUES);
        customConstraint.createParameter(PARAM_ALLOWED_VALUES, newAllowedValues);
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("changeCustomConstraintValues: " + constraintNameAsPrefixString + " (valueCnt: " + newAllowedValues.size() + ")"));
        }
    }

    @Override
    public void changeCustomConstraintTitle(QName constraintName, String title) {
        ParameterCheck.mandatory((String)"constraintName", (Object)constraintName);
        ParameterCheck.mandatoryString((String)"title", (String)title);
        NodeRef modelRef = this.getCustomModelRef(constraintName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        String constraintNameAsPrefixString = constraintName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        M2Constraint customConstraint = deserializedModel.getConstraint(constraintNameAsPrefixString);
        if (customConstraint == null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CANNOT_FIND_CONSTRAINT, (Object[])new Object[]{constraintNameAsPrefixString}));
        }
        String type = customConstraint.getType();
        if (type == null || !type.equals(CUSTOM_CONSTRAINT_TYPE)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_UNEXPECTED_TYPE_CONSTRAINT, (Object[])new Object[]{type, constraintNameAsPrefixString, CUSTOM_CONSTRAINT_TYPE}));
        }
        customConstraint.setTitle(title);
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("changeCustomConstraintTitle: " + constraintNameAsPrefixString + " (title: " + title + ")"));
        }
    }

    @Override
    public List<ConstraintDefinition> getCustomConstraintDefinitions(QName modelQName) {
        ParameterCheck.mandatory((String)"modelQName", (Object)modelQName);
        Collection conDefs = this.getDictionaryService().getConstraints(modelQName, true);
        for (ConstraintDefinition conDef : conDefs) {
            Constraint con = conDef.getConstraint();
            if (con instanceof org.alfresco.module.org_alfresco_module_rm.caveat.RMListOfValuesConstraint) continue;
            conDefs.remove(conDef);
        }
        return new ArrayList<ConstraintDefinition>(conDefs);
    }

    @Override
    public void removeCustomConstraintDefinition(QName constraintName) {
        ParameterCheck.mandatory((String)"constraintName", (Object)constraintName);
        NodeRef modelRef = this.getCustomModelRef(constraintName.getNamespaceURI());
        M2Model deserializedModel = this.readCustomContentModel(modelRef);
        String constraintNameAsPrefixString = constraintName.toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
        M2Constraint customConstraint = deserializedModel.getConstraint(constraintNameAsPrefixString);
        if (customConstraint == null) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CANNOT_FIND_CONSTRAINT, (Object[])new Object[]{constraintNameAsPrefixString}));
        }
        deserializedModel.removeConstraint(constraintNameAsPrefixString);
        this.writeCustomContentModel(modelRef, deserializedModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("deleteCustomConstraintDefinition: " + constraintNameAsPrefixString));
        }
    }

    @Override
    public QName getQNameForClientId(String localName) {
        QName propertyResult = null;
        for (QName qn : this.getCustomPropertyDefinitions().keySet()) {
            if (localName == null || !localName.equals(qn.getLocalName())) continue;
            propertyResult = qn;
        }
        if (propertyResult != null) {
            return propertyResult;
        }
        QName referenceResult = null;
        for (QName refQn : this.getCustomReferenceDefinitions().keySet()) {
            if (localName == null || !localName.equals(refQn.getLocalName())) continue;
            referenceResult = refQn;
        }
        return referenceResult;
    }

    private QName generateQNameFor(String clientId) {
        if (this.getQNameForClientId(clientId) != null) {
            throw new IllegalArgumentException(I18NUtil.getMessage((String)MSG_ERROR_CLIENT_ID, (Object[])new Object[]{clientId}));
        }
        String newGUID = GUID.generate();
        QName newQName = QName.createQName((String)"rmc", (String)newGUID, (NamespacePrefixResolver)this.getNamespaceService());
        return newQName;
    }

    @Override
    public String[] splitSourceTargetId(String sourceTargetId) {
        ParameterCheck.mandatoryString((String)"sourceTargetId", (String)sourceTargetId);
        return this.splitAssociationDefinitionTitle(sourceTargetId);
    }

    @Override
    public String getCompoundIdFor(String sourceId, String targetId) {
        ParameterCheck.mandatoryString((String)"sourceId", (String)sourceId);
        ParameterCheck.mandatoryString((String)"targetId", (String)targetId);
        return this.composeAssociationDefinitionTitle(sourceId, targetId);
    }
}

