/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BroadcastDispositionActionDefinitionUpdateAction
extends RMActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(BroadcastDispositionActionDefinitionUpdateAction.class);
    public static final String NAME = "broadcastDispositionActionDefinitionUpdate";
    public static final String CHANGED_PROPERTIES = "changedProperties";
    private BehaviourFilter behaviourFilter;

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (!RecordsManagementModel.TYPE_DISPOSITION_ACTION_DEFINITION.equals((Object)this.getNodeService().getType(actionedUponNodeRef))) {
            return;
        }
        List changedProps = (List)((Object)action.getParameterValue(CHANGED_PROPERTIES));
        NodeRef dispositionScheduleNode = this.getNodeService().getPrimaryParent(actionedUponNodeRef).getParentRef();
        NodeRef rmContainer = this.getNodeService().getPrimaryParent(dispositionScheduleNode).getParentRef();
        DispositionSchedule dispositionSchedule = this.getDispositionService().getAssociatedDispositionSchedule(rmContainer);
        this.behaviourFilter.disableBehaviour();
        try {
            List<NodeRef> disposableItems = this.getDispositionService().getDisposableItems(dispositionSchedule);
            for (NodeRef disposableItem : disposableItems) {
                this.updateDisposableItem(dispositionSchedule, disposableItem, actionedUponNodeRef, changedProps);
            }
        }
        finally {
            this.behaviourFilter.enableBehaviour();
        }
    }

    private void updateDisposableItem(DispositionSchedule ds, NodeRef disposableItem, NodeRef dispositionActionDefinition, List<QName> changedProps) {
        DispositionSchedule itemDs = this.getDispositionService().getDispositionSchedule(disposableItem);
        if (itemDs != null && itemDs.getNodeRef().equals((Object)ds.getNodeRef())) {
            if (this.getNodeService().hasAspect(disposableItem, ASPECT_DISPOSITION_LIFECYCLE)) {
                this.processActionDefinitionChanges(dispositionActionDefinition, changedProps, disposableItem);
            } else {
                this.getDispositionService().updateNextDispositionAction(disposableItem);
            }
            this.rollupSearchProperties(disposableItem);
        }
    }

    private void rollupSearchProperties(NodeRef disposableItem) {
        DispositionAction da = this.getDispositionService().getNextDispositionAction(disposableItem);
        if (da != null) {
            Map props = this.getNodeService().getProperties(disposableItem);
            props.put(PROP_RS_DISPOSITION_ACTION_NAME, da.getName());
            props.put(PROP_RS_DISPOSITION_ACTION_AS_OF, da.getAsOfDate());
            props.put(PROP_RS_DISPOSITION_EVENTS_ELIGIBLE, this.getNodeService().getProperty(da.getNodeRef(), PROP_DISPOSITION_EVENTS_ELIGIBLE));
            DispositionActionDefinition daDefinition = da.getDispositionActionDefinition();
            Period period = daDefinition.getPeriod();
            if (period != null) {
                props.put(PROP_RS_DISPOSITION_PERIOD, period.getPeriodType());
                props.put(PROP_RS_DISPOSITION_PERIOD_EXPRESSION, period.getExpression());
            } else {
                props.put(PROP_RS_DISPOSITION_PERIOD, null);
                props.put(PROP_RS_DISPOSITION_PERIOD_EXPRESSION, null);
            }
            List<EventCompletionDetails> events = da.getEventCompletionDetails();
            ArrayList<String> list = new ArrayList<String>(events.size());
            for (EventCompletionDetails event : events) {
                list.add(event.getEventName());
            }
            props.put(PROP_RS_DISPOSITION_EVENTS, (Serializable)list);
            this.getNodeService().setProperties(disposableItem, props);
        }
    }

    private void processActionDefinitionChanges(NodeRef dispositionActionDef, List<QName> changedProps, NodeRef recordOrFolder) {
        DispositionAction nextAction = this.getDispositionService().getNextDispositionAction(recordOrFolder);
        if (this.doesChangedStepAffectNextAction(dispositionActionDef, nextAction)) {
            if ((changedProps.contains(PROP_DISPOSITION_PERIOD) || changedProps.contains(PROP_DISPOSITION_PERIOD_PROPERTY)) && BooleanUtils.isNotTrue((Boolean)((Boolean)this.getNodeService().getProperty(nextAction.getNodeRef(), PROP_MANUALLY_SET_AS_OF)))) {
                this.persistPeriodChanges(dispositionActionDef, nextAction);
            }
            if (changedProps.contains(PROP_DISPOSITION_EVENT) || changedProps.contains(PROP_DISPOSITION_EVENT_COMBINATION)) {
                nextAction.refreshEvents();
            }
            if (changedProps.contains(PROP_DISPOSITION_ACTION_NAME)) {
                String action = (String)((Object)this.getNodeService().getProperty(dispositionActionDef, PROP_DISPOSITION_ACTION_NAME));
                this.getNodeService().setProperty(nextAction.getNodeRef(), PROP_DISPOSITION_ACTION, (Serializable)((Object)action));
            }
        }
    }

    private boolean doesChangedStepAffectNextAction(NodeRef dispositionActionDef, DispositionAction nextAction) {
        boolean affectsNextAction = false;
        if (dispositionActionDef != null && nextAction != null) {
            String nextActionId = nextAction.getId();
            if (dispositionActionDef.getId().equals(nextActionId)) {
                affectsNextAction = true;
            }
        }
        return affectsNextAction;
    }

    protected void persistPeriodChanges(NodeRef dispositionActionDef, DispositionAction nextAction) {
        NodeRef dispositionedNode = this.getNodeService().getPrimaryParent(nextAction.getNodeRef()).getParentRef();
        DispositionActionDefinition definition = nextAction.getDispositionActionDefinition();
        Date newAsOfDate = this.getDispositionService().calculateAsOfDate(dispositionedNode, definition);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set disposition as of date for next action '" + nextAction.getName() + "' (" + nextAction.getNodeRef() + ") to: " + newAsOfDate));
        }
        this.getNodeService().setProperty(nextAction.getNodeRef(), PROP_DISPOSITION_AS_OF, (Serializable)newAsOfDate);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

