/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.gateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.alfresco.gateway.model.Filter;
import org.springframework.validation.annotation.Validated;

@Validated
public class Subscription {
    @JsonProperty(value="createdDate")
    private Long createdDate = null;
    @JsonProperty(value="modifiedDate")
    private Long modifiedDate = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="user")
    private String user = null;
    @JsonProperty(value="config")
    @Valid
    private Map<String, String> config = null;
    @JsonProperty(value="filters")
    @Valid
    private List<Filter> filters = null;

    public Subscription createdDate(Long createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public Subscription modifiedDate(Long modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Long modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Subscription id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Subscription status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Subscription type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Subscription user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Subscription config(Map<String, String> config) {
        this.config = config;
        return this;
    }

    public Subscription putConfigItem(String key, String configItem) {
        if (this.config == null) {
            this.config = new HashMap<String, String>();
        }
        this.config.put(key, configItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Subscription filters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public Subscription addFiltersItem(Filter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription subscription = (Subscription)o;
        return Objects.equals(this.createdDate, subscription.createdDate) && Objects.equals(this.modifiedDate, subscription.modifiedDate) && Objects.equals(this.id, subscription.id) && Objects.equals((Object)this.status, (Object)subscription.status) && Objects.equals(this.type, subscription.type) && Objects.equals(this.user, subscription.user) && Objects.equals(this.config, subscription.config) && Objects.equals(this.filters, subscription.filters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdDate, this.modifiedDate, this.id, this.status, this.type, this.user, this.config, this.filters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subscription {\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

