/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.gateway.handler;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.validation.Valid;
import org.alfresco.gateway.model.Subscription;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="Subscriptions")
public interface SubscriptionsApi {
    @ApiOperation(value="", nickname="createSubscription", notes="Create a Subscription", response=Subscription.class, authorizations={@Authorization(value="basic-auth"), @Authorization(value="bearer-key")}, tags={"subscriptions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=Subscription.class), @ApiResponse(code=422, message="Invalid subscription or filter configuration"), @ApiResponse(code=400, message="Invalid subscription format or unsupported subscription or filter type"), @ApiResponse(code=401, message="Invalid authentication provided"), @ApiResponse(code=403, message="User not authorized to perform the operation"), @ApiResponse(code=500, message="Uncategorized server error")})
    @RequestMapping(value={"/subscriptions"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Subscription> createSubscription(@ApiParam(value="The subscription object to be created") @Valid @RequestBody Subscription var1);

    @ApiOperation(value="", nickname="getSubscription", notes="Get a Subscription by its id", response=Subscription.class, authorizations={@Authorization(value="basic-auth"), @Authorization(value="bearer-key")}, tags={"subscriptions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=Subscription.class), @ApiResponse(code=404, message="Subscription not found"), @ApiResponse(code=401, message="Invalid authentication provided"), @ApiResponse(code=403, message="User not authorized to perform the operation"), @ApiResponse(code=500, message="Uncategorized server error")})
    @RequestMapping(value={"/subscriptions/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Subscription> getSubscription(@ApiParam(value="The subscription id", required=true) @PathVariable(value="id") String var1);

    @ApiOperation(value="", nickname="partiallyUpdateSubscription", notes="Update the status of a Subscription", response=Subscription.class, authorizations={@Authorization(value="basic-auth"), @Authorization(value="bearer-key")}, tags={"subscriptions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=Subscription.class), @ApiResponse(code=400, message="Invalid request format"), @ApiResponse(code=422, message="Invalid request attributes"), @ApiResponse(code=401, message="Invalid authentication provided"), @ApiResponse(code=403, message="User not authorized to perform the operation"), @ApiResponse(code=500, message="Uncategorized server error")})
    @RequestMapping(value={"/subscriptions/{id}"}, produces={"application/json"}, consumes={"application/merge-patch+json"}, method={RequestMethod.PATCH})
    public ResponseEntity<Subscription> partiallyUpdateSubscription(@ApiParam(value="The subscription id", required=true) @PathVariable(value="id") String var1, @ApiParam(value="The JSON snippet holding the new status of the subscription") @Valid @RequestBody JsonNode var2);
}

