/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.BasicSearchParameters;
import org.alfresco.service.cmr.search.GeneralHighlightParameters;
import org.alfresco.service.cmr.search.IntervalParameters;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.RangeParameters;
import org.alfresco.service.cmr.search.StatsRequestParameters;
import org.springframework.extensions.surf.util.I18NUtil;

@AlfrescoPublicApi
public class SearchParameters
implements BasicSearchParameters {
    private static int DEFAULT_LIMIT = 500;
    public static final SortDefinition SORT_IN_DOCUMENT_ORDER_ASCENDING = new SortDefinition(SortDefinition.SortType.DOCUMENT, null, true);
    public static final SortDefinition SORT_IN_DOCUMENT_ORDER_DESCENDING = new SortDefinition(SortDefinition.SortType.DOCUMENT, null, false);
    public static final SortDefinition SORT_IN_SCORE_ORDER_ASCENDING = new SortDefinition(SortDefinition.SortType.SCORE, null, true);
    public static final SortDefinition SORT_IN_SCORE_ORDER_DESCENDING = new SortDefinition(SortDefinition.SortType.SCORE, null, false);
    public static final Operator OR = Operator.OR;
    public static final Operator AND = Operator.AND;
    public static final String ALTERNATIVE_DICTIONARY = "alternativeDic";
    private String language;
    private String query;
    private ArrayList<StoreRef> stores = new ArrayList(1);
    private ArrayList<QueryParameterDefinition> queryParameterDefinitions = new ArrayList(1);
    private boolean excludeDataInTheCurrentTransaction = false;
    private ArrayList<SortDefinition> sortDefinitions = new ArrayList(1);
    private ArrayList<Locale> locales = new ArrayList();
    private MLAnalysisMode mlAnalaysisMode = null;
    private LimitBy limitBy = LimitBy.UNLIMITED;
    private PermissionEvaluationMode permissionEvaluation = PermissionEvaluationMode.EAGER;
    private int limit = DEFAULT_LIMIT;
    private HashSet<String> allAttributes = new HashSet();
    private HashSet<String> textAttributes = new HashSet();
    private int maxItems = -1;
    private int skipCount = 0;
    private Operator defaultFTSOperator = Operator.OR;
    private Operator defaultFTSFieldOperator = Operator.OR;
    private Map<String, String> queryTemplates = new HashMap<String, String>();
    private String namespace = "http://www.alfresco.org/model/content/1.0";
    private int maxPermissionChecks = -1;
    private long maxPermissionCheckTimeMillis = -1L;
    private String defaultFieldName = "TEXT";
    private ArrayList<FieldFacet> fieldFacets = new ArrayList();
    private List<String> facetQueries = new ArrayList<String>();
    private List<String> filterQueries = new ArrayList<String>();
    private List<List<String>> pivots = new ArrayList<List<String>>();
    private Boolean useInMemorySort;
    private Integer maxRawResultSetSizeForInMemorySort;
    private Map<String, String> extraParameters = new HashMap<String, String>();
    private boolean excludeTenantFilter = false;
    private boolean isBulkFetchEnabled = true;
    private QueryConsistency queryConsistency = QueryConsistency.DEFAULT;
    private Long sinceTxId;
    private String searchTerm;
    private boolean spellCheck;
    private GeneralHighlightParameters highlight;
    private IntervalParameters interval;
    private List<StatsRequestParameters> stats;
    private List<RangeParameters> ranges;
    private boolean includeMetadata;
    private String timezone;

    public SearchParameters() {
    }

    public SearchParameters copy() {
        SearchParameters sp = new SearchParameters();
        sp.allAttributes.addAll(this.allAttributes);
        sp.defaultFieldName = this.defaultFieldName;
        sp.defaultFTSFieldOperator = this.defaultFTSFieldOperator;
        sp.defaultFTSOperator = this.defaultFTSOperator;
        sp.excludeDataInTheCurrentTransaction = this.excludeDataInTheCurrentTransaction;
        sp.fieldFacets.addAll(this.fieldFacets);
        sp.language = this.language;
        sp.limit = this.limit;
        sp.limitBy = this.limitBy;
        sp.locales.addAll(this.locales);
        sp.maxItems = this.maxItems;
        sp.maxPermissionChecks = this.maxPermissionChecks;
        sp.maxPermissionCheckTimeMillis = this.maxPermissionCheckTimeMillis;
        sp.mlAnalaysisMode = this.mlAnalaysisMode;
        sp.namespace = this.namespace;
        sp.permissionEvaluation = this.permissionEvaluation;
        sp.query = this.query;
        sp.queryParameterDefinitions.addAll(this.queryParameterDefinitions);
        sp.queryTemplates.putAll(this.queryTemplates);
        sp.skipCount = this.skipCount;
        sp.sortDefinitions.addAll(this.sortDefinitions);
        sp.stores.addAll(this.stores);
        sp.textAttributes.addAll(this.textAttributes);
        sp.useInMemorySort = this.useInMemorySort;
        sp.maxRawResultSetSizeForInMemorySort = this.maxRawResultSetSizeForInMemorySort;
        sp.isBulkFetchEnabled = this.isBulkFetchEnabled;
        sp.excludeTenantFilter = this.excludeTenantFilter;
        sp.queryConsistency = this.queryConsistency;
        sp.sinceTxId = this.sinceTxId;
        sp.facetQueries.addAll(this.facetQueries);
        sp.filterQueries.addAll(this.filterQueries);
        sp.pivots.addAll(this.pivots);
        sp.searchTerm = this.searchTerm;
        sp.spellCheck = this.spellCheck;
        sp.highlight = this.highlight;
        sp.interval = this.interval;
        sp.stats = this.stats;
        sp.ranges = this.ranges;
        sp.timezone = this.timezone;
        return sp;
    }

    public SearchParameters(QueryOptions options) {
        this.setSkipCount(options.getSkipCount());
        this.setMaxPermissionChecks(options.getMaxPermissionChecks());
        this.setMaxPermissionCheckTimeMillis(options.getMaxPermissionCheckTimeMillis());
        this.setBulkFetchEnabled(options.isBulkFetchEnabled());
        if (options.getMaxItems() >= 0) {
            this.setLimitBy(LimitBy.FINAL_SIZE);
            this.setLimit(options.getMaxItems());
            this.setMaxItems(options.getMaxItems());
        } else {
            this.setLimitBy(LimitBy.UNLIMITED);
        }
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public void setHighlight(GeneralHighlightParameters highlight) {
        this.highlight = highlight;
    }

    public List<StatsRequestParameters> getStats() {
        return this.stats;
    }

    public void setStats(List<StatsRequestParameters> stats) {
        this.stats = stats;
    }

    public IntervalParameters getInterval() {
        return this.interval;
    }

    public void setInterval(IntervalParameters interval) {
        this.interval = interval;
    }

    public List<RangeParameters> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<RangeParameters> ranges) {
        this.ranges = ranges;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void addExtraParameter(String name, String value) {
        this.extraParameters.put(name, value);
    }

    public Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void addStore(StoreRef store) {
        this.stores.add(store);
    }

    public void addQueryParameterDefinition(QueryParameterDefinition queryParameterDefinition) {
        this.queryParameterDefinitions.add(queryParameterDefinition);
    }

    public void excludeDataInTheCurrentTransaction(boolean excludeDataInTheCurrentTransaction) {
        this.excludeDataInTheCurrentTransaction = excludeDataInTheCurrentTransaction;
    }

    public void addSort(String field, boolean ascending) {
        this.addSort(new SortDefinition(SortDefinition.SortType.FIELD, field, ascending));
    }

    public void addSort(SortDefinition sortDefinition) {
        this.sortDefinitions.add(sortDefinition);
    }

    public GeneralHighlightParameters getHighlight() {
        return this.highlight;
    }

    public boolean excludeDataInTheCurrentTransaction() {
        return this.excludeDataInTheCurrentTransaction;
    }

    public ArrayList<QueryParameterDefinition> getQueryParameterDefinitions() {
        return this.queryParameterDefinitions;
    }

    public ArrayList<SortDefinition> getSortDefinitions() {
        return this.sortDefinitions;
    }

    public ArrayList<StoreRef> getStores() {
        return this.stores;
    }

    public void setDefaultOperator(Operator defaultOperator) {
        this.defaultFTSOperator = defaultOperator;
        this.defaultFTSFieldOperator = defaultOperator;
    }

    public Operator getDefaultOperator() {
        return this.getDefaultFTSOperator();
    }

    public LimitBy getLimitBy() {
        return this.limitBy;
    }

    public void setLimitBy(LimitBy limitBy) {
        this.limitBy = limitBy;
    }

    public PermissionEvaluationMode getPermissionEvaluation() {
        return this.permissionEvaluation;
    }

    public void setPermissionEvaluation(PermissionEvaluationMode permissionEvaluation) {
        this.permissionEvaluation = permissionEvaluation;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public MLAnalysisMode getMlAnalaysisMode() {
        return this.mlAnalaysisMode;
    }

    public void setMlAnalaysisMode(MLAnalysisMode mlAnalaysisMode) {
        this.mlAnalaysisMode = mlAnalaysisMode;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    @Override
    public List<Locale> getLocales() {
        return Collections.unmodifiableList(this.locales);
    }

    public void addTextAttribute(String attribute) {
        this.textAttributes.add(attribute);
    }

    public Set<String> getTextAttributes() {
        return Collections.unmodifiableSet(this.textAttributes);
    }

    public void addAllAttribute(String attribute) {
        this.allAttributes.add(attribute);
    }

    public Set<String> getAllAttributes() {
        return Collections.unmodifiableSet(this.allAttributes);
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(int skipCount) {
        this.skipCount = skipCount;
    }

    public Operator getDefaultFTSOperator() {
        return this.defaultFTSOperator;
    }

    public void setDefaultFTSOperator(Operator defaultFTSOperator) {
        this.defaultFTSOperator = defaultFTSOperator;
    }

    public Operator getDefaultFTSFieldOperator() {
        return this.defaultFTSFieldOperator;
    }

    public void setDefaultFTSFieldConnective(Operator defaultFTSFieldOperator) {
        this.defaultFTSFieldOperator = defaultFTSFieldOperator;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, String> getQueryTemplates() {
        return this.queryTemplates;
    }

    public String addQueryTemplate(String name, String template) {
        return this.queryTemplates.put(name, template);
    }

    public long getMaxPermissionCheckTimeMillis() {
        return this.maxPermissionCheckTimeMillis;
    }

    public void setMaxPermissionCheckTimeMillis(long maxPermissionCheckTimeMillis) {
        this.maxPermissionCheckTimeMillis = maxPermissionCheckTimeMillis;
    }

    public int getMaxPermissionChecks() {
        return this.maxPermissionChecks;
    }

    public void setMaxPermissionChecks(int maxPermissionChecks) {
        this.maxPermissionChecks = maxPermissionChecks;
    }

    public Boolean getUseInMemorySort() {
        return this.useInMemorySort;
    }

    public void setUseInMemorySort(Boolean useInMemorySort) {
        this.useInMemorySort = useInMemorySort;
    }

    public Integer getMaxRawResultSetSizeForInMemorySort() {
        return this.maxRawResultSetSizeForInMemorySort;
    }

    public void setMaxRawResultSetSizeForInMemorySort(Integer maxRawResultSetSizeForInMemorySort) {
        this.maxRawResultSetSizeForInMemorySort = maxRawResultSetSizeForInMemorySort;
    }

    public boolean isBulkFetchEnabled() {
        return this.isBulkFetchEnabled;
    }

    public void setBulkFetchEnabled(boolean isBulkFetchEnabled) {
        this.isBulkFetchEnabled = isBulkFetchEnabled;
    }

    public String getDefaultFieldName() {
        return this.defaultFieldName;
    }

    public void setDefaultFieldName(String defaultFieldName) {
        this.defaultFieldName = defaultFieldName;
    }

    public List<FieldFacet> getFieldFacets() {
        return this.fieldFacets;
    }

    public void addFieldFacet(FieldFacet fieldFacet) {
        this.fieldFacets.add(fieldFacet);
    }

    public List<String> getFacetQueries() {
        return this.facetQueries;
    }

    public void addFacetQuery(String facetQuery) {
        this.facetQueries.add(facetQuery);
    }

    public List<String> getFilterQueries() {
        return this.filterQueries;
    }

    public void addFilterQuery(String filterQuery) {
        this.filterQueries.add(filterQuery);
    }

    public List<List<String>> getPivots() {
        return this.pivots;
    }

    public void addPivots(List<String> pivotFields) {
        this.pivots.add(pivotFields);
    }

    public Locale getSortLocale() {
        List<Locale> locales = this.getLocales();
        if (locales == null || locales.size() == 0) {
            locales = Collections.singletonList(I18NUtil.getLocale());
        }
        if (locales.size() > 1) {
            throw new AlfrescoRuntimeException("Order on text/mltext properties with more than one locale is not curently supported");
        }
        Locale sortLocale = locales.get(0);
        return sortLocale;
    }

    public void setExcludeTenantFilter(boolean excludeTenantFilter) {
        this.excludeTenantFilter = excludeTenantFilter;
    }

    public boolean getExcludeTenantFilter() {
        return this.excludeTenantFilter;
    }

    public void setQueryConsistency(QueryConsistency queryConsistency) {
        this.queryConsistency = queryConsistency;
    }

    public QueryConsistency getQueryConsistency() {
        return this.queryConsistency;
    }

    public Long getSinceTxId() {
        return this.sinceTxId;
    }

    public void setSinceTxId(Long sinceTxId) {
        this.sinceTxId = sinceTxId;
    }

    public String getSearchTerm() {
        if (this.searchTerm == null || this.searchTerm.length() == 0) {
            return this.getQuery();
        }
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public boolean isSpellCheck() {
        return this.spellCheck;
    }

    public boolean hasFaceting() {
        if (this.facetQueries != null && !this.facetQueries.isEmpty()) {
            return true;
        }
        if (this.fieldFacets != null && !this.fieldFacets.isEmpty()) {
            return true;
        }
        if (this.interval != null) {
            return true;
        }
        if (this.pivots != null && !this.pivots.isEmpty()) {
            return true;
        }
        if (this.ranges != null) {
            return true;
        }
        return this.stats != null && !this.stats.isEmpty();
    }

    public void setSpellCheck(boolean spellCheck) {
        this.spellCheck = spellCheck;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allAttributes == null ? 0 : this.allAttributes.hashCode());
        result = 31 * result + (this.defaultFTSFieldOperator == null ? 0 : this.defaultFTSFieldOperator.hashCode());
        result = 31 * result + (this.defaultFTSOperator == null ? 0 : this.defaultFTSOperator.hashCode());
        result = 31 * result + (this.defaultFieldName == null ? 0 : this.defaultFieldName.hashCode());
        result = 31 * result + (this.excludeDataInTheCurrentTransaction ? 1231 : 1237);
        result = 31 * result + (this.excludeTenantFilter ? 1231 : 1237);
        result = 31 * result + (this.fieldFacets == null ? 0 : this.fieldFacets.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + this.limit;
        result = 31 * result + (this.limitBy == null ? 0 : this.limitBy.hashCode());
        result = 31 * result + (this.locales == null ? 0 : this.locales.hashCode());
        result = 31 * result + this.maxItems;
        result = 31 * result + (int)(this.maxPermissionCheckTimeMillis ^ this.maxPermissionCheckTimeMillis >>> 32);
        result = 31 * result + this.maxPermissionChecks;
        result = 31 * result + (this.maxRawResultSetSizeForInMemorySort == null ? 0 : this.maxRawResultSetSizeForInMemorySort.hashCode());
        result = 31 * result + (this.mlAnalaysisMode == null ? 0 : this.mlAnalaysisMode.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.permissionEvaluation == null ? 0 : this.permissionEvaluation.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.queryConsistency == null ? 0 : this.queryConsistency.hashCode());
        result = 31 * result + (this.queryParameterDefinitions == null ? 0 : this.queryParameterDefinitions.hashCode());
        result = 31 * result + (this.queryTemplates == null ? 0 : this.queryTemplates.hashCode());
        result = 31 * result + this.skipCount;
        result = 31 * result + (this.sortDefinitions == null ? 0 : this.sortDefinitions.hashCode());
        result = 31 * result + (this.stores == null ? 0 : this.stores.hashCode());
        result = 31 * result + (this.textAttributes == null ? 0 : this.textAttributes.hashCode());
        result = 31 * result + (this.useInMemorySort == null ? 0 : this.useInMemorySort.hashCode());
        result = 31 * result + (this.sinceTxId == null ? 0 : this.sinceTxId.hashCode());
        result = 31 * result + (this.facetQueries.isEmpty() ? 0 : this.facetQueries.hashCode());
        result = 31 * result + (this.filterQueries.isEmpty() ? 0 : this.filterQueries.hashCode());
        result = 31 * result + (this.pivots.isEmpty() ? 0 : this.pivots.hashCode());
        result = 31 * result + (this.ranges == null ? 0 : this.ranges.hashCode());
        result = 31 * result + (this.searchTerm == null ? 0 : this.searchTerm.hashCode());
        result = 31 * result + (this.spellCheck ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchParameters other = (SearchParameters)obj;
        if (this.allAttributes == null ? other.allAttributes != null : !this.allAttributes.equals(other.allAttributes)) {
            return false;
        }
        if (this.defaultFTSFieldOperator != other.defaultFTSFieldOperator) {
            return false;
        }
        if (this.defaultFTSOperator != other.defaultFTSOperator) {
            return false;
        }
        if (this.defaultFieldName == null ? other.defaultFieldName != null : !this.defaultFieldName.equals(other.defaultFieldName)) {
            return false;
        }
        if (this.excludeDataInTheCurrentTransaction != other.excludeDataInTheCurrentTransaction) {
            return false;
        }
        if (this.excludeTenantFilter != other.excludeTenantFilter) {
            return false;
        }
        if (this.fieldFacets == null ? other.fieldFacets != null : !this.fieldFacets.equals(other.fieldFacets)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.limitBy != other.limitBy) {
            return false;
        }
        if (this.locales == null ? other.locales != null : !this.locales.equals(other.locales)) {
            return false;
        }
        if (this.maxItems != other.maxItems) {
            return false;
        }
        if (this.maxPermissionCheckTimeMillis != other.maxPermissionCheckTimeMillis) {
            return false;
        }
        if (this.maxPermissionChecks != other.maxPermissionChecks) {
            return false;
        }
        if (this.maxRawResultSetSizeForInMemorySort == null ? other.maxRawResultSetSizeForInMemorySort != null : !this.maxRawResultSetSizeForInMemorySort.equals(other.maxRawResultSetSizeForInMemorySort)) {
            return false;
        }
        if (this.mlAnalaysisMode != other.mlAnalaysisMode) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.permissionEvaluation != other.permissionEvaluation) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        if (this.queryConsistency != other.queryConsistency) {
            return false;
        }
        if (this.queryParameterDefinitions == null ? other.queryParameterDefinitions != null : !this.queryParameterDefinitions.equals(other.queryParameterDefinitions)) {
            return false;
        }
        if (this.queryTemplates == null ? other.queryTemplates != null : !this.queryTemplates.equals(other.queryTemplates)) {
            return false;
        }
        if (this.skipCount != other.skipCount) {
            return false;
        }
        if (this.sortDefinitions == null ? other.sortDefinitions != null : !this.sortDefinitions.equals(other.sortDefinitions)) {
            return false;
        }
        if (this.stores == null ? other.stores != null : !this.stores.equals(other.stores)) {
            return false;
        }
        if (this.textAttributes == null ? other.textAttributes != null : !this.textAttributes.equals(other.textAttributes)) {
            return false;
        }
        if (this.useInMemorySort == null ? other.useInMemorySort != null : !this.useInMemorySort.equals(other.useInMemorySort)) {
            return false;
        }
        if (this.sinceTxId == null ? other.sinceTxId != null : !this.sinceTxId.equals(other.sinceTxId)) {
            return false;
        }
        if (!this.facetQueries.equals(other.facetQueries)) {
            return false;
        }
        if (!this.filterQueries.equals(other.filterQueries)) {
            return false;
        }
        if (!this.pivots.equals(other.pivots)) {
            return false;
        }
        if (this.searchTerm == null ? other.searchTerm != null : !this.searchTerm.equals(other.searchTerm)) {
            return false;
        }
        return this.spellCheck == other.spellCheck;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(1000);
        builder.append("SearchParameters [language=").append(this.language).append(", query=").append(this.query).append(", stores=").append(this.stores).append(", queryParameterDefinitions=").append(this.queryParameterDefinitions).append(", excludeDataInTheCurrentTransaction=").append(this.excludeDataInTheCurrentTransaction).append(", sortDefinitions=").append(this.sortDefinitions).append(", locales=").append(this.locales).append(", mlAnalaysisMode=").append((Object)this.mlAnalaysisMode).append(", limitBy=").append((Object)this.limitBy).append(", permissionEvaluation=").append((Object)this.permissionEvaluation).append(", limit=").append(this.limit).append(", allAttributes=").append(this.allAttributes).append(", textAttributes=").append(this.textAttributes).append(", maxItems=").append(this.maxItems).append(", skipCount=").append(this.skipCount).append(", defaultFTSOperator=").append((Object)this.defaultFTSOperator).append(", defaultFTSFieldOperator=").append((Object)this.defaultFTSFieldOperator).append(", queryTemplates=").append(this.queryTemplates).append(", namespace=").append(this.namespace).append(", maxPermissionChecks=").append(this.maxPermissionChecks).append(", maxPermissionCheckTimeMillis=").append(this.maxPermissionCheckTimeMillis).append(", defaultFieldName=").append(this.defaultFieldName).append(", fieldFacets=").append(this.fieldFacets).append(", facetQueries=").append(this.facetQueries).append(", filterQueries=").append(this.filterQueries).append(", pivots=").append(this.pivots).append(", stats=").append(this.stats).append(", useInMemorySort=").append(this.useInMemorySort).append(", maxRawResultSetSizeForInMemorySort=").append(this.maxRawResultSetSizeForInMemorySort).append(", extraParameters=").append(this.extraParameters).append(", excludeTenantFilter=").append(this.excludeTenantFilter).append(", isBulkFetchEnabled=").append(this.isBulkFetchEnabled).append(", queryConsistency=").append((Object)this.queryConsistency).append(", sinceTxId=").append(this.sinceTxId).append(", searchTerm=").append(this.searchTerm).append(", highlight=").append(this.highlight).append(", interval=").append(this.interval).append(", range=").append(this.ranges).append(", timezone=").append(this.timezone).append(", spellCheck=").append(this.spellCheck).append("]");
        return builder.toString();
    }

    public String toAuditString() {
        StringBuilder builder = new StringBuilder(1000);
        builder.append("{lang=").append(this.language).append(", query=").append(this.query).append(", stores=").append(this.stores).append(", defaultFTSOp=").append((Object)this.defaultFTSOperator).append(", defaultFTSFieldOp=").append((Object)this.defaultFTSFieldOperator);
        if (this.queryTemplates != null && !this.queryTemplates.isEmpty()) {
            builder.append(", queryTemplates=").append(this.queryTemplates);
        }
        if (this.filterQueries != null && !this.filterQueries.isEmpty()) {
            builder.append(", filterQueries=").append(this.filterQueries);
        }
        if (this.searchTerm != null && !this.searchTerm.isEmpty()) {
            builder.append(", searchTerm=").append(this.searchTerm);
        }
        builder.append("}");
        return builder.toString();
    }

    public boolean usePostSort(int length, boolean useInMemorySortDefault, int maxRawResultSetSizeForInMemorySortDefault) {
        boolean use = this.useInMemorySort == null ? useInMemorySortDefault : this.useInMemorySort;
        int max = this.maxRawResultSetSizeForInMemorySort == null ? maxRawResultSetSizeForInMemorySortDefault : this.maxRawResultSetSizeForInMemorySort;
        return use && length <= max;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public static class FieldFacet {
        String field;
        String label;
        List<String> excludeFilters;
        String prefix = null;
        FieldFacetSort sort = null;
        Integer limitOrNull = null;
        int offset = 0;
        int minCount = 0;
        boolean countDocsMissingFacetField = false;
        FieldFacetMethod method = null;
        int enumMethodCacheMinDF = 0;

        public FieldFacet(String field) {
            this.field = field;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public FieldFacetSort getSort() {
            return this.sort;
        }

        public void setSort(FieldFacetSort sort) {
            this.sort = sort;
        }

        @Deprecated
        public int getLimit() {
            return this.limitOrNull == null ? 100 : this.limitOrNull;
        }

        @Deprecated
        public void setLimit(int limit) {
            this.limitOrNull = limit;
        }

        public void setLimitOrNull(Integer limitOrNull) {
            this.limitOrNull = limitOrNull;
        }

        public Integer getLimitOrNull() {
            return this.limitOrNull;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public void setMinCount(int minCount) {
            this.minCount = minCount;
        }

        public boolean isCountDocsMissingFacetField() {
            return this.countDocsMissingFacetField;
        }

        public void setCountDocsMissingFacetField(boolean countDocsMissingFacetField) {
            this.countDocsMissingFacetField = countDocsMissingFacetField;
        }

        public FieldFacetMethod getMethod() {
            return this.method;
        }

        public void setMethod(FieldFacetMethod method) {
            this.method = method;
        }

        public int getEnumMethodCacheMinDF() {
            return this.enumMethodCacheMinDF;
        }

        public void setEnumMethodCacheMinDF(int enumMethodCacheMinDF) {
            this.enumMethodCacheMinDF = enumMethodCacheMinDF;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public List<String> getExcludeFilters() {
            return this.excludeFilters;
        }

        public void setExcludeFilters(List<String> excludeFilters) {
            this.excludeFilters = excludeFilters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldFacet that = (FieldFacet)o;
            if (this.offset != that.offset) {
                return false;
            }
            if (this.minCount != that.minCount) {
                return false;
            }
            if (this.countDocsMissingFacetField != that.countDocsMissingFacetField) {
                return false;
            }
            if (this.enumMethodCacheMinDF != that.enumMethodCacheMinDF) {
                return false;
            }
            if (!this.field.equals(that.field)) {
                return false;
            }
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
                return false;
            }
            if (this.excludeFilters != null ? !this.excludeFilters.equals(that.excludeFilters) : that.excludeFilters != null) {
                return false;
            }
            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
                return false;
            }
            if (this.sort != that.sort) {
                return false;
            }
            if (this.limitOrNull != null ? !this.limitOrNull.equals(that.limitOrNull) : that.limitOrNull != null) {
                return false;
            }
            return this.method == that.method;
        }

        public int hashCode() {
            int result = this.field.hashCode();
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.excludeFilters != null ? this.excludeFilters.hashCode() : 0);
            result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
            result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
            result = 31 * result + (this.limitOrNull != null ? this.limitOrNull.hashCode() : 0);
            result = 31 * result + this.offset;
            result = 31 * result + this.minCount;
            result = 31 * result + (this.countDocsMissingFacetField ? 1 : 0);
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + this.enumMethodCacheMinDF;
            return result;
        }
    }

    public static enum FieldFacetMethod {
        ENUM,
        FC;

    }

    public static enum FieldFacetSort {
        COUNT,
        INDEX;

    }

    public static class SortDefinition {
        SortType sortType;
        String field;
        boolean ascending;

        public SortDefinition(SortType sortType, String field, boolean ascending) {
            this.sortType = sortType;
            this.field = field;
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public String getField() {
            return this.field;
        }

        public SortType getSortType() {
            return this.sortType;
        }

        public static enum SortType {
            FIELD,
            DOCUMENT,
            SCORE;

        }
    }

    public static enum Operator {
        OR,
        AND;

    }
}

