/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.BaseLuceneBuilder;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public class ObjectTypeIdLuceneBuilder
extends BaseLuceneBuilder {
    private CMISDictionaryService cmisDictionaryService;

    public ObjectTypeIdLuceneBuilder(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    @Override
    public String getLuceneFieldName() {
        return "EXACTTYPE";
    }

    private String getValueAsString(Serializable value) {
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
        return asString;
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneEquality(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        TypeDefinitionWrapper type = this.cmisDictionaryService.findType(stringValue);
        return lqpa.getFieldQuery(field, type.getAlfrescoClass().toString(), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneExists(QueryParserAdaptor<Q, S, E> lqpa, Boolean not) throws E {
        if (not.booleanValue()) {
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchAllQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThan(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new CmisInvalidArgumentException("Property cmis:objectTypeId can not be used in a 'greater than' comparison");
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new CmisInvalidArgumentException("Property cmis:objectTypeId can not be used in a 'greater than or equals' comparison");
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneInequality(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        return lqpa.getNegatedQuery(this.buildLuceneEquality(lqpa, value, mode, luceneFunction));
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThan(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new CmisInvalidArgumentException("Property cmis:objectTypeId can not be used in a 'less than' comparison");
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new CmisInvalidArgumentException("Property cmis:objectTypeId can not be used in a 'less than or equals' comparison");
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLike(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, Boolean not) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        TypeDefinitionWrapper type = this.cmisDictionaryService.findType(stringValue);
        String typeQName = type.getAlfrescoClass().toString();
        Q q = lqpa.getLikeQuery(field, typeQName, AnalysisMode.IDENTIFIER);
        if (not.booleanValue()) {
            q = lqpa.getNegatedQuery(q);
        }
        return q;
    }

    @Override
    public <Q, S, E extends Throwable> String getLuceneSortField(QueryParserAdaptor<Q, S, E> lqpa) {
        return this.getLuceneFieldName();
    }
}

