/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.springframework.extensions.surf.util.I18NUtil;

public class ConstraintsTest
extends TestCase {
    protected void setUp() throws Exception {
        I18NUtil.registerResourceBundle((String)"alfresco/messages/dictionary-messages");
    }

    public void testCollections() throws Exception {
        DummyConstraint constraint = new DummyConstraint();
        constraint.initialize();
        ConstraintsTest.assertEquals((String)"DummyConstraint type should be 'org.alfresco.repo.dictionary.constraint.ConstraintsTest$DummyConstraint'", (String)"org.alfresco.repo.dictionary.constraint.ConstraintsTest$DummyConstraint", (String)constraint.getType());
        ConstraintsTest.assertNotNull((String)"DummyConstraint should not have empty parameters", (Object)constraint.getParameters());
        ConstraintsTest.assertEquals((String)"DummyConstraint should not have empty parameters", (int)0, (int)constraint.getParameters().size());
        ArrayList<Object> dummyObjects = new ArrayList<Object>(3);
        dummyObjects.add("ABC");
        dummyObjects.add("DEF");
        dummyObjects.add((Object)this);
        try {
            constraint.evaluate(dummyObjects);
            ConstraintsTest.fail((String)"Failed to detected constraint violation in collection");
        }
        catch (ConstraintException e) {
            this.checkI18NofExceptionMessage(e);
        }
        ConstraintsTest.assertEquals((String)"String values not checked", (int)2, (int)constraint.tested.size());
    }

    public void testNull() throws Exception {
        DummyConstraint constraint = new DummyConstraint();
        constraint.initialize();
        constraint.evaluate(null);
    }

    private void checkI18NofExceptionMessage(Throwable e) {
        String msg = e.getMessage();
        ConstraintsTest.assertFalse((String)"I18N of constraint message failed", (boolean)msg.startsWith("d_dictionary.constraint"));
    }

    private void evaluate(Constraint constraint, Object value, boolean expectFailure) throws Exception {
        try {
            constraint.evaluate(value);
            if (expectFailure) {
                ConstraintsTest.fail((String)("Failure did not occur: \n   constraint: " + constraint + "\n   value: " + value));
            }
        }
        catch (ConstraintException e) {
            if (expectFailure) {
                this.checkI18NofExceptionMessage(e);
            }
            throw e;
        }
    }

    public void testStringLengthConstraint() throws Exception {
        StringLengthConstraint constraint = new StringLengthConstraint();
        try {
            constraint.setMinLength(-1);
        }
        catch (DictionaryException e) {
            this.checkI18NofExceptionMessage(e);
        }
        try {
            constraint.setMaxLength(-1);
        }
        catch (DictionaryException e) {
            this.checkI18NofExceptionMessage(e);
        }
        constraint.setMinLength(3);
        constraint.setMaxLength(6);
        ConstraintsTest.assertEquals((String)"StringLengthConstraint type should be 'LENGTH'", (String)"LENGTH", (String)constraint.getType());
        ConstraintsTest.assertNotNull((String)"StringLengthConstraint should have parameters", (Object)constraint.getParameters());
        ConstraintsTest.assertEquals((String)"StringLengthConstraint should have 2 parameters", (int)2, (int)constraint.getParameters().size());
        ConstraintsTest.assertEquals((String)"minLength should be 3", (Object)3, constraint.getParameters().get("minLength"));
        ConstraintsTest.assertEquals((String)"maxLength should be 6", (Object)6, constraint.getParameters().get("maxLength"));
        this.evaluate((Constraint)constraint, "abc", false);
        this.evaluate((Constraint)constraint, "abcdef", false);
        this.evaluate((Constraint)constraint, Arrays.asList("abc", "abcdef"), false);
        this.evaluate((Constraint)constraint, "ab", true);
        this.evaluate((Constraint)constraint, "abcdefg", true);
        this.evaluate((Constraint)constraint, Arrays.asList("abc", "abcdefg"), true);
    }

    public void testListOfValuesConstraint() throws Exception {
        ListOfValuesConstraint constraint = new ListOfValuesConstraint();
        try {
            constraint.setAllowedValues(Collections.emptyList());
        }
        catch (DictionaryException e) {
            this.checkI18NofExceptionMessage(e);
        }
        List<String> allowedValues = Arrays.asList("abc", "def", "ghi", " jkl ");
        constraint.setAllowedValues(allowedValues);
        ConstraintsTest.assertEquals((String)"ListOfValuesConstraint type should be 'LIST'", (String)"LIST", (String)constraint.getType());
        ConstraintsTest.assertNotNull((String)"ListOfValuesConstraint should have parameters", (Object)constraint.getParameters());
        ConstraintsTest.assertEquals((String)"ListOfValuesConstraint should have 3 parameters", (int)3, (int)constraint.getParameters().size());
        ConstraintsTest.assertEquals((String)"caseSensitive should be true", (Object)Boolean.TRUE, constraint.getParameters().get("caseSensitive"));
        List allowedValuesParam = (List)constraint.getParameters().get("allowedValues");
        ConstraintsTest.assertEquals((String)"Should be 4 allowable values", (int)4, (int)allowedValuesParam.size());
        ConstraintsTest.assertEquals((String)"First allowable value should be 'abc'", (String)"abc", (String)((String)allowedValuesParam.get(0)));
        ConstraintsTest.assertEquals((String)"First allowable value should be 'def'", (String)"def", (String)((String)allowedValuesParam.get(1)));
        ConstraintsTest.assertEquals((String)"First allowable value should be 'ghi'", (String)"ghi", (String)((String)allowedValuesParam.get(2)));
        ConstraintsTest.assertEquals((String)"First allowable value should be ' jkl '", (String)" jkl ", (String)((String)allowedValuesParam.get(3)));
        Boolean sorted = (Boolean)constraint.getParameters().get("sorted");
        ConstraintsTest.assertFalse((String)"sorting should be false", (boolean)sorted);
        this.evaluate((Constraint)constraint, "def", false);
        this.evaluate((Constraint)constraint, "DEF", true);
        this.evaluate((Constraint)constraint, Arrays.asList("abc", "def"), false);
        this.evaluate((Constraint)constraint, Arrays.asList("abc", "DEF"), true);
        constraint.setCaseSensitive(false);
        ConstraintsTest.assertEquals((String)"caseSensitive should be false", (Object)Boolean.FALSE, constraint.getParameters().get("caseSensitive"));
        this.evaluate((Constraint)constraint, "DEF", false);
        this.evaluate((Constraint)constraint, Arrays.asList("abc", "DEF"), false);
        this.evaluate((Constraint)constraint, " jkl ", false);
        this.evaluate((Constraint)constraint, "jkl", true);
        this.evaluate((Constraint)constraint, " jkl", true);
        this.evaluate((Constraint)constraint, "jkl ", true);
        this.evaluate((Constraint)constraint, " jkl  ", true);
        this.evaluate((Constraint)constraint, Arrays.asList(" jkl ", " JKL "), false);
        this.evaluate((Constraint)constraint, Arrays.asList("  jkl  ", "  JKL  "), true);
    }

    public void testNumericRangeConstraint() throws Exception {
        NumericRangeConstraint constraint = new NumericRangeConstraint();
        constraint.initialize();
        ConstraintsTest.assertEquals((String)"NumericRangeConstraint type should be 'MINMAX'", (String)"MINMAX", (String)constraint.getType());
        ConstraintsTest.assertNotNull((String)"NumericRangeConstraint should have parameters", (Object)constraint.getParameters());
        ConstraintsTest.assertEquals((String)"NumericRangeConstraint should have 2 parameters", (int)2, (int)constraint.getParameters().size());
        constraint.evaluate((Object)Double.MIN_VALUE);
        constraint.evaluate((Object)Double.MAX_VALUE);
        this.evaluate((Constraint)constraint, Double.NaN, true);
        constraint.setMinValue(-5.0);
        constraint.setMaxValue(5.0);
        constraint.initialize();
        ConstraintsTest.assertEquals((String)"minValue should be -5", (Object)-5.0, constraint.getParameters().get("minValue"));
        ConstraintsTest.assertEquals((String)"maxValue should be 5", (Object)5.0, constraint.getParameters().get("maxValue"));
        this.evaluate((Constraint)constraint, "-1.0", false);
        this.evaluate((Constraint)constraint, "+1.0", false);
        this.evaluate((Constraint)constraint, Arrays.asList(-1, 0, 1), false);
        this.evaluate((Constraint)constraint, "abc", true);
        this.evaluate((Constraint)constraint, 564530.0, true);
        this.evaluate((Constraint)constraint, Arrays.asList(-1, 6), true);
    }

    public void testRegexConstraint() throws Exception {
        RegexConstraint constraint = new RegexConstraint();
        constraint.setExpression("[A-Z]*");
        constraint.setRequiresMatch(true);
        constraint.initialize();
        ConstraintsTest.assertEquals((String)"RegexConstraint type should be 'REGEX'", (String)"REGEX", (String)constraint.getType());
        ConstraintsTest.assertNotNull((String)"RegexConstraint should have parameters", (Object)constraint.getParameters());
        ConstraintsTest.assertEquals((String)"RegexConstraint should have 2 parameters", (int)2, (int)constraint.getParameters().size());
        ConstraintsTest.assertEquals((String)"requiresMatch should be true", (Object)Boolean.TRUE, constraint.getParameters().get("requiresMatch"));
        ConstraintsTest.assertEquals((String)"expression should be [A-Z]*", (Object)"[A-Z]*", constraint.getParameters().get("expression"));
        this.evaluate((Constraint)constraint, "ABC", false);
        this.evaluate((Constraint)constraint, "DEF", false);
        this.evaluate((Constraint)constraint, "abc", true);
        this.evaluate((Constraint)constraint, (Object)DummyEnum.ABC, false);
        this.evaluate((Constraint)constraint, (Object)DummyEnum.DEF, false);
        this.evaluate((Constraint)constraint, (Object)DummyEnum.abc, true);
        constraint.setRequiresMatch(false);
        constraint.initialize();
        ConstraintsTest.assertEquals((String)"requiresMatch should be false", (Object)Boolean.FALSE, constraint.getParameters().get("requiresMatch"));
        this.evaluate((Constraint)constraint, (Object)DummyEnum.abc, false);
    }

    public void testRegexConstraintFilename() throws Exception {
        String expression = new String(".*[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|\\\u00ac\\\u00a3\\%\\&\\+\\;]+.*".getBytes("UTF-8"));
        String invalidChars = new String("\"*\\><?/:|%&+;\u00ac\u00a3".getBytes("UTF-8"));
        RegexConstraint constraint = new RegexConstraint();
        constraint.setExpression(expression);
        constraint.setRequiresMatch(false);
        constraint.initialize();
        for (int i = 0; i < invalidChars.length(); ++i) {
            String invalidStr = invalidChars.substring(i, i + 1);
            this.evaluate((Constraint)constraint, invalidStr, true);
        }
        this.evaluate((Constraint)constraint, "Bogus<>.txt", true);
        this.evaluate((Constraint)constraint, "Company Home", false);
    }

    private class DummyConstraint
    extends AbstractConstraint {
        private List<Object> tested;

        private DummyConstraint() {
        }

        public void initialize() {
            this.tested = new ArrayList<Object>(4);
        }

        protected void evaluateSingleValue(Object value) {
            if (value == null) {
                throw new NullPointerException("Null value in dummy test");
            }
            if (!(value instanceof String)) {
                throw new ConstraintException("Non-String value", new Object[0]);
            }
            this.tested.add(value);
        }
    }

    private static enum DummyEnum {
        ABC,
        DEF,
        abc;

    }
}

