/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.dictionary.CompiledModelsCache;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.RegisteredConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.DynamicallySizedThreadPoolExecutor;
import org.alfresco.util.TraceableThreadFactory;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.DefaultAsynchronouslyRefreshedCacheRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.extensions.surf.util.I18NUtil;

public class DictionaryDAOTest {
    public static final String TEST_RESOURCE_MESSAGES = "alfresco/messages/dictionary-messages";
    private static final String TEST_URL = "http://www.alfresco.org/test/dictionarydaotest/1.0";
    private static final String TEST2_URL = "http://www.alfresco.org/test/dictionarydaotest2/1.0";
    private static final String TEST_MODEL = "org/alfresco/repo/dictionary/dictionarydaotest_model.xml";
    private static final String TEST_MODEL_NEW_FORMAT = "org/alfresco/repo/dictionary/dictionarydaotest_model_new_format.xml";
    private static final String TEST_NS_CLASH_MODEL = "org/alfresco/repo/dictionary/nstest_model.xml";
    private static final String TEST_BUNDLE = "org/alfresco/repo/dictionary/dictionarydaotest_model";
    private static final String TEST_COMMON_NS_PARENT_MODEL = "org/alfresco/repo/dictionary/commonpropertynsparent_model.xml";
    private static final String TEST_COMMON_NS_CHILD_MODEL = "org/alfresco/repo/dictionary/commonpropertynschild_model.xml";
    private DictionaryService service;
    private DictionaryDAOImpl dictionaryDAO;

    @Before
    public void setUp() throws Exception {
        I18NUtil.registerResourceBundle((String)TEST_RESOURCE_MESSAGES);
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        this.dictionaryDAO = new DictionaryDAOImpl();
        this.dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(this.dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_MODEL);
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(TEST_BUNDLE);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setLabels(labels);
        bootstrap.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
        DictionaryComponent component = new DictionaryComponent();
        component.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        component.setMessageLookup((MessageLookup)new StaticMessageLookup());
        this.service = component;
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO, TenantService tenantService) {
        CompiledModelsCache compiledModelsCache = new CompiledModelsCache();
        compiledModelsCache.setDictionaryDAO(dictionaryDAO);
        compiledModelsCache.setTenantService(tenantService);
        compiledModelsCache.setRegistry((AsynchronouslyRefreshedCacheRegistry)new DefaultAsynchronouslyRefreshedCacheRegistry());
        TraceableThreadFactory threadFactory = new TraceableThreadFactory();
        threadFactory.setThreadDaemon(true);
        threadFactory.setThreadPriority(5);
        DynamicallySizedThreadPoolExecutor threadPoolExecutor = new DynamicallySizedThreadPoolExecutor(20, 20, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue(), (ThreadFactory)threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        compiledModelsCache.setThreadPoolExecutor((ThreadPoolExecutor)threadPoolExecutor);
        dictionaryDAO.setDictionaryRegistryCache(compiledModelsCache);
        dictionaryDAO.init();
    }

    @Test
    public void testBootstrap() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
    }

    @Test
    public void testNamespaceClashResultsInSensibleError() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_MODEL);
        bootstrapModels.add(TEST_NS_CLASH_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        try {
            bootstrap.bootstrap();
            Assert.fail((String)("Expected " + NamespaceException.class.getName() + " to be thrown, but it was not."));
        }
        catch (NamespaceException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testNamespaceClashResultsInSensibleErrorWithNewFormat() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel_new_format.xml");
        bootstrapModels.add(TEST_MODEL_NEW_FORMAT);
        bootstrapModels.add(TEST_NS_CLASH_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        try {
            bootstrap.bootstrap();
            Assert.fail((String)("Expected " + NamespaceException.class.getName() + " to be thrown, but it was not."));
        }
        catch (NamespaceException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testUseImportedNamespaces() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_COMMON_NS_PARENT_MODEL);
        bootstrapModels.add(TEST_COMMON_NS_CHILD_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
    }

    @Test
    public void testUseImportedNamespacesWithNewFormat() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel_new_format.xml");
        bootstrapModels.add(TEST_COMMON_NS_PARENT_MODEL);
        bootstrapModels.add(TEST_COMMON_NS_CHILD_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        bootstrap.bootstrap();
    }

    @Test
    public void testLabels() {
        QName model = QName.createQName((String)TEST_URL, (String)"dictionarydaotest");
        ModelDefinition modelDef = this.service.getModel(model);
        Assert.assertEquals((Object)"Model Description", (Object)modelDef.getDescription((MessageLookup)this.service));
        QName type = QName.createQName((String)TEST_URL, (String)"base");
        TypeDefinition typeDef = this.service.getType(type);
        Assert.assertEquals((Object)"Base Title", (Object)typeDef.getTitle((MessageLookup)this.service));
        Assert.assertEquals((Object)"Base Description", (Object)typeDef.getDescription((MessageLookup)this.service));
        QName prop = QName.createQName((String)TEST_URL, (String)"prop1");
        PropertyDefinition propDef = this.service.getProperty(prop);
        Assert.assertEquals((Object)"Prop1 Title", (Object)propDef.getTitle((MessageLookup)this.service));
        Assert.assertEquals((Object)"Prop1 Description", (Object)propDef.getDescription((MessageLookup)this.service));
        QName assoc = QName.createQName((String)TEST_URL, (String)"assoc1");
        AssociationDefinition assocDef = this.service.getAssociation(assoc);
        Assert.assertEquals((Object)"Assoc1 Title", (Object)assocDef.getTitle((MessageLookup)this.service));
        Assert.assertEquals((Object)"Assoc1 Description", (Object)assocDef.getDescription((MessageLookup)this.service));
        QName datatype = QName.createQName((String)TEST_URL, (String)"datatype");
        DataTypeDefinition datatypeDef = this.service.getDataType(datatype);
        QName constraint = QName.createQName((String)TEST_URL, (String)"list1");
        ConstraintDefinition constraintDef = this.service.getConstraint(constraint);
        Assert.assertEquals((Object)"List1 title", (Object)constraintDef.getTitle((MessageLookup)this.service));
        Assert.assertEquals((Object)"List1 description", (Object)constraintDef.getDescription((MessageLookup)this.service));
        ListOfValuesConstraint lovConstraint = (ListOfValuesConstraint)constraintDef.getConstraint();
        Assert.assertEquals((String)"Wrong localised lov value.", (Object)"ABC display", (Object)lovConstraint.getDisplayLabel("ABC", (MessageLookup)this.service));
        Assert.assertEquals((String)"Wrong localised lov value.", (Object)"DEF display", (Object)lovConstraint.getDisplayLabel("DEF", (MessageLookup)this.service));
        Assert.assertEquals((String)"Wrong localised lov value.", (Object)"VALUE WITH SPACES display", (Object)lovConstraint.getDisplayLabel("VALUE WITH SPACES", (MessageLookup)this.service));
        Assert.assertEquals((String)"Wrong localised lov value.", (Object)"VALUE WITH TRAILING SPACE display", (Object)lovConstraint.getDisplayLabel("VALUE WITH TRAILING SPACE ", (MessageLookup)this.service));
        Assert.assertNull((Object)lovConstraint.getDisplayLabel("nosuchLOV", (MessageLookup)this.service));
        QName constrainedPropName = QName.createQName((String)TEST_URL, (String)"constrainedProp");
        PropertyDefinition constrainedPropDef = this.service.getProperty(constrainedPropName);
        List constraints = constrainedPropDef.getConstraints();
        Assert.assertEquals((String)"Wrong number of constraints.", (long)1L, (long)constraints.size());
        ConstraintDefinition inlineConstraintDef = (ConstraintDefinition)constraints.get(0);
        lovConstraint = (ListOfValuesConstraint)inlineConstraintDef.getConstraint();
        Assert.assertEquals((String)"Wrong localised lov value.", (Object)"ALPHA display", (Object)lovConstraint.getDisplayLabel("ALPHA", (MessageLookup)this.service));
        Assert.assertEquals((String)"Wrong localised lov value.", (Object)"BETA display", (Object)lovConstraint.getDisplayLabel("BETA", (MessageLookup)this.service));
        Assert.assertEquals((String)"Wrong localised lov value.", (Object)"GAMMA, DELTA display", (Object)lovConstraint.getDisplayLabel("GAMMA, DELTA", (MessageLookup)this.service));
        Assert.assertEquals((String)"Wrong localised lov value.", (Object)"OMEGA", (Object)lovConstraint.getDisplayLabel("OMEGA", (MessageLookup)this.service));
        Assert.assertNull((Object)lovConstraint.getDisplayLabel("nosuchLOV", (MessageLookup)this.service));
    }

    @Test
    public void testConstraints() {
        QName model = QName.createQName((String)TEST_URL, (String)"dictionarydaotest");
        Collection modelConstraints = this.service.getConstraints(model);
        Assert.assertEquals((long)23L, (long)modelConstraints.size());
        QName conRegExp1QName = QName.createQName((String)TEST_URL, (String)"regex1");
        boolean found1 = false;
        QName conStrLen1QName = QName.createQName((String)TEST_URL, (String)"stringLength1");
        boolean found2 = false;
        for (ConstraintDefinition constraintDef : modelConstraints) {
            if (constraintDef.getName().equals((Object)conRegExp1QName)) {
                Assert.assertEquals((Object)"Regex1 title", (Object)constraintDef.getTitle((MessageLookup)this.service));
                Assert.assertEquals((Object)"Regex1 description", (Object)constraintDef.getDescription((MessageLookup)this.service));
                found1 = true;
            }
            if (!constraintDef.getName().equals((Object)conStrLen1QName)) continue;
            Assert.assertNull((Object)constraintDef.getTitle((MessageLookup)this.service));
            Assert.assertNull((Object)constraintDef.getDescription((MessageLookup)this.service));
            found2 = true;
        }
        Assert.assertTrue((boolean)found1);
        Assert.assertTrue((boolean)found2);
        QName propNoConstraintsQName = QName.createQName((String)TEST_URL, (String)"fileprop");
        PropertyDefinition propNoConstraintsDef = this.service.getProperty(propNoConstraintsQName);
        Assert.assertNotNull((String)"Property without constraints returned null list", (Object)propNoConstraintsDef.getConstraints());
        QName prop1QName = QName.createQName((String)TEST_URL, (String)"prop1");
        PropertyDefinition propDef = this.service.getProperty(prop1QName);
        List constraints = propDef.getConstraints();
        Assert.assertNotNull((String)"Null constraints list", (Object)constraints);
        Assert.assertEquals((String)"Incorrect number of constraints", (long)3L, (long)constraints.size());
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)constraints.get(0)).getConstraint() instanceof RegexConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)constraints.get(1)).getConstraint() instanceof StringLengthConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)constraints.get(2)).getConstraint() instanceof RegisteredConstraint));
        ConstraintDefinition constraintDef = (ConstraintDefinition)constraints.get(0);
        Assert.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().equals("dictionarydaotest_base_prop1_anon_0"));
        Assert.assertTrue((String)"Constraint title incorrect", (boolean)constraintDef.getTitle((MessageLookup)this.service).equals("Regex1 title"));
        Assert.assertTrue((String)"Constraint description incorrect", (boolean)constraintDef.getDescription((MessageLookup)this.service).equals("Regex1 description"));
        constraintDef = (ConstraintDefinition)constraints.get(1);
        Assert.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().equals("dictionarydaotest_base_prop1_anon_1"));
        Assert.assertTrue((String)"Constraint title incorrect", (boolean)constraintDef.getTitle((MessageLookup)this.service).equals("Prop1 Strlen1 title"));
        Assert.assertTrue((String)"Constraint description incorrect", (boolean)constraintDef.getDescription((MessageLookup)this.service).equals("Prop1 Strlen1 description"));
        Constraint constraint = constraintDef.getConstraint();
        Assert.assertNotNull((String)"Reference constraint has no implementation", (Object)constraint);
    }

    @Test
    public void testConstraintsOverrideInheritance() {
        QName baseQName = QName.createQName((String)TEST_URL, (String)"base");
        QName fileQName = QName.createQName((String)TEST_URL, (String)"file");
        QName folderQName = QName.createQName((String)TEST_URL, (String)"folder");
        QName prop1QName = QName.createQName((String)TEST_URL, (String)"prop1");
        PropertyDefinition prop1Def = this.service.getProperty(baseQName, prop1QName);
        Assert.assertNotNull((Object)prop1Def);
        List prop1Constraints = prop1Def.getConstraints();
        Assert.assertEquals((String)"Incorrect number of constraints", (long)3L, (long)prop1Constraints.size());
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(0)).getConstraint() instanceof RegexConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(1)).getConstraint() instanceof StringLengthConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(2)).getConstraint() instanceof RegisteredConstraint));
        prop1Def = this.service.getProperty(folderQName, prop1QName);
        Assert.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        Assert.assertEquals((String)"Incorrect number of constraints", (long)3L, (long)prop1Constraints.size());
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(0)).getConstraint() instanceof RegexConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(1)).getConstraint() instanceof StringLengthConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(2)).getConstraint() instanceof RegisteredConstraint));
        prop1Def = this.service.getProperty(fileQName, prop1QName);
        Assert.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        Assert.assertEquals((String)"Incorrect number of constraints", (long)3L, (long)prop1Constraints.size());
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(0)).getConstraint() instanceof StringLengthConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(1)).getConstraint() instanceof RegexConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)prop1Constraints.get(2)).getConstraint() instanceof RegisteredConstraint));
    }

    @Test
    public void testConstraintsOverrideInheritanceOnAspects() {
        QName aspectBaseQName = QName.createQName((String)TEST_URL, (String)"aspect-base");
        QName aspectOneQName = QName.createQName((String)TEST_URL, (String)"aspect-one");
        QName aspectTwoQName = QName.createQName((String)TEST_URL, (String)"aspect-two");
        QName aspectThreeQName = QName.createQName((String)TEST2_URL, (String)"aspect-three");
        QName propQName = QName.createQName((String)TEST_URL, (String)"aspect-base-p1");
        PropertyDefinition propDef = this.service.getProperty(aspectBaseQName, propQName);
        Assert.assertNotNull((Object)propDef);
        List propConstraints = propDef.getConstraints();
        Assert.assertEquals((String)"Incorrect number of constraints", (long)1L, (long)propConstraints.size());
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)propConstraints.get(0)).getConstraint() instanceof ListOfValuesConstraint));
        ListOfValuesConstraint constraint = (ListOfValuesConstraint)((ConstraintDefinition)propConstraints.get(0)).getConstraint();
        List allowedValues = constraint.getAllowedValues();
        Assert.assertEquals((String)"Expected 4 allowed values", (long)4L, (long)allowedValues.size());
        Assert.assertEquals((Object)"ABC", allowedValues.get(0));
        Assert.assertEquals((Object)"DEF", allowedValues.get(1));
        Assert.assertEquals((Object)"VALUE WITH SPACES", allowedValues.get(2));
        Assert.assertEquals((Object)"VALUE WITH TRAILING SPACE ", allowedValues.get(3));
        propDef = this.service.getProperty(aspectOneQName, propQName);
        Assert.assertNotNull((Object)propDef);
        propConstraints = propDef.getConstraints();
        Assert.assertEquals((String)"Incorrect number of constraints", (long)1L, (long)propConstraints.size());
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)propConstraints.get(0)).getConstraint() instanceof ListOfValuesConstraint));
        constraint = (ListOfValuesConstraint)((ConstraintDefinition)propConstraints.get(0)).getConstraint();
        allowedValues = constraint.getAllowedValues();
        Assert.assertEquals((String)"Expected 1 allowed values", (long)1L, (long)allowedValues.size());
        Assert.assertEquals((Object)"HIJ", allowedValues.get(0));
        propDef = this.service.getProperty(aspectTwoQName, propQName);
        Assert.assertNotNull((Object)propDef);
        propConstraints = propDef.getConstraints();
        Assert.assertEquals((String)"Incorrect number of constraints", (long)2L, (long)propConstraints.size());
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)propConstraints.get(0)).getConstraint() instanceof ListOfValuesConstraint));
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)propConstraints.get(1)).getConstraint() instanceof ListOfValuesConstraint));
        constraint = (ListOfValuesConstraint)((ConstraintDefinition)propConstraints.get(0)).getConstraint();
        allowedValues = constraint.getAllowedValues();
        Assert.assertEquals((String)"Wrong number of allowed values", (long)4L, (long)allowedValues.size());
        Assert.assertEquals((Object)"ABC", allowedValues.get(0));
        Assert.assertEquals((Object)"DEF", allowedValues.get(1));
        Assert.assertEquals((Object)"VALUE WITH SPACES", allowedValues.get(2));
        Assert.assertEquals((Object)"VALUE WITH TRAILING SPACE ", allowedValues.get(3));
        constraint = (ListOfValuesConstraint)((ConstraintDefinition)propConstraints.get(1)).getConstraint();
        allowedValues = constraint.getAllowedValues();
        Assert.assertEquals((String)"Wrong number of allowed values", (long)1L, (long)allowedValues.size());
        Assert.assertEquals((Object)"HIJ", allowedValues.get(0));
        propDef = this.service.getProperty(aspectThreeQName, propQName);
        Assert.assertNotNull((Object)propDef);
        propConstraints = propDef.getConstraints();
        Assert.assertEquals((String)"Incorrect number of constraints", (long)1L, (long)propConstraints.size());
        Assert.assertTrue((String)"Constraint instance incorrect", (boolean)(((ConstraintDefinition)propConstraints.get(0)).getConstraint() instanceof ListOfValuesConstraint));
        constraint = (ListOfValuesConstraint)((ConstraintDefinition)propConstraints.get(0)).getConstraint();
        allowedValues = constraint.getAllowedValues();
        Assert.assertEquals((String)"Expected 1 allowed values", (long)1L, (long)allowedValues.size());
        Assert.assertEquals((Object)"XYZ", allowedValues.get(0));
    }

    @Test
    public void testArchive() {
        QName testFileQName = QName.createQName((String)TEST_URL, (String)"file");
        ClassDefinition fileClassDef = this.service.getClass(testFileQName);
        Assert.assertTrue((String)"File type should have the archive flag", (boolean)fileClassDef.getArchive());
        QName testFileDerivedQName = QName.createQName((String)TEST_URL, (String)"file-derived");
        ClassDefinition fileDerivedClassDef = this.service.getClass(testFileDerivedQName);
        Assert.assertTrue((String)"Direct derived File type should have the archive flag", (boolean)fileDerivedClassDef.getArchive());
        QName testFileDerivedNoArchiveQName = QName.createQName((String)TEST_URL, (String)"file-derived-no-archive");
        ClassDefinition fileDerivedNoArchiveClassDef = this.service.getClass(testFileDerivedNoArchiveQName);
        Assert.assertFalse((String)"Derived File with archive override type should NOT have the archive flag", (boolean)fileDerivedNoArchiveClassDef.getArchive());
        QName testFolderQName = QName.createQName((String)TEST_URL, (String)"folder");
        ClassDefinition folderClassDef = this.service.getClass(testFolderQName);
        Assert.assertNull((String)"Folder type should not have the archive flag", (Object)folderClassDef.getArchive());
    }

    @Test
    public void testMandatoryEnforced() {
        QName testEnforcedQName = QName.createQName((String)TEST_URL, (String)"enforced");
        ClassDefinition testEnforcedClassDef = this.service.getClass(testEnforcedQName);
        Map testEnforcedPropertyDefs = testEnforcedClassDef.getProperties();
        PropertyDefinition propertyDef = null;
        QName testMandatoryEnforcedQName = QName.createQName((String)TEST_URL, (String)"mandatory-enforced");
        propertyDef = (PropertyDefinition)testEnforcedPropertyDefs.get(testMandatoryEnforcedQName);
        Assert.assertNotNull((String)("Property not found: " + testMandatoryEnforcedQName), (Object)propertyDef);
        Assert.assertTrue((String)("Expected property to be mandatory: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatory());
        Assert.assertTrue((String)("Expected property to be mandatory-enforced: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryNotEnforcedQName = QName.createQName((String)TEST_URL, (String)"mandatory-not-enforced");
        propertyDef = (PropertyDefinition)testEnforcedPropertyDefs.get(testMandatoryNotEnforcedQName);
        Assert.assertNotNull((String)("Property not found: " + testMandatoryNotEnforcedQName), (Object)propertyDef);
        Assert.assertTrue((String)("Expected property to be mandatory: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatory());
        Assert.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryDefaultEnforcedQName = QName.createQName((String)TEST_URL, (String)"mandatory-default-enforced");
        propertyDef = (PropertyDefinition)testEnforcedPropertyDefs.get(testMandatoryDefaultEnforcedQName);
        Assert.assertNotNull((String)("Property not found: " + testMandatoryDefaultEnforcedQName), (Object)propertyDef);
        Assert.assertTrue((String)("Expected property to be mandatory: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatory());
        Assert.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
    }

    @Test
    public void testSubClassOf() {
        QName invalid = QName.createQName((String)TEST_URL, (String)"invalid");
        QName base = QName.createQName((String)TEST_URL, (String)"base");
        QName file = QName.createQName((String)TEST_URL, (String)"file");
        QName folder = QName.createQName((String)TEST_URL, (String)"folder");
        QName referenceable = QName.createQName((String)TEST_URL, (String)"referenceable");
        boolean testI1 = this.service.isSubClass(invalid, referenceable);
        Assert.assertFalse((boolean)testI1);
        boolean testI2 = this.service.isSubClass(referenceable, invalid);
        Assert.assertFalse((boolean)testI2);
        boolean testI3 = this.service.isSubClass(invalid, invalid);
        Assert.assertFalse((boolean)testI3);
        boolean test1 = this.service.isSubClass(file, referenceable);
        Assert.assertFalse((boolean)test1);
        boolean test2 = this.service.isSubClass(file, folder);
        Assert.assertFalse((boolean)test2);
        boolean test3 = this.service.isSubClass(file, file);
        Assert.assertTrue((boolean)test3);
        boolean test4 = this.service.isSubClass(folder, base);
        Assert.assertTrue((boolean)test4);
        boolean test5 = this.service.isSubClass(base, folder);
        Assert.assertFalse((boolean)test5);
    }

    @Test
    public void testPropertyOverride() {
        TypeDefinition type1 = this.service.getType(QName.createQName((String)TEST_URL, (String)"overridetype1"));
        Map props1 = type1.getProperties();
        PropertyDefinition prop1 = (PropertyDefinition)props1.get(QName.createQName((String)TEST_URL, (String)"propoverride"));
        String def1 = prop1.getDefaultValue();
        Assert.assertEquals((Object)"one", (Object)def1);
        TypeDefinition type2 = this.service.getType(QName.createQName((String)TEST_URL, (String)"overridetype2"));
        Map props2 = type2.getProperties();
        PropertyDefinition prop2 = (PropertyDefinition)props2.get(QName.createQName((String)TEST_URL, (String)"propoverride"));
        String def2 = prop2.getDefaultValue();
        Assert.assertEquals((Object)"two", (Object)def2);
        TypeDefinition type3 = this.service.getType(QName.createQName((String)TEST_URL, (String)"overridetype3"));
        Map props3 = type3.getProperties();
        PropertyDefinition prop3 = (PropertyDefinition)props3.get(QName.createQName((String)TEST_URL, (String)"propoverride"));
        String def3 = prop3.getDefaultValue();
        Assert.assertEquals((Object)"three", (Object)def3);
    }

    @Test
    public void testChildAssocPropagate() {
        AssociationDefinition assocDef = this.service.getAssociation(QName.createQName((String)TEST_URL, (String)"childassoc1"));
        Assert.assertNotNull((String)"No such child association found", (Object)assocDef);
        Assert.assertTrue((String)"Expected a child association", (boolean)(assocDef instanceof ChildAssociationDefinition));
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        Assert.assertFalse((String)"Expected 'false' for default timestamp propagation", (boolean)childAssocDef.getPropagateTimestamps());
        assocDef = this.service.getAssociation(QName.createQName((String)TEST_URL, (String)"childassocPropagate"));
        Assert.assertNotNull((String)"No such child association found", (Object)assocDef);
        Assert.assertTrue((String)"Expected a child association", (boolean)(assocDef instanceof ChildAssociationDefinition));
        childAssocDef = (ChildAssociationDefinition)assocDef;
        Assert.assertTrue((String)"Expected 'true' for timestamp propagation", (boolean)childAssocDef.getPropagateTimestamps());
    }

    @Test
    public void testBootstrapImportModelWithCircularTypes() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("org/alfresco/repo/dictionary/modelCircularTypes.xml");
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)tenantService);
        try {
            bootstrap.bootstrap();
            Assert.fail((String)"Bootstrap should fail as the model contains a cyclic refrence");
        }
        catch (DictionaryException e) {
            Assert.assertEquals((Object)e.getMsgId(), (Object)"d_dictionary.bootstrap.model_not_imported");
        }
    }

    @Test
    public void testCreateModelWithCircularTypeDependency() {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        String testNamespace = "http://www.alfresco.org/model/dictionary/1.0/my";
        M2Model model = M2Model.createModel((String)"my:circularModel");
        model.createNamespace(testNamespace, "my");
        M2Type typeA = model.createType("my:circularA");
        typeA.setParentName("my:circularC");
        M2Type typeB = model.createType("my:circularB");
        typeB.setParentName("my:circularA");
        M2Type typeC = model.createType("my:circularC");
        typeC.setParentName("my:circularB");
        try {
            dictionaryDAO.putModel(model);
            Assert.fail((String)"Model should not be saved successfully because it contains a cyclic reference");
        }
        catch (DictionaryException e) {
            Assert.assertEquals((Object)e.getMsgId(), (Object)"d_dictionary.compiled_model.err.compile.failure");
        }
    }
}

