/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.DataModelTestApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.xml.XMLConfigService;

public class MimetypeMapTest
extends TestCase {
    private static ApplicationContext ctx = DataModelTestApplicationContextHelper.getApplicationContext();
    private MimetypeService mimetypeService;
    private ConfigService configService;
    private static final String MIMETYPE_1A = "      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension ONE\">ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1B = "      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension 1\">ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1C = "      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension>ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1D = "      <mimetype mimetype=\"mimetype1\" display=\"Mimetype 1\">        <extension>ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1E = "      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_1F = "      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1a</extension>        <extension default=\"true\">ext1b</extension>        <extension>ext1c</extension>      </mimetype>";
    private static final String MIMETYPE_1G = "      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1c</extension>        <extension>ext1b</extension>        <extension>ext1a</extension>      </mimetype>";
    private static final String MIMETYPE_2A = "      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\" text=\"true\">        <extension>ext2a</extension>      </mimetype>";
    private static final String MIMETYPE_2B = "      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\">        <extension>ext2a</extension>      </mimetype>";
    private static final String MIMETYPE_3A = "      <mimetype mimetype=\"mimetype3\" display=\"Mimetype THREE\">        <extension>ext3a</extension>        <extension>ext3b</extension>      </mimetype>";

    public void setUp() throws Exception {
        this.mimetypeService = (MimetypeService)ctx.getBean("mimetypeService");
        this.configService = ((MimetypeMap)this.mimetypeService).getConfigService();
    }

    protected void tearDown() throws Exception {
        ((MimetypeMap)this.mimetypeService).setConfigService(this.configService);
        ((MimetypeMap)this.mimetypeService).setMimetypeJsonConfigDir(null);
        ((MimetypeMap)this.mimetypeService).init();
    }

    public void testExtensions() throws Exception {
        Map extensionsByMimetype = this.mimetypeService.getExtensionsByMimetype();
        Map mimetypesByExtension = this.mimetypeService.getMimetypesByExtension();
        MimetypeMapTest.assertEquals((String)"txt", (String)((String)extensionsByMimetype.get("text/plain")));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)((String)mimetypesByExtension.get("txt")));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)((String)mimetypesByExtension.get("ftl")));
        MimetypeMapTest.assertEquals((String)"text/csv", (String)((String)mimetypesByExtension.get("csv")));
        MimetypeMapTest.assertEquals((String)"text/html", (String)((String)mimetypesByExtension.get("html")));
        MimetypeMapTest.assertEquals((String)"jpg", (String)((String)extensionsByMimetype.get("image/jpeg")));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)((String)mimetypesByExtension.get("jpg")));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)((String)mimetypesByExtension.get("jpeg")));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)((String)mimetypesByExtension.get("jpe")));
        MimetypeMapTest.assertEquals((String)"doc", (String)((String)extensionsByMimetype.get("application/msword")));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)((String)mimetypesByExtension.get("doc")));
        MimetypeMapTest.assertEquals((String)"sds", (String)((String)extensionsByMimetype.get("application/vnd.stardivision.chart")));
    }

    public void testIsText() throws Exception {
        MimetypeMapTest.assertTrue((boolean)this.mimetypeService.isText("text/html"));
    }

    public void testGetContentCharsetFinder() throws Exception {
        MimetypeMapTest.assertNotNull((String)"No charset finder", (Object)this.mimetypeService.getContentCharsetFinder());
    }

    public void testMimetypeFromExtension() throws Exception {
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.getMimetype("doc"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.getMimetype("DOC"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.getMimetype(null));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.getMimetype("unknownext"));
    }

    public void testGuessMimetypeForFilename() throws Exception {
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.doc"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("SOMETHING.DOC"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("noextension"));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("file.unknownext"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.doc", (ContentReader)null));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("SOMETHING.DOC", (ContentReader)null));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("noextension", (ContentReader)null));
        MimetypeMapTest.assertEquals((String)"application/octet-stream", (String)this.mimetypeService.guessMimetype("file.unknownext", (ContentReader)null));
    }

    public void testNoDuplicates() throws Exception {
        this.setConfigService("      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension ONE\">ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\" text=\"true\">        <extension>ext2a</extension>      </mimetype>      <mimetype mimetype=\"mimetype3\" display=\"Mimetype THREE\">        <extension>ext3a</extension>        <extension>ext3b</extension>      </mimetype>");
        ((MimetypeMap)this.mimetypeService).init();
        MimetypeMapTest.assertFalse((String)"mimetype1 should not be text", (boolean)this.mimetypeService.isText("mimetype1"));
        MimetypeMapTest.assertEquals((String)"ext1a", (String)this.mimetypeService.getExtension("mimetype1"));
        MimetypeMapTest.assertEquals((String)"mimetype1", (String)this.mimetypeService.getMimetype("ext1a"));
        MimetypeMapTest.assertEquals((String)"Mimetype ONE", (String)((String)this.mimetypeService.getDisplaysByMimetype().get("mimetype1")));
        MimetypeMapTest.assertEquals((String)"Extension ONE", (String)((String)this.mimetypeService.getDisplaysByExtension().get("ext1a")));
        MimetypeMapTest.assertTrue((String)"mimetype2 should be text", (boolean)this.mimetypeService.isText("mimetype2"));
        MimetypeMapTest.assertEquals((String)"mimetype2", (String)this.mimetypeService.getMimetype("ext2a"));
        MimetypeMapTest.assertEquals((String)"mimetype3", (String)this.mimetypeService.getMimetype("ext3a"));
    }

    public void testTypes() throws Exception {
        Collection types = this.mimetypeService.getMimetypes(null);
        MimetypeMapTest.assertNotNull((Object)types);
        types = this.mimetypeService.getMimetypes("txt");
        MimetypeMapTest.assertNotNull((Object)types);
        MimetypeMapTest.assertNull((Object)this.mimetypeService.getMimetypeIfNotMatches((ContentReader)new DummyContentReader()));
    }

    public void testMisc() throws Exception {
        MimetypeMap m = new MimetypeMap(null);
        DummyContentReader reader = new DummyContentReader("video/quicktime");
        MimetypeMapTest.assertEquals((String)"text/plain", (String)this.mimetypeService.getMimetypeIfNotMatches((ContentReader)reader));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)this.mimetypeService.guessMimetype("file.rm", reader.getContentInputStream()));
        MimetypeMapTest.assertEquals((String)"video/quicktime", (String)this.mimetypeService.guessMimetype("file.rm", (ContentReader)reader));
    }

    public void testTypeBasedOnDetectedTypeAndExtension() throws Exception {
        DummyContentReader reader = new DummyContentReader("application/pdf", "%PDF\r");
        MimetypeMapTest.assertEquals((String)"application/illustrator", (String)this.mimetypeService.guessMimetype("file.ai", reader.getContentInputStream()));
        MimetypeMapTest.assertEquals((String)"application/pdf", (String)this.mimetypeService.guessMimetype("file.pdf", reader.getContentInputStream()));
        reader = new DummyContentReader("application/postscript", "%!PS");
        MimetypeMapTest.assertEquals((String)"application/eps", (String)this.mimetypeService.guessMimetype("file.eps", reader.getContentInputStream()));
        MimetypeMapTest.assertEquals((String)"application/postscript", (String)this.mimetypeService.guessMimetype("file.ps", reader.getContentInputStream()));
    }

    public void testDuplicates() throws Exception {
        this.setConfigService("      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension ONE\">ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension display=\"Extension 1\">ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" display=\"Mimetype ONE\">        <extension>ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" display=\"Mimetype 1\">        <extension>ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1a</extension>      </mimetype>      <mimetype mimetype=\"mimetype1\" text=\"true\">        <extension>ext1a</extension>        <extension default=\"true\">ext1b</extension>        <extension>ext1c</extension>      </mimetype>      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\" text=\"true\">        <extension>ext2a</extension>      </mimetype>      <mimetype mimetype=\"mimetype2\" display=\"Mimetype TWO\">        <extension>ext2a</extension>      </mimetype>      <mimetype mimetype=\"mimetype3\" display=\"Mimetype THREE\">        <extension>ext3a</extension>        <extension>ext3b</extension>      </mimetype>      <mimetype mimetype=\"mimetype3\" display=\"Mimetype THREE\">        <extension>ext3a</extension>        <extension>ext3b</extension>      </mimetype>");
        ((MimetypeMap)this.mimetypeService).init();
        MimetypeMapTest.assertTrue((String)"mimetype1 should have be reset to text", (boolean)this.mimetypeService.isText("mimetype1"));
        MimetypeMapTest.assertEquals((String)"ext1b", (String)this.mimetypeService.getExtension("mimetype1"));
        MimetypeMapTest.assertEquals((String)"mimetype1", (String)this.mimetypeService.getMimetype("ext1a"));
        MimetypeMapTest.assertEquals((String)"mimetype1", (String)this.mimetypeService.getMimetype("ext1b"));
        MimetypeMapTest.assertEquals((String)"mimetype1", (String)this.mimetypeService.getMimetype("ext1c"));
        MimetypeMapTest.assertEquals((String)"Mimetype 1", (String)((String)this.mimetypeService.getDisplaysByMimetype().get("mimetype1")));
        MimetypeMapTest.assertEquals((String)"Extension 1", (String)((String)this.mimetypeService.getDisplaysByExtension().get("ext1a")));
        MimetypeMapTest.assertFalse((String)"mimetype2 should have be reset to not text", (boolean)this.mimetypeService.isText("mimetype2"));
        MimetypeMapTest.assertEquals((String)"mimetype2", (String)this.mimetypeService.getMimetype("ext2a"));
        MimetypeMapTest.assertEquals((String)"mimetype3", (String)this.mimetypeService.getMimetype("ext3a"));
    }

    private void setConfigService(final String mimetypes) {
        ConfigSource configSource = new ConfigSource(){

            public List<ConfigDeployment> getConfigDeployments() {
                String xml = "<alfresco-config area=\"mimetype-map\">  <config evaluator=\"string-compare\" condition=\"Mimetype Map\">    <mimetypes>" + mimetypes + "    </mimetypes>  </config></alfresco-config>";
                ArrayList<ConfigDeployment> configs = new ArrayList<ConfigDeployment>();
                configs.add(new ConfigDeployment("name", (InputStream)new ByteArrayInputStream(xml.getBytes())));
                return configs;
            }
        };
        XMLConfigService configService = new XMLConfigService(configSource);
        configService.initConfig();
        ((MimetypeMap)this.mimetypeService).setConfigService((ConfigService)configService);
    }

    public void testJsonRead() throws Exception {
        int beforeCount = this.mimetypeService.getMimetypes().size();
        ((MimetypeMap)this.mimetypeService).setMimetypeJsonConfigDir("alfresco/test/mimetypes/testMimetype.json");
        ((MimetypeMap)this.mimetypeService).init();
        Map displaysByExtension = this.mimetypeService.getDisplaysByExtension();
        int afterCount = this.mimetypeService.getMimetypes().size();
        MimetypeMapTest.assertEquals((String)"There should be 2 more mimetypes from the JSON file", (int)(beforeCount + 2), (int)afterCount);
        String mimetype = "test audio/mp4";
        String defaultExtension = "test m4a";
        MimetypeMapTest.assertEquals((String)"Test MPEG4 Audio", (String)((String)displaysByExtension.get(defaultExtension)));
        MimetypeMapTest.assertEquals((String)defaultExtension, (String)this.mimetypeService.getExtension(mimetype));
        MimetypeMapTest.assertEquals((String)mimetype, (String)this.mimetypeService.getMimetype(defaultExtension));
        MimetypeMapTest.assertFalse((boolean)this.mimetypeService.isText(mimetype));
        mimetype = "test text/plain";
        defaultExtension = "test txt";
        MimetypeMapTest.assertEquals((String)"Test Plain Text", (String)((String)displaysByExtension.get(defaultExtension)));
        MimetypeMapTest.assertEquals((String)defaultExtension, (String)this.mimetypeService.getExtension(mimetype));
        MimetypeMapTest.assertEquals((String)mimetype, (String)this.mimetypeService.getMimetype(defaultExtension));
        MimetypeMapTest.assertEquals((String)mimetype, (String)this.mimetypeService.getMimetype("test sql"));
        MimetypeMapTest.assertEquals((String)mimetype, (String)this.mimetypeService.getMimetype("test properties"));
        MimetypeMapTest.assertEquals((String)mimetype, (String)this.mimetypeService.getMimetype("test log"));
        MimetypeMapTest.assertTrue((boolean)this.mimetypeService.isText(mimetype));
    }

    public static class DummyContentWriter
    implements ContentWriter {
        private String mimetype = "audio/mp4";

        public DummyContentWriter() {
        }

        public DummyContentWriter(String mimetype) {
            this.mimetype = mimetype;
        }

        public ContentReader getReader() throws ContentIOException {
            return new DummyContentReader();
        }

        public boolean isClosed() {
            return false;
        }

        public WritableByteChannel getWritableChannel() throws ContentIOException {
            return null;
        }

        public FileChannel getFileChannel(boolean truncate) throws ContentIOException {
            return null;
        }

        public OutputStream getContentOutputStream() throws ContentIOException {
            return null;
        }

        public void putContent(ContentReader reader) throws ContentIOException {
        }

        public void putContent(InputStream is) throws ContentIOException {
        }

        public void putContent(File file) throws ContentIOException {
        }

        public void putContent(String content) throws ContentIOException {
        }

        public void guessMimetype(String filename) {
        }

        public void guessEncoding() {
        }

        public boolean isChannelOpen() {
            return false;
        }

        public void addListener(ContentStreamListener listener) {
        }

        public long getSize() {
            return 5L;
        }

        public ContentData getContentData() {
            return null;
        }

        public String getContentUrl() {
            return null;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public void setMimetype(String mimetype) {
        }

        public String getEncoding() {
            return StandardCharsets.UTF_8.toString();
        }

        public void setEncoding(String encoding) {
        }

        public Locale getLocale() {
            return new Locale("es");
        }

        public void setLocale(Locale locale) {
        }
    }

    public static class DummyContentReader
    implements ContentReader {
        private String mimetype;
        private String content;

        public DummyContentReader() {
            this("text/html");
        }

        public DummyContentReader(String mimetype) {
            this(mimetype, "<X>@@/Y");
        }

        public DummyContentReader(String mimetype, String content) {
            this.mimetype = mimetype;
            this.content = content;
        }

        public ContentReader getReader() throws ContentIOException {
            return this;
        }

        public boolean exists() {
            return false;
        }

        public long getLastModified() {
            return 0L;
        }

        public boolean isClosed() {
            return false;
        }

        public ReadableByteChannel getReadableChannel() throws ContentIOException {
            return null;
        }

        public FileChannel getFileChannel() throws ContentIOException {
            return null;
        }

        public InputStream getContentInputStream() throws ContentIOException {
            return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
        }

        public void getContent(OutputStream os) throws ContentIOException {
        }

        public void getContent(File file) throws ContentIOException {
        }

        public String getContentString() throws ContentIOException {
            return null;
        }

        public String getContentString(int length) throws ContentIOException {
            return null;
        }

        public boolean isChannelOpen() {
            return false;
        }

        public void addListener(ContentStreamListener listener) {
        }

        public long getSize() {
            return 5L;
        }

        public ContentData getContentData() {
            return null;
        }

        public String getContentUrl() {
            return null;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public void setMimetype(String mimetype) {
        }

        public String getEncoding() {
            return StandardCharsets.UTF_8.toString();
        }

        public void setEncoding(String encoding) {
        }

        public Locale getLocale() {
            return null;
        }

        public void setLocale(Locale locale) {
        }
    }
}

