/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import org.alfresco.util.CompoundEnumeration;
import org.alfresco.util.LazyClassPathXmlApplicationContext;
import org.alfresco.util.NoAutoStartClassPathXmlApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public abstract class BaseApplicationContextHelper {
    private static ClassPathXmlApplicationContext instance;
    private static String[] usedConfiguration;
    private static String[] usedClassLocations;
    private static boolean useLazyLoading;
    private static boolean noAutoStart;

    public static synchronized ApplicationContext getApplicationContext(String[] configLocations) {
        if (configLocations == null) {
            throw new IllegalArgumentException("configLocations argument is mandatory.");
        }
        if (usedConfiguration != null && Arrays.deepEquals(configLocations, usedConfiguration)) {
            return instance;
        }
        BaseApplicationContextHelper.closeApplicationContext();
        instance = useLazyLoading || noAutoStart ? new VariableFeatureClassPathXmlApplicationContext(configLocations) : new ClassPathXmlApplicationContext(configLocations);
        usedConfiguration = configLocations;
        return instance;
    }

    public static ClassLoader buildClassLoader(String[] classLocations) throws IOException {
        ResourceFinder resolver = new ResourceFinder();
        Resource[] resources = resolver.getResources(classLocations);
        URL[] classpath = new URL[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            classpath[i] = resources[i].getURL();
        }
        return new URLClassLoader(classpath, Thread.currentThread().getContextClassLoader()){

            @Override
            public URL getResource(String name) {
                URL ret = this.findResource(name);
                return ret == null ? super.getResource(name) : ret;
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                Enumeration[] tmp = new Enumeration[]{this.findResources(name), super.getResources(name)};
                return new CompoundEnumeration<URL>(tmp);
            }
        };
    }

    public static synchronized ApplicationContext getApplicationContext(String[] configLocations, String[] classLocations) throws IOException {
        if (configLocations == null) {
            throw new IllegalArgumentException("configLocations argument is mandatory.");
        }
        if (usedConfiguration != null && Arrays.deepEquals(configLocations, usedConfiguration) && classLocations != null && Arrays.deepEquals(classLocations, usedClassLocations)) {
            return instance;
        }
        BaseApplicationContextHelper.closeApplicationContext();
        instance = useLazyLoading || noAutoStart ? new VariableFeatureClassPathXmlApplicationContext(configLocations) : new ClassPathXmlApplicationContext(configLocations, false);
        if (classLocations != null) {
            ClassLoader classLoader = BaseApplicationContextHelper.buildClassLoader(classLocations);
            instance.setClassLoader(classLoader);
        }
        instance.refresh();
        usedConfiguration = configLocations;
        usedClassLocations = classLocations;
        return instance;
    }

    public static synchronized void closeApplicationContext() {
        if (instance == null) {
            return;
        }
        instance.close();
        instance = null;
        usedConfiguration = null;
    }

    public static void setUseLazyLoading(boolean lazyLoading) {
        useLazyLoading = lazyLoading;
    }

    public static boolean isUsingLazyLoading() {
        return useLazyLoading;
    }

    public static void setNoAutoStart(boolean noAutoStart) {
        BaseApplicationContextHelper.noAutoStart = noAutoStart;
    }

    public static boolean isNoAutoStart() {
        return noAutoStart;
    }

    public static boolean isContextLoaded() {
        return instance != null;
    }

    static {
        useLazyLoading = false;
        noAutoStart = false;
    }

    public static class ResourceFinder
    extends ServletContextResourcePatternResolver {
        public ResourceFinder() {
            super((ResourceLoader)new DefaultResourceLoader());
        }

        public ResourceFinder(ResourceLoader resourceLoader) {
            super(resourceLoader);
        }

        public Resource[] getResources(String ... locationPatterns) throws IOException {
            LinkedList<Resource> resources = new LinkedList<Resource>();
            for (String locationPattern : locationPatterns) {
                resources.addAll(Arrays.asList(this.getResources(locationPattern)));
            }
            Resource[] resourceArray = new Resource[resources.size()];
            resources.toArray(resourceArray);
            return resourceArray;
        }
    }

    protected static class VariableFeatureClassPathXmlApplicationContext
    extends ClassPathXmlApplicationContext {
        protected VariableFeatureClassPathXmlApplicationContext(String[] configLocations) throws BeansException {
            super(configLocations);
        }

        protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
            super.initBeanDefinitionReader(reader);
            if (useLazyLoading) {
                LazyClassPathXmlApplicationContext.postInitBeanDefinitionReader(reader);
            }
            if (noAutoStart) {
                NoAutoStartClassPathXmlApplicationContext.postInitBeanDefinitionReader(reader);
            }
        }
    }
}

