/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.Collection;
import java.util.LinkedList;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistry;
import org.alfresco.opencmis.dictionary.DocumentTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.FolderTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.ItemTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PolicyTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.RelationshipTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.SecondaryTypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMISStrictDictionaryService
extends CMISAbstractDictionaryService {
    private Log logger = LogFactory.getLog(CMISStrictDictionaryService.class);
    public static final String DEFAULT = "DEFAULT_DICTIONARY";
    private CMISAbstractDictionaryService.DictionaryInitializer coreDictionaryInitializer;
    private CMISAbstractDictionaryService.DictionaryInitializer tenantDictionaryInitializer;

    public void init() {
        this.coreDictionaryInitializer = new CMISAbstractDictionaryService.DictionaryInitializer(){

            @Override
            public Collection<AbstractTypeDefinitionWrapper> createDefinitions(CMISDictionaryRegistry cmisRegistry) {
                LinkedList<AbstractTypeDefinitionWrapper> ret = new LinkedList<AbstractTypeDefinitionWrapper>();
                ret.addAll(CMISStrictDictionaryService.this.createTypeDefs(cmisRegistry, CMISStrictDictionaryService.this.dictionaryService.getAllTypes(true)));
                Collection<QName> assocQNames = CMISStrictDictionaryService.this.dictionaryService.getAllAssociations(true);
                String typeId = CMISStrictDictionaryService.this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_RELATIONSHIP, CMISMapping.RELATIONSHIP_QNAME);
                ClassDefinition classDef = CMISStrictDictionaryService.this.dictionaryService.getClass(CMISMapping.RELATIONSHIP_QNAME);
                if (classDef == null) {
                    if (assocQNames.size() != 0) {
                        CMISStrictDictionaryService.this.logger.warn((Object)("Unexpected - no class for " + CMISMapping.RELATIONSHIP_QNAME + " - cannot create assocDefs for: " + assocQNames));
                    }
                } else {
                    RelationshipTypeDefintionWrapper objectTypeDef = new RelationshipTypeDefintionWrapper(CMISStrictDictionaryService.this.cmisMapping, CMISStrictDictionaryService.this.accessorMapping, CMISStrictDictionaryService.this.luceneBuilderMapping, typeId, CMISStrictDictionaryService.this.dictionaryService, classDef);
                    cmisRegistry.registerTypeDefinition(objectTypeDef);
                    ret.add(objectTypeDef);
                    ret.addAll(CMISStrictDictionaryService.this.createAssocDefs(cmisRegistry, assocQNames));
                }
                ret.addAll(CMISStrictDictionaryService.this.createTypeDefs(cmisRegistry, CMISStrictDictionaryService.this.dictionaryService.getAllAspects(true)));
                return ret;
            }

            @Override
            public Collection<AbstractTypeDefinitionWrapper> createDefinitions(CMISDictionaryRegistry cmisRegistry, CompiledModel model) {
                AbstractTypeDefinitionWrapper objectTypeDef;
                QName classQName;
                LinkedList<AbstractTypeDefinitionWrapper> ret = new LinkedList<AbstractTypeDefinitionWrapper>();
                model.getClass(model.getTypes().iterator().next().getName());
                for (TypeDefinition typeDef : model.getTypes()) {
                    classQName = typeDef.getName();
                    objectTypeDef = CMISStrictDictionaryService.this.createTypeDef(classQName);
                    if (objectTypeDef == null) continue;
                    cmisRegistry.registerTypeDefinition(objectTypeDef);
                    ret.add(objectTypeDef);
                }
                for (AssociationDefinition assocDef : model.getAssociations()) {
                    classQName = assocDef.getName();
                    RelationshipTypeDefintionWrapper assocTypeDef = CMISStrictDictionaryService.this.createAssocDef(classQName);
                    if (assocTypeDef == null) continue;
                    cmisRegistry.registerTypeDefinition(assocTypeDef);
                    ret.add(assocTypeDef);
                }
                for (AspectDefinition aspectDef : model.getAspects()) {
                    classQName = aspectDef.getName();
                    objectTypeDef = CMISStrictDictionaryService.this.createTypeDef(classQName);
                    if (objectTypeDef == null) continue;
                    cmisRegistry.registerTypeDefinition(objectTypeDef);
                    ret.add(objectTypeDef);
                }
                return ret;
            }
        };
        this.tenantDictionaryInitializer = new CMISAbstractDictionaryService.DictionaryInitializer(){

            @Override
            public Collection<AbstractTypeDefinitionWrapper> createDefinitions(CMISDictionaryRegistry cmisRegistry) {
                LinkedList<AbstractTypeDefinitionWrapper> ret = new LinkedList<AbstractTypeDefinitionWrapper>();
                ret.addAll(CMISStrictDictionaryService.this.createTypeDefs(cmisRegistry, CMISStrictDictionaryService.this.dictionaryService.getAllTypes(false)));
                ret.addAll(CMISStrictDictionaryService.this.createAssocDefs(cmisRegistry, CMISStrictDictionaryService.this.dictionaryService.getAllAssociations(false)));
                ret.addAll(CMISStrictDictionaryService.this.createTypeDefs(cmisRegistry, CMISStrictDictionaryService.this.dictionaryService.getAllAspects(false)));
                return ret;
            }

            @Override
            public Collection<AbstractTypeDefinitionWrapper> createDefinitions(CMISDictionaryRegistry cmisRegistry, CompiledModel model) {
                AbstractTypeDefinitionWrapper objectTypeDef;
                QName classQName;
                LinkedList<AbstractTypeDefinitionWrapper> ret = new LinkedList<AbstractTypeDefinitionWrapper>();
                for (TypeDefinition typeDef : model.getTypes()) {
                    classQName = typeDef.getName();
                    objectTypeDef = CMISStrictDictionaryService.this.createTypeDef(classQName);
                    if (objectTypeDef == null) continue;
                    cmisRegistry.registerTypeDefinition(objectTypeDef);
                    ret.add(objectTypeDef);
                }
                for (AssociationDefinition assocDef : model.getAssociations()) {
                    classQName = assocDef.getName();
                    RelationshipTypeDefintionWrapper assocTypeDef = CMISStrictDictionaryService.this.createAssocDef(classQName);
                    if (assocTypeDef == null) continue;
                    cmisRegistry.registerTypeDefinition(assocTypeDef);
                    ret.add(assocTypeDef);
                }
                for (AspectDefinition aspectDef : model.getAspects()) {
                    classQName = aspectDef.getName();
                    objectTypeDef = CMISStrictDictionaryService.this.createTypeDef(classQName);
                    if (objectTypeDef == null) continue;
                    cmisRegistry.registerTypeDefinition(objectTypeDef);
                    ret.add(objectTypeDef);
                }
                return ret;
            }
        };
    }

    private AbstractTypeDefinitionWrapper createTypeDef(QName classQName) {
        AbstractTypeDefinitionWrapper objectTypeDef = null;
        if (!this.cmisMapping.isRemappedType(classQName)) {
            ClassDefinition classDef = this.dictionaryService.getClass(classQName);
            String typeId = null;
            if (this.cmisMapping.isValidCmisDocument(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_DOCUMENT, classQName);
                objectTypeDef = new DocumentTypeDefinitionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            } else if (this.cmisMapping.isValidCmisFolder(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_FOLDER, classQName);
                objectTypeDef = new FolderTypeDefintionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            } else if (this.cmisMapping.getCmisVersion().equals((Object)CmisVersion.CMIS_1_1) && this.cmisMapping.isValidCmisSecondaryType(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_SECONDARY, classQName);
                objectTypeDef = new SecondaryTypeDefinitionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            } else if (this.cmisMapping.isValidCmisPolicy(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_POLICY, classQName);
                objectTypeDef = new PolicyTypeDefintionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            } else if (this.cmisMapping.isValidCmisItem(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_ITEM, classQName);
                objectTypeDef = new ItemTypeDefinitionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            }
        }
        return objectTypeDef;
    }

    private Collection<AbstractTypeDefinitionWrapper> createTypeDefs(CMISDictionaryRegistry registry, Collection<QName> classQNames) {
        LinkedList<AbstractTypeDefinitionWrapper> ret = new LinkedList<AbstractTypeDefinitionWrapper>();
        for (QName classQName : classQNames) {
            AbstractTypeDefinitionWrapper objectTypeDef = this.createTypeDef(classQName);
            if (objectTypeDef == null) continue;
            registry.registerTypeDefinition(objectTypeDef);
            ret.add(objectTypeDef);
        }
        return ret;
    }

    private RelationshipTypeDefintionWrapper createAssocDef(QName classQName) {
        RelationshipTypeDefintionWrapper assocTypeDef = null;
        if (this.cmisMapping.isValidCmisRelationship(classQName)) {
            AssociationDefinition assocDef = this.dictionaryService.getAssociation(classQName);
            String typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_RELATIONSHIP, classQName);
            assocTypeDef = new RelationshipTypeDefintionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, assocDef);
        }
        return assocTypeDef;
    }

    private Collection<RelationshipTypeDefintionWrapper> createAssocDefs(CMISDictionaryRegistry registry, Collection<QName> classQNames) {
        LinkedList<RelationshipTypeDefintionWrapper> ret = new LinkedList<RelationshipTypeDefintionWrapper>();
        for (QName classQName : classQNames) {
            RelationshipTypeDefintionWrapper assocTypeDef = this.createAssocDef(classQName);
            if (assocTypeDef == null) continue;
            registry.registerTypeDefinition(assocTypeDef);
            ret.add(assocTypeDef);
        }
        return ret;
    }

    @Override
    protected CMISAbstractDictionaryService.DictionaryInitializer getCoreDictionaryInitializer() {
        return this.coreDictionaryInitializer;
    }

    @Override
    protected CMISAbstractDictionaryService.DictionaryInitializer getTenantDictionaryInitializer() {
        return this.tenantDictionaryInitializer;
    }
}

