/*
 * Copyright (C) 2005-2012 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.bm.user;

import org.alfresco.http.AbstractHttpRequestCallback;
import org.alfresco.json.JSONUtil;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/**
 * Callback that extracts the nodeRef from the picked user. Throws an exception
 * when no user can be extracted from the response.
 * 
 * @author Frederik Heremans
 */
public class PickUserCallback extends AbstractHttpRequestCallback<String>
{
    private String userName;

    public PickUserCallback(String userName)
    {
        this.userName = userName;
    }

    @Override
    public String onCallSuccess(HttpResponse response)
    {
        JSONObject data = JSONUtil.getDataFromResponse(response.getEntity());
        if (data == null)
        {
            StatusLine statusLine = response.getStatusLine();
            throw new RuntimeException(
                    "Response didn't contain any JSON-data: " +
                    (statusLine == null ? null : statusLine));
        }
        JSONArray items = JSONUtil.getArray(data, JSONUtil.JSON_ITEMS);
        if (items == null || items.size() == 0)
        {
            throw new RuntimeException("No items found in cm:person picker for user " + userName);
        }
        String nodeRef = JSONUtil.getString((JSONObject) items.get(0), CreateUser.PEOPLE_JSON_NODEREF, null);
        if (nodeRef == null)
        {
            throw new RuntimeException("No nodeRef found in cm:person picker for user " + userName);
        }

        return nodeRef;
    }

    @Override
    public String onCallException(HttpResponse response, Throwable t)
    {
        throw new RuntimeException("Error while picking user: " + userName, t);
    }
}
