package org.alfresco.bm.site;

import java.io.Serializable;

public class Status implements Serializable
{
    private static final long serialVersionUID = 7187248670785910438L;

    public static enum State
    {
        OK, ERROR;
    };

    private State state;
    private String error;

    public Status(State state)
    {
        this.state = state;
    }

    public Status(String error)
    {
        this.state = State.ERROR;
        this.error = error;
    }

    public static long getSerialversionuid() {
        return serialVersionUID;
    }

    public State getState()
    {
        return state;
    }

    public String getError()
    {
        return error;
    }

    @Override
    public String toString()
    {
        return "Status [state=" + state + ", error=" + error + "]";
    }
    
}
