package org.alfresco.bm.site;

import static org.junit.Assert.assertNotNull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/**
 * Data representing a site member.
 * 
 * @author steveglover
 *
 */
public class SiteMember implements Serializable
{
    private static final long serialVersionUID = 505331886661880389L;

    public static final String FIELD_USERNAME = "username";
    public static final String FIELD_SITE_ID = "siteId";
    public static final String FIELD_STATE = "status.state";
    public static final String FIELD_RANDOMIZER = "randomizer";
    public static final String FIELD_CREATED = "created";

    private boolean created = false;
    private String username;
    private String siteId;
    private SiteRole role;
    private Status status;
    private int randomizer;

    public SiteMember()
    {
        randomizer = (int)(Math.random() * 1E6);
    }

    public SiteMember(String username, String siteId, SiteRole role)
    {
        this();
        this.username = username;
        this.siteId = siteId;
        this.role = role;
    }
    
    public void setCreated(boolean created)
    {
        this.created = created;
    }

    public boolean isCreated()
    {
        return created;
    }

    public int getRandomizer()
    {
        return randomizer;
    }

    public String getUsername()
    {
        return username;
    }

    public void setUsername(String username)
    {
        this.username = username;
    }

    public void setRole(SiteRole role)
    {
        this.role = role;
    }

    public String getSiteId()
    {
        return siteId;
    }

    public void setSiteId(String siteId)
    {
        this.siteId = siteId;
    }

    public Status getStatus()
    {
        return status;
    }

    public void setStatus(Status status)
    {
        this.status = status;
    }

    public SiteRole getRole()
    {
        return role;
    }

    @Override
    public String toString()
    {
        return "SiteMember [siteId=" + siteId + ", role=" + role + ", status="
                + status + "]";
    }
    
    public static SiteMember parseSiteMember(String siteId, JSONObject jsonObject)
    {
        String id = (String)jsonObject.get("id");
        SiteRole role = SiteRole.valueOf((String)jsonObject.get("role"));
        SiteMember siteMember = new SiteMember(id, siteId, role);
        return siteMember;
    }

    public static List<SiteMember> parseSiteMembers(String siteId, JSONObject jsonObject)
    {
        List<SiteMember> siteMembers = new ArrayList<SiteMember>();

        JSONObject jsonList = (JSONObject)jsonObject.get("list");
        assertNotNull(jsonList);

        JSONArray jsonEntries = (JSONArray)jsonList.get("entries");
        assertNotNull(jsonEntries);

        for(int i = 0; i < jsonEntries.size(); i++)
        {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i++);
            JSONObject entry = (JSONObject)jsonEntry.get("entry");
            siteMembers.add(parseSiteMember(siteId, entry));
        }

        return siteMembers;
    }
    
    public static SiteMember parsePersonSite(String personId, JSONObject jsonObject)
    {
        JSONObject site = (JSONObject)jsonObject.get("site");
        SiteRole role = SiteRole.valueOf((String)jsonObject.get("role"));
        SiteMember siteMember = new SiteMember(personId, (String)site.get("id"), role);
        return siteMember;
    }
    
    public static List<SiteMember> parsePersonSites(String personId, JSONObject jsonObject)
    {
        List<SiteMember> siteMembers = new ArrayList<SiteMember>();

        JSONObject jsonList = (JSONObject)jsonObject.get("list");
        assertNotNull(jsonList);

        JSONArray jsonEntries = (JSONArray)jsonList.get("entries");
        assertNotNull(jsonEntries);

        for(int i = 0; i < jsonEntries.size(); i++)
        {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i++);
            JSONObject entry = (JSONObject)jsonEntry.get("entry");
            siteMembers.add(parsePersonSite(personId, entry));
        }

        return siteMembers;
    }

}
