package org.alfresco.bm.site;

import static org.junit.Assert.assertNotNull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/**
 * Data representing a site.
 * 
 * @author steveglover
 *
 */
public class SiteData implements Serializable
{
    private static final long serialVersionUID = -3774392026234649419L;

    public static final String FIELD_SITE_ID = "siteId";
    public static final String FIELD_CREATED = "created";
    public static final String FIELD_HAS_MEMBERS = "hasMembers";
    public static final String FIELD_RANDOMIZER = "randomizer";
    public static final String FIELD_NETWORKID = "networkId";

    private Boolean created = false;
    private String createdBy;
    private String networkId;
    private String siteId;
    private String sitePreset;
    private String title;
    private String description;
    private String visibility; // one of (PUBLIC,MODERATED,PRIVATE), defaults to PUBLIC
    private String type;
    private int randomizer;

    public SiteData()
    {
        randomizer = (int)(Math.random() * 1E6);
    }

    public SiteData(String siteId, String sitePreset, String title, String description, String visibility)
    {
        this();
        this.siteId = siteId;
        this.sitePreset = sitePreset;
        this.title = title;
        this.description = description;
        this.visibility = visibility;
    }
    
    public SiteData(String createdBy, String networkId,
            String siteId, String sitePreset, String title, String description,
            String visibility, String type)
    {
        this();
        this.createdBy = createdBy;
        this.networkId = networkId;
        this.siteId = siteId;
        this.sitePreset = sitePreset;
        this.title = title;
        this.description = description;
        this.visibility = visibility;
        this.type = type;
    }

    public int getRandomizer()
    {
        return randomizer;
    }

    public String getNetworkId()
    {
        return networkId;
    }

    public Boolean isCreated()
    {
        return created;
    }

    public void setCreated(Boolean created)
    {
        this.created = created;
    }

    public String getCreatedBy()
    {
        return createdBy;
    }

    public void setCreatedBy(String createdBy)
    {
        this.createdBy = createdBy;
    }

    public String getSiteId()
    {
        return siteId;
    }
    
    public String getSitePreset()
    {
        return sitePreset;
    }
    
    public String getTitle()
    {
        return title;
    }
    
    public String getDescription()
    {
        return description;
    }
    
    public String getVisibility() 
    {
        return visibility;
    }
    
    public String getType()
    {
        return type;
    }

    public void setNetworkId(String networkId)
    {
        this.networkId = networkId;
    }

    public void setSiteId(String siteId)
    {
        this.siteId = siteId;
    }

    public void setSitePreset(String sitePreset)
    {
        this.sitePreset = sitePreset;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    public void setVisibility(String visibility)
    {
        this.visibility = visibility;
    }

    public void setType(String type)
    {
        this.type = type;
    }

    @Override
    public String toString()
    {
        return "Site [networkId=" + networkId + ", siteId=" + siteId
                + ", sitePreset=" + sitePreset + ", title=" + title
                + ", description=" + description + ", visibility=" + visibility
                + ", type=" + type + "]";
    }
    
    public static SiteData parseSite(JSONObject jsonObject)
    {
        String siteId = (String)jsonObject.get("id");
        String sitePreset = (String)jsonObject.get("sitePreset");
        String title = (String)jsonObject.get("title");
        String description = (String)jsonObject.get("description");
        String visibility = (String)jsonObject.get("visibility");
        SiteData site = new SiteData(null, null, siteId, sitePreset, title, description, visibility, "st:site");
        return site;
    }
    
    public static List<SiteData> parseSites(JSONObject jsonObject)
    {
        List<SiteData> sites = new ArrayList<SiteData>();

        JSONObject jsonList = (JSONObject)jsonObject.get("list");
        assertNotNull(jsonList);

        JSONArray jsonEntries = (JSONArray)jsonList.get("entries");
        assertNotNull(jsonEntries);

        for(int i = 0; i < jsonEntries.size(); i++)
        {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i++);
            JSONObject entry = (JSONObject)jsonEntry.get("entry");
            sites.add(parseSite(entry));
        }

        return sites;
    }
    
}
