/*
 * Copyright (C) 2005-2012 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.bm.server;

/**
 * Define commonly-used constants
 * 
 * @author Derek Hulley
 * @since 1.0
 */
public interface ConfigConstants
{
    /**
     * An instruction to the main process on what action to take for the server.
     * 
     * @author Derek Hulley
     * @since 1.0
     */
    public enum RunState
    {
        /** The server will run and process benchmark events. */
        RUN,
        /** The server will run but without any benchmark processing. */
        PAUSE,
        /** Stop the server completely; requires a manual restart. */
        STOP,
        /** Restart the server; not an error condition. */
        RESTART;
    }
    

    public static final String DEFAULT_SERVER_ID = "unknown";
    public static final String DEFAULT_RUNSTATE = "STOP";
    
    public static final String SEPARATOR = "/";
    
    public static final String PROP_MONGO_URI = "mongo.URI";
    public static final String PROP_MONGO_AUTOCONNECTRETRY = "mongo.autoConnectRetry";
    public static final String PROP_MONGO_CONNECTIONSPERHOST = "mongo.connectionsPerHost";
    public static final String PROP_MONGO_SOCKETTIMEOUT = "mongo.socketTimeout";
    public static final String PROP_MONGO_WRITENUMBER = "mongo.writeNumber";
    
    public static final String PROP_EVENT_PROCESSOR_THREADS = "eventProcessorThreads";
    public static final String PROP_HTTP_CONNECTION_MAX = "http.connection.max";
    public static final String PROP_HTTP_CONNECTION_TIMEOUT_MS = "http.connection.timeoutMs";
    public static final String PROP_HTTP_SOCKET_TIMEOUT_MS = "http.socket.timeoutMs";
    public static final String PROP_HTTP_SOCKET_TTL_MS = "http.socket.ttlMs";

    public static final String PROP_CLUSTER = "cluster";
    public static final String PROP_SERVER_ID = "serverId";
    public static final String PROP_TEST_NAME = "testName";
    public static final String PROP_TEST_RUN_NAME = "testRunName";
    public static final String PROP_TEST_RUN_FQN = "testFQN";
    
    public static final String PROP_CONTROL_RUN_STATE = "runState";
    
    public static final String PATH_CLUSTERS = "clusters";
    public static final String PATH_CLUSTER_PROPERTIES = "cluster.properties";
    public static final String PATH_SERVERS = "servers";
    public static final String PATH_SERVER = "server";
    public static final String PATH_LOADED = "loaded";
    public static final String PATH_TESTS = "tests";
    public static final String PATH_RUNS = "runs";
    public static final String PATH_CONFIG = "config";
    public static final String PATH_TEST_CONTEXT = "test-context.xml";
    public static final String PATH_TEST_PROPERTIES = "test.properties";
    public static final String PATH_CLASSES = "classes";
    public static final String PATH_JARS = "jars";
    public static final String PATH_RUN_PROPERTIES = "run.properties";
    
    public static final String EXT_JAR = ".jar";
    public static final String EXT_XML = ".xml";
    public static final String EXT_PROPERTIES = ".properties";
}
