package org.alfresco.bm.event.selector;

/**
 * Information on an event successor, including the event name and a relative weighting.
 * 
 * @author steveglover
 *
 */
public class EventSuccessor
{
    // TODO convert eventName into the actual EventProcessor and update the context
    // file to have bean refs instead of event names. Advantage is invalid successor
    // event dependencies e.g. not existent will be caught at startup?
    private String eventName;
    private int weighting;
    
    public EventSuccessor(String eventName, int weighting)
    {
        super();
        this.eventName = eventName;
        this.weighting = weighting;
    }

    public String getEventName()
    {
        return eventName;
    }

    public int getWeighting()
    {
        return weighting;
    }

    @Override
    public String toString()
    {
        return "EventSuccessor [eventName=" + eventName + ", weighting="
                + weighting + "]";
    }
}
