package org.alfresco.bm.event.selector;

import java.io.Serializable;

/**
 * Represents a full response from an event processor:
 * a success/failure indication, a response message and the raw response data.
 *  
 * @author steveglover
 * @since 1.3
 */
public class EventProcessorResponse implements Serializable
{
    private static final long serialVersionUID = -5448572649585893282L;
    
    private String message;
    private boolean success;
    private Serializable responseData;

    /**
     * Constructor for an event response
     * 
     * @param message              any message associated with the response
     * @param success              whether the event processing was successful or not
     * @param responseData         any other data associated with the response
     */
    public EventProcessorResponse(String message, boolean success, Serializable responseData)
    {
        this.message = message;
        this.success = success;
        this.responseData = responseData;
    }
    
    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder();
        builder.append("EventProcessorResponse [message=");
        builder.append(message);
        builder.append(", success=");
        builder.append(success);
        builder.append(", responseData=");
        builder.append(responseData);
        builder.append("]");
        return builder.toString();
    }

    public String getMessage()
    {
        return message;
    }
    
    public boolean isSuccess()
    {
        return success;
    }
    
    public Serializable getResponseData()
    {
        return responseData;
    }
}
