package org.alfresco.bm.event.selector;

/**
 * Implemented by event processors using the event selector framework to generate input for the next event.
 * 
 * @author steveglover
 */
public interface EventDataCreator
{
    /**
     * Create a data object for use in a specific api call and return it. The data
     * can be based on the 'response' of the previous request, if required.
     * 
     * @param input         the input into the previous event
     * @param response      the response from the previous event
     * @return              the input into the next event or <tt>null</tt> to indicate that no
     *                      further event processing should occur
     *                      
     * TODO:    This contract is a bit ambiguous.  <tt>null</tt> could be valid data for the next
     *          event.  We should provide a positive means for the method to indicate termination.
     */
    Object createDataObject(Object input, Object response) throws Exception;
}
