package org.alfresco.bm.event.selector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.alfresco.bm.event.AbstractEventProcessor;
import org.alfresco.bm.event.Event;
import org.alfresco.bm.event.EventResult;

/**
 * Event processor that uses an eventSelector to choose the next event.
 * 
 * @author steveglover
 * @since 1.3
 */
public abstract class AbstractEventSelectorProcessor extends AbstractEventProcessor implements EventDataCreator
{
    private EventSelector eventSelector;
    private boolean persistResponse = false;

    public AbstractEventSelectorProcessor(EventSelector eventSelector)
    {
        super();
        this.eventSelector = eventSelector;
    }

    /**
     * @param persistResponse          <tt>true</tt> to persist the entire response including the data
     *                                 or <tt>false</tt> just to persist the response message
     */
    public void setPersistResponse(boolean persistResponse) 
    {
        this.persistResponse = persistResponse;
    }

    protected abstract EventProcessorResponse processEventImpl(Object input) throws Exception;

    @Override
    public EventResult processEvent(Event event) throws Exception
    {
        Object input = event.getDataObject();
        List<Event> nextEvents = new ArrayList<Event>();

        EventProcessorResponse response = processEventImpl(input);
        if(response.isSuccess() && eventSelector != null)
        {
            Serializable responseData = response.getResponseData();
            Event evt = eventSelector.nextEvent(input, responseData);
            if(evt != null)
            {
                nextEvents.add(evt);
            }
        }

        Serializable data = (persistResponse ? response : response.getMessage());
        EventResult result = new EventResult(
                data,
                nextEvents,
                response.isSuccess());
        return result;
    }
}
