/*
 * Copyright (C) 2005-2012 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */
package org.alfresco.bm.event;

import java.util.ArrayList;
import java.util.List;

/**
 * Raises the prescribed number of event with the given event name.
 * 
 * @author Derek Hulley
 * @since 1.0
 */
public class RaiseEventsEventProcessor extends AbstractEventProcessor
{
    private final String outputEventName;
    private final int outputEventCount;
    
    /**
     * Constructor with <b>essential</b> values
     * 
     * @param outputEventName           the event name to output
     * @param outputEventCount          the number of events to emit
     */
    public RaiseEventsEventProcessor(String outputEventName, int outputEventCount)
    {
        super();
        this.outputEventName = outputEventName;
        this.outputEventCount = outputEventCount;
    }

    @Override
    public EventResult processEvent(Event event) throws Exception
    {
        List<Event> nextEvents = new ArrayList<Event>(outputEventCount);
        for (int i = 0; i < outputEventCount; i++)
        {
            Event nextEvent = new Event(outputEventName, 0L, event.getDataObject());
            nextEvents.add(nextEvent);
        }
        // That's it
        EventResult result = new EventResult(nextEvents);
        // Done
        return result;
    }
}
