package org.alfresco.bm;

import org.alfresco.bm.site.SiteDataService;
import org.alfresco.bm.user.UserDataService;

/**
 * Bundle up services into a handy single access point.
 * 
 * @author steveglover
 *
 */
public class Services
{
    private UserDataService userDataService;
    private SiteDataService siteDataService;

    public Services(UserDataService userDataService, SiteDataService siteDataService)
    {
        this.userDataService = userDataService;
        this.siteDataService = siteDataService;
    }

    public UserDataService getUserDataService()
    {
        return userDataService;
    }
    
    public SiteDataService getSiteDataService()
    {
        return siteDataService;
    }

    public void setUserDataService(UserDataService userDataService)
    {
        this.userDataService = userDataService;
    }

    public void setSiteDataService(SiteDataService siteDataService)
    {
        this.siteDataService = siteDataService;
    }
}
