/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.authentication.handler;

import feign.CollectionFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.validation.Valid;
import org.alfresco.authentication.model.Error;
import org.alfresco.authentication.model.TicketBody;
import org.alfresco.authentication.model.TicketEntry;
import org.alfresco.authentication.model.ValidTicketEntry;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="Authentication")
public interface AuthenticationApi {
    @ApiOperation(value="Create ticket (login)", nickname="createTicket", notes="**Note:** this endpoint is available in Alfresco 5.2 and newer versions.  Logs in and returns the new authentication ticket.  The userId and password properties are mandatory in the request body. For example: ```JSON {     \"userId\": \"jbloggs\",     \"password\": \"password\" } ``` To use the ticket in future requests you should pass it in the request header. For example using Javascript:   ```Javascript     request.setRequestHeader (\"Authorization\", \"Basic \" + btoa(ticket));   ``` ", response=TicketEntry.class, authorizations={@Authorization(value="basicAuth")}, tags={"authentication"})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful response", response=TicketEntry.class), @ApiResponse(code=400, message="**userId** or **password** is not provided "), @ApiResponse(code=403, message="Login failed"), @ApiResponse(code=501, message="SAML is enabled and enforced"), @ApiResponse(code=200, message="Unexpected error", response=Error.class)})
    @RequestMapping(value={"/tickets"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<TicketEntry> createTicket(@ApiParam(value="The user credential.", required=true) @Valid @RequestBody TicketBody var1);

    @ApiOperation(value="Delete ticket (logout)", nickname="deleteTicket", notes="**Note:** this endpoint is available in Alfresco 5.2 and newer versions.  Deletes logged in ticket (logout). ", authorizations={@Authorization(value="basicAuth")}, tags={"authentication"})
    @ApiResponses(value={@ApiResponse(code=204, message="Successful response"), @ApiResponse(code=400, message="URL path does not include **-me-** or the ticket is not provided by the Authorization header"), @ApiResponse(code=404, message="Status of the user has changed (for example, the user is locked or the account is disabled) or the ticket has expired"), @ApiResponse(code=200, message="Unexpected error", response=Error.class)})
    @RequestMapping(value={"/tickets/-me-"}, produces={"application/json"}, consumes={""}, method={RequestMethod.DELETE})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> deleteTicket();

    @ApiOperation(value="Validate ticket", nickname="validateTicket", notes="**Note:** this endpoint is available in Alfresco 5.2 and newer versions.  Validates the specified ticket (derived from Authorization header) is still valid.  For example, you can pass the Authorization request header using Javascript:   ```Javascript     request.setRequestHeader (\"Authorization\", \"Basic \" + btoa(ticket));   ``` ", response=ValidTicketEntry.class, authorizations={@Authorization(value="basicAuth")}, tags={"authentication"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful response", response=ValidTicketEntry.class), @ApiResponse(code=400, message="URL path does not include **-me-** or the ticket is not provided by the Authorization header"), @ApiResponse(code=401, message="Authentication failed"), @ApiResponse(code=404, message="The request is authorized correctly but the status of the user (of the supplied ticket) has changed (for example, the user is locked or the account is disabled) or the ticket has expired"), @ApiResponse(code=200, message="Unexpected error", response=Error.class)})
    @RequestMapping(value={"/tickets/-me-"}, produces={"application/json"}, consumes={""}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ValidTicketEntry> validateTicket();
}

