/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser.ContextParser;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionPathContextParser
extends ContextParser {
    private static final Log log = LogFactory.getLog(SectionPathContextParser.class);
    private static final String INVOCATION_PREFIX = "section:";

    @Override
    public String execute(NodeRef context, String invocation) {
        NodeRef rootOfPath;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing invocation \"" + invocation + "\" on node context " + context));
        }
        String result = null;
        String path = invocation.substring(INVOCATION_PREFIX.length());
        String[] pathSegments = path.split("/");
        int pathSegmentIndex = 0;
        if (pathSegments.length > 0 && pathSegments[0].length() == 0) {
            rootOfPath = this.siteHelper.getRelevantWebRoot(context);
            pathSegmentIndex = 1;
        } else {
            rootOfPath = this.siteHelper.getRelevantSection(context);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Root of path resolved to noderef " + rootOfPath));
        }
        NodeRef currentNode = rootOfPath;
        while (currentNode != null && pathSegmentIndex < pathSegments.length) {
            String segment = pathSegments[pathSegmentIndex];
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing path segment " + segment));
            }
            if (!".".equals(segment) && segment.length() != 0) {
                currentNode = "..".equals(segment) ? this.siteHelper.getRelevantSection(currentNode, false) : this.nodeService.getChildByName(currentNode, ContentModel.ASSOC_CONTAINS, segment);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Path segment " + segment + " has resolved to node " + currentNode));
            }
            ++pathSegmentIndex;
        }
        if (currentNode != null) {
            result = currentNode.toString();
        }
        return result;
    }

    @Override
    public boolean canHandle(String invocation) {
        return invocation.startsWith(INVOCATION_PREFIX);
    }

    @Override
    public String execute(NodeRef context) {
        return this.execute(context, INVOCATION_PREFIX);
    }
}

